/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.block.plate;

import cofh.api.tileentity.IRedstoneControl;
import cofh.core.network.PacketCoFHBase;
import cofh.core.util.CoreUtils;
import cofh.lib.util.helpers.MathHelper;
import cofh.lib.util.helpers.ServerHelper;
import cofh.thermalexpansion.block.plate.BlockPlate;
import cofh.thermalexpansion.block.plate.TilePlateBase;
import cofh.thermalexpansion.gui.client.plate.GuiPlateTranslocate;
import cofh.thermalexpansion.gui.container.ContainerTEBase;
import cofh.thermalexpansion.network.PacketTEBase;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class TilePlateTranslocate
extends TilePlateBase
implements IRedstoneControl {
    public static final byte MIN_DISTANCE = 0;
    public static final byte MAX_DISTANCE = 16;
    public byte distance = (byte)16;
    protected boolean isPowered;
    protected IRedstoneControl.ControlMode rsMode = IRedstoneControl.ControlMode.DISABLED;

    public static void initialize() {
        GameRegistry.registerTileEntity(TilePlateTranslocate.class, (String)"cofh.thermalexpansion.PlateTranslocate");
    }

    public TilePlateTranslocate() {
        super(BlockPlate.Types.TRANSLOCATE);
    }

    @Override
    public void onEntityCollidedWithBlock(Entity entity) {
        int n;
        int n2;
        int n3;
        Block block;
        if (!this.redstoneControlOrDisable()) {
            return;
        }
        int[] nArray = this.getVector(this.distance);
        double d = (double)(((TileEntity)this).field_145851_c + nArray[0]) + 0.5;
        double d2 = (double)(((TileEntity)this).field_145848_d + nArray[1]) + 0.125;
        double d3 = (double)(((TileEntity)this).field_145849_e + nArray[2]) + 0.5;
        if (!(entity instanceof EntityLivingBase) && entity.func_70046_E() == null) {
            d = entity.field_70165_t + (double)nArray[0];
            d2 = entity.field_70163_u + (double)nArray[1];
            d3 = entity.field_70161_v + (double)nArray[2];
        }
        if (!(block = ((TileEntity)this).field_145850_b.func_147439_a(n3 = ((TileEntity)this).field_145851_c + nArray[0], n2 = ((TileEntity)this).field_145848_d + nArray[1], n = ((TileEntity)this).field_145849_e + nArray[2])).func_149662_c() && !block.func_149688_o().func_76220_a()) {
            if (entity instanceof EntityLivingBase) {
                if (((TileEntity)this).field_145850_b.field_72995_K) {
                    return;
                }
                CoreUtils.teleportEntityTo((EntityLivingBase)((EntityLivingBase)entity), (double)d, (double)d2, (double)d3, (boolean)true);
            } else {
                entity.func_70012_b(d, d2, d3, entity.field_70177_z, entity.field_70125_A);
                entity.field_70170_p.func_72956_a(entity, "mob.endermen.portal", 0.5f, 1.0f);
            }
        }
    }

    @Override
    protected boolean readPortableTagInternal(EntityPlayer entityPlayer, NBTTagCompound nBTTagCompound) {
        this.distance = nBTTagCompound.func_74771_c("Dist");
        return true;
    }

    @Override
    protected boolean writePortableTagInternal(EntityPlayer entityPlayer, NBTTagCompound nBTTagCompound) {
        nBTTagCompound.func_74774_a("Dist", this.distance);
        return true;
    }

    public Object getGuiClient(InventoryPlayer inventoryPlayer) {
        return new GuiPlateTranslocate(inventoryPlayer, (TileEntity)this);
    }

    public Object getGuiServer(InventoryPlayer inventoryPlayer) {
        return new ContainerTEBase(inventoryPlayer, (TileEntity)this, false, false);
    }

    @Override
    public void func_145839_a(NBTTagCompound nBTTagCompound) {
        super.func_145839_a(nBTTagCompound);
        this.distance = nBTTagCompound.func_74771_c("Dist");
    }

    @Override
    public void func_145841_b(NBTTagCompound nBTTagCompound) {
        super.func_145841_b(nBTTagCompound);
        nBTTagCompound.func_74774_a("Dist", this.distance);
    }

    @Override
    public PacketCoFHBase getPacket() {
        PacketCoFHBase packetCoFHBase = super.getPacket();
        packetCoFHBase.addByte(this.distance);
        return packetCoFHBase;
    }

    @Override
    public PacketCoFHBase getGuiPacket() {
        PacketCoFHBase packetCoFHBase = super.getGuiPacket();
        packetCoFHBase.addByte(this.distance);
        return packetCoFHBase;
    }

    @Override
    public PacketCoFHBase getModePacket() {
        PacketCoFHBase packetCoFHBase = super.getModePacket();
        packetCoFHBase.addByte(MathHelper.clamp((int)this.distance, (int)0, (int)16));
        return packetCoFHBase;
    }

    @Override
    protected void handleGuiPacket(PacketCoFHBase packetCoFHBase) {
        super.handleGuiPacket(packetCoFHBase);
        this.distance = packetCoFHBase.getByte();
    }

    @Override
    protected void handleModePacket(PacketCoFHBase packetCoFHBase) {
        super.handleModePacket(packetCoFHBase);
        byte by = packetCoFHBase.getByte();
        if (by != this.distance) {
            this.distance = by;
        }
    }

    @Override
    public void handleTilePacket(PacketCoFHBase packetCoFHBase, boolean bl) {
        super.handleTilePacket(packetCoFHBase, bl);
        if (!bl) {
            this.distance = packetCoFHBase.getByte();
        } else {
            packetCoFHBase.getByte();
        }
    }

    public void onNeighborBlockChange() {
        this.setPowered(((TileEntity)this).field_145850_b.func_72864_z(((TileEntity)this).field_145851_c, ((TileEntity)this).field_145848_d, ((TileEntity)this).field_145849_e));
    }

    public final boolean redstoneControlOrDisable() {
        return this.rsMode.isDisabled() || this.isPowered == this.rsMode.getState();
    }

    public final void setPowered(boolean bl) {
        boolean bl2 = this.isPowered;
        this.isPowered = bl;
        if (bl2 != this.isPowered) {
            if (ServerHelper.isClientWorld((World)((TileEntity)this).field_145850_b)) {
                ((TileEntity)this).field_145850_b.func_147471_g(((TileEntity)this).field_145851_c, ((TileEntity)this).field_145848_d, ((TileEntity)this).field_145849_e);
            } else {
                PacketTEBase.sendRSPowerUpdatePacketToClients(this, ((TileEntity)this).field_145850_b, ((TileEntity)this).field_145851_c, ((TileEntity)this).field_145848_d, ((TileEntity)this).field_145849_e);
            }
        }
    }

    public final boolean isPowered() {
        return this.isPowered;
    }

    public final void setControl(IRedstoneControl.ControlMode controlMode) {
        this.rsMode = controlMode;
        if (ServerHelper.isClientWorld((World)((TileEntity)this).field_145850_b)) {
            PacketTEBase.sendRSConfigUpdatePacketToServer(this, ((TileEntity)this).field_145851_c, ((TileEntity)this).field_145848_d, ((TileEntity)this).field_145849_e);
        } else {
            this.sendUpdatePacket(Side.CLIENT);
            boolean bl = this.isPowered;
            this.isPowered = !bl;
            this.setPowered(bl);
        }
    }

    public final IRedstoneControl.ControlMode getControl() {
        return this.rsMode;
    }
}

