/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.block.dynamo;

import cofh.core.CoFHProps;
import cofh.core.network.PacketCoFHBase;
import cofh.core.util.fluid.FluidTankAdv;
import cofh.lib.inventory.ComparableItemStack;
import cofh.lib.util.helpers.ItemHelper;
import cofh.thermalexpansion.block.dynamo.BlockDynamo;
import cofh.thermalexpansion.block.dynamo.TileDynamoBase;
import cofh.thermalexpansion.gui.client.dynamo.GuiDynamoReactant;
import cofh.thermalexpansion.gui.container.dynamo.ContainerDynamoReactant;
import cpw.mods.fml.common.registry.GameRegistry;
import gnu.trove.map.hash.TObjectIntHashMap;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileDynamoReactant
extends TileDynamoBase
implements IFluidHandler {
    static final int TYPE = BlockDynamo.Types.REACTANT.ordinal();
    FluidTankAdv tank = new FluidTankAdv(4000);
    FluidStack renderFluid = new FluidStack(FluidRegistry.LAVA, 1000);
    int reactantRF;
    int currentReactantRF;
    int reactantMod = 100;
    static int sugarRF = 16000;
    static int gunpowderRF = 160000;
    static int blazePowderRF = 640000;
    static int ghastTearRF = 1600000;
    static int netherStarRF = 6400000;
    static TObjectIntHashMap<Fluid> fuels = new TObjectIntHashMap();
    static TObjectIntHashMap<ComparableItemStack> reactants = new TObjectIntHashMap();

    public static void initialize() {
        GameRegistry.registerTileEntity(TileDynamoReactant.class, (String)"thermalexpansion.DynamoReactant");
    }

    public TileDynamoReactant() {
        this.inventory = new ItemStack[1];
    }

    public int getType() {
        return TYPE;
    }

    @Override
    protected boolean canGenerate() {
        if (this.fuelRF > 0) {
            return this.reactantRF > 0 || TileDynamoReactant.getReactantEnergy(this.inventory[0]) > 0;
        }
        if (this.reactantRF > 0) {
            return this.tank.getFluidAmount() >= 50;
        }
        return this.tank.getFluidAmount() >= 50 && TileDynamoReactant.getReactantEnergy(this.inventory[0]) > 0;
    }

    @Override
    protected void generate() {
        int n;
        if (this.fuelRF <= 0) {
            this.fuelRF = TileDynamoReactant.getFuelEnergy(this.tank.getFluid()) * this.reactantMod / 100 * this.fuelMod / 100;
            this.tank.drain(50, true);
        }
        if (this.reactantRF <= 0) {
            n = TileDynamoReactant.getReactantEnergy(this.inventory[0]) / 100 * this.fuelMod;
            this.reactantMod = TileDynamoReactant.getReactantMod(this.inventory[0]);
            this.reactantRF += n;
            this.currentReactantRF = n;
            this.inventory[0] = ItemHelper.consumeItem((ItemStack)this.inventory[0]);
        }
        n = this.calcEnergy() * this.energyMod;
        this.energyStorage.modifyEnergyStored(n);
        this.fuelRF -= n;
        this.reactantRF -= n;
    }

    @Override
    public IIcon getActiveIcon() {
        return this.renderFluid.getFluid().getIcon();
    }

    public Object getGuiClient(InventoryPlayer inventoryPlayer) {
        return new GuiDynamoReactant(inventoryPlayer, (TileEntity)this);
    }

    public Object getGuiServer(InventoryPlayer inventoryPlayer) {
        return new ContainerDynamoReactant(inventoryPlayer, (TileEntity)this);
    }

    @Override
    public int getScaledDuration(int n) {
        if (this.currentReactantRF <= 0) {
            this.currentReactantRF = sugarRF;
        }
        return this.reactantRF * n / this.currentReactantRF;
    }

    @Override
    public FluidTankAdv getTank(int n) {
        return this.tank;
    }

    @Override
    public void func_145839_a(NBTTagCompound nBTTagCompound) {
        super.func_145839_a(nBTTagCompound);
        this.currentReactantRF = nBTTagCompound.func_74762_e("ReactMax");
        this.reactantRF = nBTTagCompound.func_74762_e("React");
        this.tank.readFromNBT(nBTTagCompound);
        if (!TileDynamoReactant.isValidFuel(this.tank.getFluid())) {
            this.tank.setFluid(null);
        }
        if (this.tank.getFluid() != null) {
            this.renderFluid = this.tank.getFluid();
        }
        if (this.currentReactantRF <= 0) {
            this.currentReactantRF = sugarRF;
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nBTTagCompound) {
        super.func_145841_b(nBTTagCompound);
        nBTTagCompound.func_74768_a("ReactMax", this.currentReactantRF);
        nBTTagCompound.func_74768_a("React", this.reactantRF);
        this.tank.writeToNBT(nBTTagCompound);
    }

    @Override
    public PacketCoFHBase getPacket() {
        PacketCoFHBase packetCoFHBase = super.getPacket();
        packetCoFHBase.addFluidStack(this.tank.getFluid());
        return packetCoFHBase;
    }

    @Override
    public PacketCoFHBase getGuiPacket() {
        PacketCoFHBase packetCoFHBase = super.getGuiPacket();
        packetCoFHBase.addFluidStack(this.tank.getFluid());
        packetCoFHBase.addInt(this.reactantRF);
        packetCoFHBase.addInt(this.currentReactantRF);
        return packetCoFHBase;
    }

    @Override
    protected void handleGuiPacket(PacketCoFHBase packetCoFHBase) {
        super.handleGuiPacket(packetCoFHBase);
        this.tank.setFluid(packetCoFHBase.getFluidStack());
        this.reactantRF = packetCoFHBase.getInt();
        this.currentReactantRF = packetCoFHBase.getInt();
    }

    @Override
    public void handleTilePacket(PacketCoFHBase packetCoFHBase, boolean bl) {
        super.handleTilePacket(packetCoFHBase, bl);
        this.renderFluid = packetCoFHBase.getFluidStack();
        if (this.renderFluid == null) {
            this.renderFluid = new FluidStack(FluidRegistry.LAVA, 1000);
        }
    }

    public int fill(ForgeDirection forgeDirection, FluidStack fluidStack, boolean bl) {
        if (fluidStack == null || !this.augmentCoilDuct && forgeDirection.ordinal() == this.facing) {
            return 0;
        }
        if (TileDynamoReactant.isValidFuel(fluidStack)) {
            return this.tank.fill(fluidStack, bl);
        }
        return 0;
    }

    public FluidStack drain(ForgeDirection forgeDirection, FluidStack fluidStack, boolean bl) {
        if (fluidStack == null || !this.augmentCoilDuct && forgeDirection.ordinal() == this.facing) {
            return null;
        }
        if (TileDynamoReactant.isValidFuel(fluidStack)) {
            return this.tank.drain(fluidStack.amount, bl);
        }
        return null;
    }

    public FluidStack drain(ForgeDirection forgeDirection, int n, boolean bl) {
        if (!this.augmentCoilDuct && forgeDirection.ordinal() == this.facing) {
            return null;
        }
        return this.tank.drain(n, bl);
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection forgeDirection) {
        return new FluidTankInfo[]{this.tank.getInfo()};
    }

    @Override
    public boolean func_94041_b(int n, ItemStack itemStack) {
        return TileDynamoReactant.getReactantEnergy(itemStack) > 0;
    }

    @Override
    public int[] func_94128_d(int n) {
        return n != this.facing || this.augmentCoilDuct ? TileDynamoBase.SLOTS : CoFHProps.EMPTY_INVENTORY;
    }

    public static boolean isValidFuel(FluidStack fluidStack) {
        return fluidStack == null ? false : fuels.containsKey((Object)fluidStack.getFluid());
    }

    public static boolean isValidReactant(ItemStack itemStack) {
        return itemStack == null ? false : reactants.containsKey((Object)new ComparableItemStack(itemStack));
    }

    public static boolean addFuel(Fluid fluid, int n) {
        if (fluid == null || n < 10000 || n > 200000000) {
            return false;
        }
        fuels.put((Object)fluid, n / 20);
        return true;
    }

    public static boolean addReactant(ItemStack itemStack, int n) {
        if (itemStack == null || n < 10000 || n > 200000000) {
            return false;
        }
        reactants.put((Object)new ComparableItemStack(itemStack), n);
        return true;
    }

    public static boolean removeFuel(Fluid fluid) {
        fuels.remove((Object)fluid);
        return true;
    }

    public static boolean removeReactant(ItemStack itemStack) {
        reactants.remove((Object)itemStack);
        return true;
    }

    public static int getFuelEnergy(FluidStack fluidStack) {
        return fluidStack == null ? 0 : fuels.get((Object)fluidStack.getFluid());
    }

    public static int getReactantEnergy(ItemStack itemStack) {
        return itemStack == null ? 0 : reactants.get((Object)new ComparableItemStack(itemStack));
    }

    public static int getReactantMod(ItemStack itemStack) {
        if (itemStack == null) {
            return 0;
        }
        return 100;
    }

    static {
        TileDynamoReactant.addReactant(new ItemStack(Items.field_151102_aT, 1, 0), 16000);
        TileDynamoReactant.addReactant(new ItemStack(Items.field_151016_H, 1, 0), 160000);
        TileDynamoReactant.addReactant(new ItemStack(Items.field_151065_br, 1, 0), 640000);
        TileDynamoReactant.addReactant(new ItemStack(Items.field_151073_bk, 1, 0), 1600000);
        TileDynamoReactant.addReactant(new ItemStack(Items.field_151156_bN, 1, 0), 6400000);
    }
}

