/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.gen.terrain.highlands;

import rtg.util.CellNoise;
import rtg.util.OpenSimplexNoise;
import rtg.world.gen.terrain.TerrainBase;

public class TerrainHLGlacier
extends TerrainBase {
    private float hHeight;
    private float hWidth;
    private float vHeight;
    private float vWidth;
    private float bHeight;

    public TerrainHLGlacier(float hillHeight, float hillWidth, float varHeight, float varWidth, float baseHeight) {
        this.hHeight = hillHeight;
        this.hWidth = hillWidth;
        this.vHeight = varHeight;
        this.vWidth = varWidth;
        this.bHeight = baseHeight;
    }

    @Override
    public float generateNoise(OpenSimplexNoise simplex, CellNoise cell, int x, int y, float border, float river) {
        float h = simplex.noise2((float)x / this.vWidth, (float)y / this.vWidth) * this.vHeight * river;
        h += simplex.noise2((float)x / 20.0f, (float)y / 20.0f) * 2.0f;
        float m = simplex.noise2((float)x / this.hWidth, (float)y / this.hWidth) * this.hHeight * river;
        m *= m / 40.0f;
        float sm = simplex.noise2((float)x / 30.0f, (float)y / 30.0f) * 8.0f;
        float cm = cell.noise((double)x / 25.0, (double)y / 25.0, 1.0) * 12.0f;
        m += (cm *= m / 20.0f > 3.75f ? 3.75f : (m += (sm *= m / 20.0f > 3.75f ? 3.75f : m / 20.0f)) / 20.0f);
        m /= 2.0f;
        m = TerrainHLGlacier.above(m, 25.0f);
        return this.bHeight + (h += TerrainHLGlacier.groundNoise(x, y, 1.5f, simplex)) + m;
    }
}

