/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.gen.terrain.highlands;

import rtg.util.CellNoise;
import rtg.util.OpenSimplexNoise;
import rtg.util.SimplexOctave;
import rtg.world.gen.terrain.TerrainBase;

public class TerrainHLCliffs
extends TerrainBase {
    private float width;
    private float strength;
    private static float startCliffsAt = 30.0f;

    public TerrainHLCliffs(float mountainWidth, float mountainStrength, float height) {
        this.width = mountainWidth;
        this.strength = mountainStrength;
        this.base = height;
    }

    @Override
    public float generateNoise(OpenSimplexNoise simplex, CellNoise cell, int x, int y, float border, float river) {
        float h = simplex.noise2((float)x / 20.0f, (float)y / 20.0f) * 2.0f;
        h += simplex.noise2((float)x / 7.0f, (float)y / 7.0f) * 0.8f;
        float m = simplex.noise2((float)x / this.width, (float)y / this.width) * this.strength * river;
        m = (m *= m / 35.0f) > 70.0f ? 70.0f + (m - 70.0f) / 2.5f : m;
        SimplexOctave.Disk jitter = new SimplexOctave.Disk();
        simplex.riverJitter().evaluateNoise((double)x / 15.0, (double)y / 15.0, jitter);
        float pX = (float)x + (float)jitter.deltax() * 5.0f;
        float pY = (float)y + (float)jitter.deltay() * 5.0f;
        float st = m * 0.7f;
        st = st > 20.0f ? 20.0f : st;
        float c = cell.noise(pX / 30.0f, pY / 30.0f, 1.0) * (5.0f + st);
        float sm = simplex.noise2(pX / 30.0f, pY / 30.0f) * 8.0f + simplex.noise2(pX / 8.0f, pY / 8.0f);
        sm += simplex.noise2(pX / 4.9f, pY / 4.9f);
        m += (sm *= (m + 10.0f) / 20.0f > 2.5f ? 2.5f : (m + 10.0f) / 20.0f);
        m += c;
        m = TerrainHLCliffs.above(m, startCliffsAt);
        if (m > 0.0f) {
            return this.base + h + m;
        }
        float result = this.base + h;
        if (river < 1.0f) {
            return 62.0f + (result - 62.0f) * river;
        }
        return result;
    }
}

