/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.gen.terrain.highlands;

import rtg.util.CellNoise;
import rtg.util.OpenSimplexNoise;
import rtg.world.gen.terrain.TerrainBase;

public class TerrainHLBirchHills
extends TerrainBase {
    private float width;
    private float strength;

    public TerrainHLBirchHills(float mountainWidth, float mountainStrength, float height) {
        this.width = mountainWidth;
        this.strength = mountainStrength;
        this.base = height;
    }

    @Override
    public float generateNoise(OpenSimplexNoise simplex, CellNoise cell, int x, int y, float border, float river) {
        float h = simplex.noise2((float)x / 20.0f, (float)y / 20.0f) * 2.0f;
        float m = (simplex.noise2((float)x / this.width, (float)y / this.width) + 1.0f) * this.strength / 2.0f * river;
        float sm = simplex.noise2((float)x / 30.0f, (float)y / 30.0f) * 8.0f + simplex.noise2((float)x / 8.0f, (float)y / 8.0f);
        return TerrainHLBirchHills.riverized(this.base + (h += simplex.noise2((float)x / 7.0f, (float)y / 7.0f) * 0.8f) + (m += sm), river);
    }
}

