/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.gen.terrain;

import rtg.config.rtg.ConfigRTG;
import rtg.util.CellNoise;
import rtg.util.OpenSimplexNoise;
import rtg.world.gen.terrain.VariableRuggednessEffect;

public class TerrainBase {
    protected float base;
    protected final float minOceanFloor;
    public static final float minimumOceanFloor = 30.0f;
    protected final float minDuneHeight;
    public static final float minimumDuneHeight = 21.0f;
    protected final float groundNoiseAmplitudeHills;
    protected float groundNoise;
    protected final float groundVariation;
    protected final float rollingHillsMaxHeight;

    public TerrainBase() {
        this(68.0f);
    }

    public TerrainBase(float base) {
        this.base = base;
        this.minOceanFloor = 30.0f;
        this.minDuneHeight = 21.0f;
        this.groundVariation = 2.0f;
        this.groundNoise = this.base;
        this.groundNoiseAmplitudeHills = 6.0f;
        this.rollingHillsMaxHeight = 80.0f;
    }

    public static final float blendedHillHeight(float simplex) {
        float result = simplex + 1.0f;
        result = result * result * result + 10.0f;
        result = (float)Math.pow(result, 0.33333333333333);
        result /= 0.46631f;
        return result -= 4.62021f;
    }

    public static final float blendedHillHeight(float simplex, float turnAt) {
        float adjusted = 1.0f - (1.0f - simplex) / (1.0f - turnAt);
        return TerrainBase.blendedHillHeight(adjusted);
    }

    public static final float borderAdjusted(float effect, float border, float allAbove, float noneBelow) {
        if (border < noneBelow) {
            return 0.0f;
        }
        if (border >= 1.0f) {
            return effect;
        }
        float adjusted = effect / border;
        if (border > allAbove) {
            return adjusted;
        }
        return adjusted * (border - noneBelow) / (allAbove - noneBelow);
    }

    public static final float above(float limited, float limit) {
        if (limited > limit) {
            return limited - limit;
        }
        return 0.0f;
    }

    public static final float stretched(float toStretch) {
        if (toStretch > 0.0f) {
            return (float)Math.sqrt(toStretch);
        }
        return -1.0f * (float)Math.sqrt(-1.0f * toStretch);
    }

    public static final float unsignedPower(float number, float power) {
        if (number > 0.0f) {
            return (float)Math.pow(number, power);
        }
        return -1.0f * (float)Math.pow(-1.0f * number, power);
    }

    public float generateNoise(OpenSimplexNoise simplex, CellNoise cell, int x, int y, float border, float river) {
        return 70.0f;
    }

    public static float hills(float x, float y, float hillStrength, OpenSimplexNoise simplex, float river) {
        float m = simplex.noise2(x / 150.0f, y / 150.0f);
        m = TerrainBase.blendedHillHeight(m, 0.2f);
        float sm = simplex.octave(2).noise2(x / 55.0f, y / 55.0f);
        sm = TerrainBase.blendedHillHeight(sm, 0.2f);
        sm *= sm * m;
        return (m += sm / 3.0f) * hillStrength;
    }

    public static float groundNoise(int x, int y, float amplitude, OpenSimplexNoise simplex) {
        float h = TerrainBase.blendedHillHeight(simplex.noise2((float)x / 49.0f, (float)y / 49.0f), 0.2f) * amplitude;
        h += TerrainBase.blendedHillHeight(simplex.octave(1).noise2((float)x / 23.0f, (float)y / 23.0f), 0.2f) * amplitude / 2.0f;
        return h += TerrainBase.blendedHillHeight(simplex.octave(2).noise2((float)x / 11.0f, (float)y / 11.0f), 0.2f) * amplitude / 4.0f;
    }

    public static float groundNoise(float x, float y, float amplitude, OpenSimplexNoise simplex) {
        float h = TerrainBase.blendedHillHeight(simplex.noise2(x / 49.0f, y / 49.0f), 0.2f) * amplitude;
        h += TerrainBase.blendedHillHeight(simplex.octave(1).noise2(x / 23.0f, y / 23.0f), 0.2f) * amplitude / 2.0f;
        return h += TerrainBase.blendedHillHeight(simplex.octave(2).noise2(x / 11.0f, y / 11.0f), 0.2f) * amplitude / 4.0f;
    }

    public static float getTerrainBase() {
        return 68.0f;
    }

    public static float getTerrainBase(float river) {
        return 62.0f + 6.0f * river;
    }

    public static float riverized(float height, float river) {
        if (height < 63.0f) {
            return height;
        }
        return 63.0f + (height - 63.0f) * river;
    }

    public static float terrainBeach(int x, int y, OpenSimplexNoise simplex, float river, float pitch1, float pitch2, float baseHeight) {
        float h = simplex.noise2((float)x / pitch1, (float)y / pitch1) * 40.0f * river;
        if ((h *= h / pitch2) < 1.0f) {
            h = 1.0f;
        }
        if (h < 4.0f) {
            h += (simplex.noise2((float)x / 50.0f, (float)y / 50.0f) + simplex.noise2((float)x / 15.0f, (float)y / 15.0f)) * (4.0f - h);
        }
        return baseHeight + h;
    }

    public static float terrainBryce(int x, int y, OpenSimplexNoise simplex, float river, float height, float border) {
        float b = 0.0f;
        float sn = simplex.noise2((float)x / 2.0f, (float)y / 2.0f) * 0.5f + 0.5f;
        sn = (float)((double)sn + ((double)simplex.noise2(x, y) * 0.2 + 0.2));
        sn += simplex.noise2((float)x / 4.0f, (float)y / 4.0f) * 4.0f + 4.0f;
        float n = height / (sn += simplex.noise2((float)x / 8.0f, (float)y / 8.0f) * 2.0f + 2.0f) * 2.0f;
        n = sn < 6.0f ? (n += simplex.noise2((float)x / 64.0f, (float)y / 64.0f) * 4.0f) : 0.0f;
        return TerrainBase.riverized(TerrainBase.getTerrainBase() + (b += n), river);
    }

    public static float terrainCanyon(int x, int y, OpenSimplexNoise simplex, float river, float[] height, float border, float strength, int heightLength, boolean booRiver) {
        float r = simplex.noise2((float)x / 100.0f, (float)y / 100.0f) * 50.0f * river;
        r = r < -7.4f ? -7.4f : (r > 7.4f ? 7.4f : r);
        float b = (17.0f + r) * river;
        float hn = simplex.noise2((float)x / 12.0f, (float)y / 12.0f) * 0.5f;
        float sb = 0.0f;
        if (b > 0.0f) {
            sb = b;
            sb = sb < 0.0f ? 0.0f : (sb > 7.0f ? 7.0f : sb);
            sb = hn * sb * river;
        }
        b += sb;
        float cTotal = 0.0f;
        float cTemp = 0.0f;
        for (int i = 0; i < heightLength; i += 2) {
            cTemp = 0.0f;
            if (b > height[i] && border > 0.6f + height[i] * 0.015f + hn * 0.2f) {
                cTemp = b > height[i] + height[i + 1] ? height[i + 1] : b - height[i];
                cTemp *= strength;
            }
            cTotal += cTemp;
        }
        float bn = 0.0f;
        if (booRiver) {
            if (b < 5.0f) {
                bn = 5.0f - b;
                for (int i = 0; i < 3; ++i) {
                    bn *= bn / 4.5f;
                }
            }
        } else if (b < 5.0f) {
            bn = (simplex.noise2((float)x / 7.0f, (float)y / 7.0f) * 1.3f + simplex.noise2((float)x / 15.0f, (float)y / 15.0f) * 2.0f) * (5.0f - b) * 0.2f;
        }
        return TerrainBase.getTerrainBase(river) + (b += cTotal - bn);
    }

    public static float terrainDunes(int x, int y, OpenSimplexNoise simplex, CellNoise cell, float river) {
        float st = (simplex.noise2((float)x / 160.0f, (float)y / 160.0f) + 0.38f) * (21.0f + (float)ConfigRTG.duneHeight);
        st = st < 0.2f ? 0.2f : st;
        float h = simplex.noise2((float)x / 60.0f, (float)y / 60.0f) * st * 2.0f;
        h = h > 0.0f ? -h : h;
        h += st;
        h *= h / 50.0f;
        if ((h += st) < 10.0f) {
            float d = (h - 10.0f) / 2.0f;
            d = d > 4.0f ? 4.0f : d;
            h += cell.noise((double)x / 25.0, (double)y / 25.0, 1.0) * d;
            h += simplex.noise2((float)x / 30.0f, (float)y / 30.0f) * d;
            h += simplex.noise2((float)x / 14.0f, (float)y / 14.0f) * d * 0.5f;
        }
        return 70.0f + h * river;
    }

    public static float terrainDuneValley(float x, float y, OpenSimplexNoise simplex, CellNoise cell, float river, float valley, float hFactor, float baseHeight) {
        float h = (simplex.noise2(x / valley, y / valley) + 0.25f) * hFactor * river;
        h = h < 1.0f ? 1.0f : h;
        float r = (float)simplex.noise((double)x / 50.0, (double)y / 50.0, 1.0);
        r += TerrainBase.blendedHillHeight(r);
        r = r * h * 2.0f;
        h += r;
        h += TerrainBase.blendedHillHeight(simplex.noise2(x / 40.0f, y / 40.0f)) * 8.0f;
        h += TerrainBase.blendedHillHeight(simplex.noise2(x / 14.0f, y / 14.0f)) * 2.0f;
        h *= river;
        if (river < 1.0f) {
            return 63.0f + (baseHeight - 63.0f) * river + h;
        }
        return baseHeight + h;
    }

    public static float terrainFlatLakes(int x, int y, OpenSimplexNoise simplex, float river, float hMax, float baseHeight) {
        float ruggedNoise = simplex.octave(1).noise2((float)x / VariableRuggednessEffect.STANDARD_RUGGEDNESS_WAVELENGTH, (float)y / VariableRuggednessEffect.STANDARD_RUGGEDNESS_WAVELENGTH);
        ruggedNoise = TerrainBase.blendedHillHeight(ruggedNoise);
        float h = TerrainBase.groundNoise(x, y, 2.0f * (ruggedNoise + 1.0f), simplex);
        float hillNoise = (float)simplex.noise((float)x / 60.0f, (float)y / 60.0f);
        hillNoise *= hillNoise * hMax * ruggedNoise;
        return TerrainBase.riverized(baseHeight + h, river);
    }

    public static float terrainForest(int x, int y, OpenSimplexNoise simplex, float river, float baseHeight) {
        float h = simplex.noise2((float)x / 100.0f, (float)y / 100.0f) * 8.0f;
        h += simplex.noise2((float)x / 30.0f, (float)y / 30.0f) * 4.0f;
        h += simplex.noise2((float)x / 15.0f, (float)y / 15.0f) * 2.0f;
        return TerrainBase.riverized(baseHeight + 20.0f + (h += simplex.noise2((float)x / 7.0f, (float)y / 7.0f)), river);
    }

    public static float terrainGrasslandFlats(int x, int y, OpenSimplexNoise simplex, float river, float mPitch, float lPitch, float baseHeight) {
        float h = simplex.noise2((float)x / 100.0f, (float)y / 100.0f) * 7.0f;
        float m = simplex.noise2((float)x / 180.0f, (float)y / 180.0f) * 35.0f * river;
        m *= m / mPitch;
        float sm = TerrainBase.blendedHillHeight(simplex.noise2((float)x / 30.0f, (float)y / 30.0f)) * 8.0f;
        return TerrainBase.riverized(baseHeight + (h += simplex.noise2((float)x / 20.0f, (float)y / 20.0f) * 2.0f) + (m += (sm *= m / 20.0f > 3.75f ? 3.75f : m / 20.0f)), river);
    }

    public static float terrainGrasslandHills(int x, int y, OpenSimplexNoise simplex, CellNoise cell, float river, float vWidth, float vHeight, float hWidth, float hHeight, float bHeight) {
        float h = simplex.noise2((float)x / vWidth, (float)y / vWidth);
        h = TerrainBase.blendedHillHeight(h, 0.3f);
        float m = simplex.octave(1).noise2((float)x / hWidth, (float)y / hWidth);
        m = TerrainBase.blendedHillHeight(m, 0.3f) * h;
        m *= m;
        h *= vHeight * river;
        return TerrainBase.riverized(bHeight, river) + (h += TerrainBase.groundNoise(x, y, 4.0f, simplex)) + (m *= hHeight * river);
    }

    public static float terrainGrasslandMountains(int x, int y, OpenSimplexNoise simplex, CellNoise cell, float river, float hFactor, float mFactor, float baseHeight) {
        float h = simplex.noise2((float)x / 100.0f, (float)y / 100.0f) * hFactor;
        h += simplex.noise2((float)x / 20.0f, (float)y / 20.0f) * 2.0f;
        float m = simplex.noise2((float)x / 230.0f, (float)y / 230.0f) * mFactor * river;
        m = (m *= m / 35.0f) > 70.0f ? 70.0f + (m - 70.0f) / 2.5f : m;
        float c = (float)simplex.octave(4).noise((float)x / 30.0f, (float)y / 30.0f, 1.0) * (m * 0.3f);
        float sm = simplex.noise2((float)x / 30.0f, (float)y / 30.0f) * 8.0f + simplex.noise2((float)x / 8.0f, (float)y / 8.0f);
        m += (sm *= m / 20.0f > 2.5f ? 2.5f : m / 20.0f);
        return TerrainBase.riverized(baseHeight + h + (m += c), river);
    }

    public static float terrainHighland(float x, float y, OpenSimplexNoise simplex, CellNoise cell, float river, float start, float width, float height, float baseAdjust) {
        float h = simplex.noise2(x / width, y / width) * height * river;
        float f = h = h < start ? start + (h - start) / 4.5f : h;
        if (h < 0.0f) {
            h = 0.0f;
        }
        if (h > 0.0f) {
            float st = h * 1.5f > 15.0f ? 15.0f : h * 1.5f;
            h = (float)((double)h + simplex.octave(4).noise((double)x / 70.0, (double)y / 70.0, 1.0) * (double)st);
            h *= river;
        }
        h += TerrainBase.blendedHillHeight(simplex.noise2(x / 20.0f, y / 20.0f), 0.0f) * 4.0f;
        h += TerrainBase.blendedHillHeight(simplex.noise2(x / 12.0f, y / 12.0f), 0.0f) * 2.0f;
        if ((h += TerrainBase.blendedHillHeight(simplex.noise2(x / 5.0f, y / 5.0f), 0.0f) * 1.0f) < 0.0f) {
            h /= 2.0f;
        }
        if (h < -3.0f) {
            h = (h + 3.0f) / 2.0f - 3.0f;
        }
        return TerrainBase.getTerrainBase(river) + (h + baseAdjust) * river;
    }

    public static float terrainLonelyMountain(int x, int y, OpenSimplexNoise simplex, CellNoise cell, float river, float strength, float width, float terrainHeight) {
        float h = TerrainBase.blendedHillHeight(simplex.noise2((float)x / 20.0f, (float)y / 20.0f), 0.0f) * 3.0f;
        h += TerrainBase.blendedHillHeight(simplex.noise2((float)x / 7.0f, (float)y / 7.0f), 0.0f) * 1.3f;
        float m = simplex.noise2((float)x / width, (float)y / width) * strength * river;
        m = (m *= m / 35.0f) > 70.0f ? 70.0f + (m - 70.0f) / 2.5f : m;
        float st = m * 0.7f;
        st = st > 20.0f ? 20.0f : st;
        float c = (float)simplex.octave(4).noise((float)x / 30.0f, (float)y / 30.0f, 1.0) * (5.0f + st);
        float sm = simplex.noise2((float)x / 30.0f, (float)y / 30.0f) * 8.0f + simplex.noise2((float)x / 8.0f, (float)y / 8.0f);
        m += (sm *= (m + 10.0f) / 20.0f > 2.5f ? 2.5f : (m + 10.0f) / 20.0f);
        m += c;
        if (m > 90.0f && (m = 90.0f + (m - 90.0f) * 0.75f) > 110.0f) {
            m = 110.0f + (m - 110.0f) * 0.75f;
        }
        return TerrainBase.riverized(terrainHeight + h + m, river);
    }

    public static float terrainMarsh(int x, int y, OpenSimplexNoise simplex, float baseHeight) {
        float h = simplex.noise2((float)x / 130.0f, (float)y / 130.0f) * 20.0f;
        h += simplex.noise2((float)x / 12.0f, (float)y / 12.0f) * 2.0f;
        float f = h = (h += simplex.noise2((float)x / 18.0f, (float)y / 18.0f) * 4.0f) < 8.0f ? 0.0f : h - 8.0f;
        if (h == 0.0f) {
            h += simplex.noise2((float)x / 20.0f, (float)y / 20.0f) + simplex.noise2((float)x / 5.0f, (float)y / 5.0f);
            h *= 2.0f;
        }
        return baseHeight + h;
    }

    public static float terrainMesa(int x, int y, OpenSimplexNoise simplex, float river, float border) {
        float b = simplex.noise2((float)x / 130.0f, (float)y / 130.0f) * 50.0f * river;
        b *= b / 40.0f;
        float hn = simplex.noise2((float)x / 12.0f, (float)y / 12.0f);
        float sb = 0.0f;
        if (b > 2.0f) {
            sb = (b - 2.0f) / 2.0f;
            sb = sb < 0.0f ? 0.0f : (sb > 5.5f ? 5.5f : sb);
            sb = hn * sb;
        }
        b = (b += sb) < 0.1f ? 0.1f : b;
        float c1 = 0.0f;
        if (b > 1.0f) {
            c1 = b > 5.5f ? 4.5f : b - 1.0f;
            c1 *= 3.0f;
        }
        float c2 = 0.0f;
        if (b > 5.5f && border > 0.95f + hn * 0.09f) {
            c2 = b > 6.0f ? 0.5f : b - 5.5f;
            c2 *= 35.0f;
        }
        float bn = 0.0f;
        if (b < 7.0f) {
            float bnh = 5.0f - b;
            bn += simplex.noise2((float)x / 70.0f, (float)y / 70.0f) * (bnh * 0.4f);
            bn += simplex.noise2((float)x / 20.0f, (float)y / 20.0f) * (bnh * 0.3f);
        }
        float w = simplex.noise2((float)x / 80.0f, (float)y / 80.0f) * 25.0f;
        w *= w / 25.0f;
        return 74.0f + (b += c1 + c2 + bn - w);
    }

    public static float terrainMountainRiver(int x, int y, OpenSimplexNoise simplex, CellNoise cell, float river, float hPitch, float baseHeight) {
        float d;
        float h = simplex.noise2((float)x / hPitch, (float)y / hPitch) * 135.0f * river;
        float f = h = (h *= h / 32.0f) > 150.0f ? 150.0f : h;
        if (h < 10.0f) {
            h += simplex.noise2((float)x / 14.0f, (float)y / 14.0f) * (10.0f - h) * 0.2f;
        }
        if (h > 10.0f) {
            d = (h - 10.0f) / 2.0f > 8.0f ? 8.0f : (h - 10.0f) / 2.0f;
            h += simplex.noise2((float)x / 35.0f, (float)y / 35.0f) * d;
            if ((h += simplex.noise2((float)x / 60.0f, (float)y / 60.0f) * d * 0.5f) > 35.0f) {
                float d2 = (h - 35.0f) / 1.5f > 30.0f ? 30.0f : (h - 35.0f) / 1.5f;
                h = (float)((double)h + simplex.octave(4).noise((double)x / 25.0, (double)y / 25.0, 1.0) * (double)d2);
            }
        }
        if (h > 2.0f) {
            d = (h - 2.0f) / 2.0f > 4.0f ? 4.0f : (h - 2.0f) / 2.0f;
            h += simplex.noise2((float)x / 28.0f, (float)y / 28.0f) * d;
            h += simplex.noise2((float)x / 18.0f, (float)y / 18.0f) * (d / 2.0f);
            h += simplex.noise2((float)x / 8.0f, (float)y / 8.0f) * (d / 2.0f);
        }
        return TerrainBase.riverized(h + baseHeight, river);
    }

    public static float terrainMountainSpikes(int x, int y, OpenSimplexNoise simplex, CellNoise cell, float river) {
        float b = 12.0f + simplex.noise2((float)x / 300.0f, (float)y / 300.0f) * 6.0f;
        float h = (float)simplex.octave(4).noise((double)x / 200.0, (double)y / 200.0, 1.0) * b * river;
        float f = h = (h *= h * 1.5f) > 155.0f ? 155.0f : h;
        if (h > 2.0f) {
            float d = (h - 2.0f) / 2.0f > 8.0f ? 8.0f : (h - 2.0f) / 2.0f;
            h += simplex.noise2((float)x / 30.0f, (float)y / 30.0f) * d;
            if ((h += simplex.noise2((float)x / 50.0f, (float)y / 50.0f) * d * 0.5f) > 35.0f) {
                float d2 = (h - 35.0f) / 1.5f > 30.0f ? 30.0f : (h - 35.0f) / 1.5f;
                h = (float)((double)h + simplex.octave(4).noise((double)x / 25.0, (double)y / 25.0, 1.0) * (double)d2);
            }
        }
        h += simplex.noise2((float)x / 18.0f, (float)y / 18.0f) * 3.0f;
        return 45.0f + (h += simplex.noise2((float)x / 8.0f, (float)y / 8.0f) * 2.0f) + b * 2.0f;
    }

    public static float terrainOcean(int x, int y, OpenSimplexNoise simplex, float river, float averageFloor) {
        float h = simplex.noise2((float)x / 300.0f, (float)y / 300.0f) * 40.0f * river;
        h = h > 3.0f ? 3.0f : h;
        h += simplex.noise2((float)x / 50.0f, (float)y / 50.0f) * (12.0f - h) * 0.4f;
        h += simplex.noise2((float)x / 15.0f, (float)y / 15.0f) * (12.0f - h) * 0.15f;
        float floNoise = averageFloor + h;
        floNoise = floNoise < 30.0f ? 30.0f : floNoise;
        return floNoise;
    }

    public static float terrainOceanCanyon(int x, int y, OpenSimplexNoise simplex, float river, float[] height, float border, float strength, int heightLength, boolean booRiver) {
        float floNoise;
        river = (river *= 1.3f) > 1.0f ? 1.0f : river;
        float r = simplex.noise2((float)x / 100.0f, (float)y / 100.0f) * 50.0f;
        r = r < -7.4f ? -7.4f : (r > 7.4f ? 7.4f : r);
        float b = (17.0f + r) * river;
        float hn = simplex.noise2((float)x / 12.0f, (float)y / 12.0f) * 0.5f;
        float sb = 0.0f;
        if (b > 0.0f) {
            sb = b;
            sb = sb < 0.0f ? 0.0f : (sb > 7.0f ? 7.0f : sb);
            sb = hn * sb;
        }
        b += sb;
        float cTotal = 0.0f;
        float cTemp = 0.0f;
        for (int i = 0; i < heightLength; i += 2) {
            cTemp = 0.0f;
            if (b > height[i] && border > 0.6f + height[i] * 0.015f + hn * 0.2f) {
                cTemp = b > height[i] + height[i + 1] ? height[i + 1] : b - height[i];
                cTemp *= strength;
            }
            cTotal += cTemp;
        }
        float bn = 0.0f;
        if (booRiver) {
            if (b < 5.0f) {
                bn = 5.0f - b;
                for (int i = 0; i < 3; ++i) {
                    bn *= bn / 4.5f;
                }
            }
        } else if (b < 5.0f) {
            bn = (simplex.noise2((float)x / 7.0f, (float)y / 7.0f) * 1.3f + simplex.noise2((float)x / 15.0f, (float)y / 15.0f) * 2.0f) * (5.0f - b) * 0.2f;
        }
        floNoise = (floNoise = 30.0f + (b += cTotal - bn)) < 30.0f ? 30.0f : floNoise;
        return floNoise;
    }

    public static float terrainPlains(int x, int y, OpenSimplexNoise simplex, float river, float stPitch, float stFactor, float hPitch, float hDivisor, float baseHeight) {
        float st = (simplex.noise2((float)x / stPitch, (float)y / stPitch) + 0.38f) * stFactor * river;
        st = st < 0.2f ? 0.2f : st;
        float h = simplex.noise2((float)x / hPitch, (float)y / hPitch) * st * 2.0f;
        h = h > 0.0f ? -h : h;
        h += st;
        h *= h / hDivisor;
        float floNoise = TerrainBase.riverized(baseHeight + (h += st), river);
        return floNoise;
    }

    public static float terrainPlateau(float x, float y, OpenSimplexNoise simplex, float river, float[] height, float border, float strength, int heightLength, float selectorWaveLength, boolean isM) {
        river = river > 1.0f ? 1.0f : river;
        float border2 = border * 4.0f - 2.5f;
        border2 = border2 > 1.0f ? 1.0f : (border2 < 0.0f ? 0.0f : border2);
        float b = simplex.noise2(x / 40.0f, y / 40.0f) * 1.5f;
        float sn = simplex.noise2(x / selectorWaveLength, y / selectorWaveLength) * 0.5f + 0.5f;
        sn *= border2;
        sn *= river;
        sn += simplex.noise2(x / 4.0f, y / 4.0f) * 0.01f + 0.01f;
        sn += simplex.noise2(x / 2.0f, y / 2.0f) * 0.01f + 0.01f;
        for (int i = 0; i < heightLength; i += 2) {
            float n = (sn - height[i + 1]) / (1.0f - height[i + 1]);
            n = (n *= strength) < 0.0f ? 0.0f : (n > 1.0f ? 1.0f : n);
            float hn = height[i] * 0.5f * (sn * 2.0f - 0.4f);
            hn = hn < 0.0f ? 0.0f : hn;
            float stepUp = 0.0f;
            if (sn > height[i + 1]) {
                stepUp += height[i] * n;
                if (isM) {
                    stepUp += simplex.noise2(x / 20.0f, y / 20.0f) * 3.0f * n;
                    stepUp += simplex.noise2(x / 12.0f, y / 12.0f) * 2.0f * n;
                    stepUp += simplex.noise2(x / 5.0f, y / 5.0f) * 1.0f * n;
                }
            }
            if (i == 0 && stepUp < hn) {
                b += hn;
            }
            stepUp = stepUp < 0.0f ? 0.0f : stepUp;
            b += stepUp;
        }
        if (isM) {
            b += simplex.noise2(x / 12.0f, y / 12.0f) * sn;
        }
        return TerrainBase.riverized(TerrainBase.getTerrainBase(), river) + (b /= border);
    }

    public static float terrainPolar(int x, int y, OpenSimplexNoise simplex, float river) {
        float st = (simplex.noise2((float)x / 160.0f, (float)y / 160.0f) + 0.38f) * (21.0f + (float)ConfigRTG.duneHeight) * river;
        st = st < 0.2f ? 0.2f : st;
        float h = simplex.noise2((float)x / 60.0f, (float)y / 60.0f) * st * 2.0f;
        h = h > 0.0f ? -h : h;
        h += st;
        h *= h / 50.0f;
        h += st;
        if (river < 1.0f) {
            return 62.0f + 8.0f * river + h;
        }
        return 70.0f + h;
    }

    public static float terrainPolar(float x, float y, OpenSimplexNoise simplex, float river, float stPitch, float stFactor, float hPitch, float hDivisor, float baseHeight) {
        float st = (simplex.noise2(x / stPitch, y / stPitch) + 0.38f) * stFactor * river;
        st = st < 0.1f ? 0.1f : st;
        float h = simplex.noise2(x / hPitch, y / hPitch) * st * 2.0f;
        h = h > 0.0f ? -h : h;
        h += st;
        h *= h / hDivisor;
        float floNoise = TerrainBase.riverized(baseHeight + (h += st), river);
        return floNoise;
    }

    public static float terrainRollingHills(int x, int y, OpenSimplexNoise simplex, float river, float hillStrength, float addedHeight, float groundNoise, float groundNoiseAmplitudeHills, float lift) {
        groundNoise = TerrainBase.groundNoise(x, y, groundNoiseAmplitudeHills, simplex);
        float m = TerrainBase.hills(x, y, hillStrength, simplex, river);
        float floNoise = addedHeight + groundNoise + m;
        return TerrainBase.riverized(floNoise + lift, river);
    }

    public static float terrainRollingHills(int x, int y, OpenSimplexNoise simplex, float river, float hillStrength, float groundNoise, float groundNoiseAmplitudeHills, float baseHeight) {
        groundNoise = TerrainBase.groundNoise(x, y, groundNoiseAmplitudeHills, simplex);
        float m = TerrainBase.hills(x, y, hillStrength, simplex, river);
        float floNoise = groundNoise + m;
        return TerrainBase.riverized(floNoise + baseHeight, river);
    }

    public static float terrainSwampMountain(int x, int y, OpenSimplexNoise simplex, CellNoise cell, float river, float width, float heigth, float hMax, float hDivisor, float baseHeight) {
        float d;
        float h = simplex.noise2((float)x / width, (float)y / width) * heigth * river;
        float f = h = (h *= h / hDivisor) > hMax ? hMax : h;
        if (h < 14.0f) {
            h += simplex.noise2((float)x / 25.0f, (float)y / 25.0f) * (14.0f - h) * 0.8f;
        }
        if (h < 6.0f) {
            h = 6.0f - (6.0f - h) * 0.07f + simplex.noise2((float)x / 20.0f, (float)y / 20.0f) + simplex.noise2((float)x / 5.0f, (float)y / 5.0f);
        }
        if (h > 10.0f) {
            d = (h - 10.0f) / 2.0f > 8.0f ? 8.0f : (h - 10.0f) / 2.0f;
            h += simplex.noise2((float)x / 35.0f, (float)y / 35.0f) * d;
            if ((h += simplex.noise2((float)x / 60.0f, (float)y / 60.0f) * d * 0.5f) > 35.0f) {
                float d2 = (h - 35.0f) / 1.5f > 30.0f ? 30.0f : (h - 35.0f) / 1.5f;
                h = (float)((double)h + simplex.octave(4).noise((double)x / 25.0, (double)y / 25.0, 1.0) * (double)d2);
            }
        }
        if (h > 2.0f) {
            d = (h - 2.0f) / 2.0f > 4.0f ? 4.0f : (h - 2.0f) / 2.0f;
            h += simplex.noise2((float)x / 28.0f, (float)y / 28.0f) * d;
            h += simplex.noise2((float)x / 18.0f, (float)y / 18.0f) * (d / 2.0f);
            h += simplex.noise2((float)x / 8.0f, (float)y / 8.0f) * (d / 2.0f);
        }
        return TerrainBase.riverized(h + baseHeight, river);
    }

    public static float terrainVolcano(int x, int y, OpenSimplexNoise simplex, CellNoise cell, float border, float baseHeight) {
        float st = 15.0f - (cell.noise((double)x / 500.0, (double)y / 500.0, 1.0) * 42.0f + simplex.noise2((float)x / 30.0f, (float)y / 30.0f) * 2.0f);
        float h = st = st < 0.0f ? 0.0f : st;
        h = h < 0.0f ? 0.0f : h;
        if ((h += h * 0.4f * (h * 0.4f * 2.0f)) > 10.0f) {
            float d2 = (h - 10.0f) / 1.5f > 30.0f ? 30.0f : (h - 10.0f) / 1.5f;
            h += cell.noise((double)x / 25.0, (double)y / 25.0, 1.0) * d2;
        }
        h += simplex.noise2((float)x / 18.0f, (float)y / 18.0f) * 3.0f;
        return baseHeight + (h += simplex.noise2((float)x / 8.0f, (float)y / 8.0f) * 2.0f) * border;
    }
}

