/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.gen.terrain;

import rtg.util.CellNoise;
import rtg.util.OpenSimplexNoise;
import rtg.world.gen.terrain.HeightEffect;
import rtg.world.gen.terrain.TerrainBase;

public class LonelyMountainEffect
extends HeightEffect {
    public float mountainHeight = 2.1474836E9f;
    public float mountainWavelength = 0.0f;
    public float spikeHeight = 2.1474836E9f;
    public float spikeWavelength = 0.0f;
    private float adjustedBottom = TerrainBase.blendedHillHeight(0.0f, 0.0f);
    public int hillOctave = 0;
    public int spikeOctave = 2;

    @Override
    public final float added(OpenSimplexNoise simplex, CellNoise cell, float x, float y) {
        float noise = simplex.octave(this.hillOctave).noise2(x / this.mountainWavelength, y / this.mountainWavelength);
        noise = Math.abs(noise);
        noise = TerrainBase.blendedHillHeight(noise, 0.0f);
        noise = TerrainBase.unsignedPower(noise, 1.7f);
        noise = 1.0f - (1.0f - noise) / (1.0f - this.adjustedBottom);
        float spikeNoise = simplex.octave(this.spikeOctave).noise2(x / this.spikeWavelength, y / this.spikeWavelength);
        spikeNoise = Math.abs(noise);
        spikeNoise = TerrainBase.blendedHillHeight(noise, 0.0f);
        return noise * this.mountainHeight + (spikeNoise *= noise) * this.spikeHeight;
    }
}

