/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.gen.terrain;

import rtg.util.CellNoise;
import rtg.util.OpenSimplexNoise;
import rtg.world.gen.terrain.HeightEffect;
import rtg.world.gen.terrain.TerrainBase;

public class AdjustableSpikeEffect
extends HeightEffect {
    public float height = 2.1474836E9f;
    public float wavelength = 0.0f;
    public float minimumSimplex = 2.1474836E9f;
    public int octave;
    public float power = 1.6f;

    @Override
    public final float added(OpenSimplexNoise simplex, CellNoise cell, float x, float y) {
        float noise = simplex.octave(this.octave).noise2(x / this.wavelength, y / this.wavelength);
        if (noise < this.minimumSimplex) {
            noise = this.minimumSimplex;
        }
        noise = 1.0f - (1.0f - noise) / (1.0f - this.minimumSimplex);
        noise = TerrainBase.unsignedPower(noise, this.power);
        return noise * this.height;
    }
}

