/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.gen.surface;

import cpw.mods.fml.common.registry.GameData;
import exterminatorJeff.undergroundBiomes.api.BlockCodes;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import rtg.api.biome.BiomeConfig;
import rtg.config.rtg.ConfigRTG;
import rtg.util.CellNoise;
import rtg.util.ModPresenceTester;
import rtg.util.OpenSimplexNoise;
import rtg.util.UBColumnCache;

public class SurfaceBase {
    protected Block topBlock;
    public byte topBlockMeta;
    protected Block fillerBlock;
    public byte fillerBlockMeta;
    protected BiomeConfig biomeConfig;
    private static final ModPresenceTester undergroundBiomesMod = new ModPresenceTester("UndergroundBiomes");
    private static final ModPresenceTester harderUndergroundMod = new ModPresenceTester("HarderUnderground");
    private static UBColumnCache ubColumnCache = undergroundBiomesMod.present() ? new UBColumnCache() : null;
    private static Block unstableCobbleBlock = harderUndergroundMod.present() ? (Block)GameData.getBlockRegistry().func_82594_a("HarderUnderground:unstable_stone") : Blocks.field_150347_e;
    private static byte unstableCobbleMeta = (byte)(harderUndergroundMod.present() ? 3 : 0);

    public SurfaceBase(BiomeConfig config, Block top, byte topByte, Block fill, byte fillByte) {
        if (config == null) {
            throw new RuntimeException("Biome config in SurfaceBase is NULL.");
        }
        this.biomeConfig = config;
        this.topBlock = top;
        this.topBlockMeta = topByte;
        this.fillerBlock = fill;
        this.fillerBlockMeta = fillByte;
        this.assignUserConfigs(config, top, topByte, fill, fillByte);
    }

    public void paintTerrain(Block[] blocks, byte[] metadata, int i, int j, int x, int y, int depth, World world, Random rand, OpenSimplexNoise simplex, CellNoise cell, float[] noise, float river, BiomeGenBase[] base) {
    }

    protected Block getShadowStoneBlock(World world, int i, int j, int x, int y, int k) {
        if (undergroundBiomesMod.present() && ConfigRTG.enableUBCStoneShadowing) {
            return Blocks.field_150348_b;
        }
        return (Block)GameData.getBlockRegistry().func_82594_a(ConfigRTG.shadowStoneBlockId);
    }

    protected byte getShadowStoneMeta(World world, int i, int j, int x, int y, int k) {
        if (undergroundBiomesMod.present() && ConfigRTG.enableUBCStoneShadowing) {
            return 0;
        }
        return (byte)ConfigRTG.shadowStoneBlockByte;
    }

    protected Block getShadowDesertBlock(World world, int i, int j, int x, int y, int k) {
        if (undergroundBiomesMod.present() && ConfigRTG.enableUBCDesertShadowing) {
            return Blocks.field_150348_b;
        }
        return (Block)GameData.getBlockRegistry().func_82594_a(ConfigRTG.shadowDesertBlockId);
    }

    protected byte getShadowDesertMeta(World world, int i, int j, int x, int y, int k) {
        if (undergroundBiomesMod.present() && ConfigRTG.enableUBCDesertShadowing) {
            return 0;
        }
        return (byte)ConfigRTG.shadowDesertBlockByte;
    }

    protected Block hcStone(World world, int worldX, int worldZ, int chunkX, int chunkZ, int worldY) {
        return Blocks.field_150348_b;
    }

    protected byte hcStoneMeta(World world, int worldX, int worldZ, int chunkX, int chunkZ, int worldY) {
        return 0;
    }

    protected Block hcCobble(World world, int worldX, int worldZ, int chunkX, int chunkZ, int worldY) {
        if (undergroundBiomesMod.present()) {
            BlockCodes cobble = ubColumnCache.column(worldX, worldZ).cobblestone(worldY);
            return cobble.block;
        }
        if (harderUndergroundMod.present()) {
            return unstableCobbleBlock;
        }
        return Blocks.field_150347_e;
    }

    protected byte hcCobbleMeta(World world, int worldX, int worldZ, int chunkX, int chunkZ, int worldY) {
        if (undergroundBiomesMod.present()) {
            BlockCodes cobble = ubColumnCache.column(worldX, worldZ).cobblestone(worldY);
            return (byte)cobble.metadata;
        }
        if (harderUndergroundMod.present()) {
            return unstableCobbleMeta;
        }
        return 0;
    }

    public Block getTopBlock() {
        return this.topBlock;
    }

    public Block getFillerBlock() {
        return this.fillerBlock;
    }

    private void assignUserConfigs(BiomeConfig config, Block top, byte topByte, Block fill, byte fillByte) {
        String userTopBlock = config._string("surfaceTopBlock");
        try {
            this.topBlock = GameData.getBlockRegistry().func_148741_d(userTopBlock) ? (Block)GameData.getBlockRegistry().func_82594_a(userTopBlock) : top;
        }
        catch (Exception e) {
            this.topBlock = top;
        }
        String userTopBlockMeta = config._string("surfaceTopBlockMeta");
        try {
            this.topBlockMeta = Byte.valueOf(userTopBlockMeta);
        }
        catch (Exception e) {
            this.topBlockMeta = topByte;
        }
        String userFillerBlock = config._string("surfaceFillerBlock");
        try {
            this.fillerBlock = GameData.getBlockRegistry().func_148741_d(userFillerBlock) ? (Block)GameData.getBlockRegistry().func_82594_a(userFillerBlock) : fill;
        }
        catch (Exception e) {
            this.fillerBlock = fill;
        }
        String userFillerBlockMeta = config._string("surfaceFillerBlockMeta");
        try {
            this.fillerBlockMeta = Byte.valueOf(userFillerBlockMeta);
        }
        catch (Exception e) {
            this.fillerBlockMeta = fillByte;
        }
    }

    protected Block getConfigBlock(BiomeConfig config, String propertyId, Block blockDefault) {
        Block blockReturn = blockDefault;
        String userBlockId = config._string(propertyId);
        try {
            blockReturn = GameData.getBlockRegistry().func_148741_d(userBlockId) ? (Block)GameData.getBlockRegistry().func_82594_a(userBlockId) : blockDefault;
        }
        catch (Exception e) {
            blockReturn = blockDefault;
        }
        return blockReturn;
    }

    protected byte getConfigBlockMeta(BiomeConfig config, String propertyId, byte metaDefault) {
        byte metaReturn = metaDefault;
        String userMeta = config._string(propertyId);
        try {
            metaReturn = Byte.valueOf(userMeta);
        }
        catch (Exception e) {
            metaReturn = metaDefault;
        }
        return metaReturn;
    }
}

