/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.gen.feature;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class WorldGenLog
extends WorldGenerator {
    private int logMeta;
    private int leavesMeta;
    private Block logBlock;
    private Block leavesBlock;
    private int logLength;

    public WorldGenLog(int meta, int length, boolean leaves) {
        this.logBlock = meta > 2 ? Blocks.field_150363_s : Blocks.field_150364_r;
        this.leavesBlock = meta > 2 ? Blocks.field_150361_u : Blocks.field_150362_t;
        this.logMeta = meta = meta > 2 ? meta - 2 : meta;
        this.leavesMeta = leaves ? meta : -1;
        this.logLength = length < 2 ? 2 : length;
    }

    public WorldGenLog(Block blockLog, int metaLog, Block blockLeaves, int metaLeaves, int length) {
        this.logBlock = blockLog;
        this.leavesBlock = blockLeaves;
        this.logMeta = metaLog;
        this.leavesMeta = metaLeaves;
        this.logLength = length;
    }

    public boolean func_76484_a(World world, Random rand, int x, int y, int z) {
        Block b;
        int i;
        Block g = world.func_147439_a(x, y - 1, z);
        if (g.func_149688_o() != Material.field_151578_c && g.func_149688_o() != Material.field_151577_b && g.func_149688_o() != Material.field_151595_p && g.func_149688_o() != Material.field_151576_e) {
            return false;
        }
        int dir = rand.nextInt(2);
        int dirMeta = 4 + dir * 4 + this.logMeta;
        boolean leaves = this.leavesMeta > -1;
        int air = 0;
        for (i = 0; i < this.logLength && ((b = world.func_147439_a(x - (dir == 0 ? 1 : 0), y, z - (dir == 1 ? 1 : 0))).func_149688_o() == Material.field_151579_a || b.func_149688_o() == Material.field_151582_l || b.func_149688_o() == Material.field_151585_k); ++i) {
            if (this.airCheck(world, rand, x -= dir == 0 ? 1 : 0, y, z -= dir == 1 ? 1 : 0) <= 0) continue;
            return false;
        }
        for (i = 0; i < this.logLength * 2 && ((b = world.func_147439_a(x + (dir == 0 ? 1 : 0), y, z + (dir == 1 ? 1 : 0))).func_149688_o() == Material.field_151579_a || b.func_149688_o() == Material.field_151582_l || b.func_149688_o() == Material.field_151585_k); ++i) {
            if ((air += this.airCheck(world, rand, x, y, z)) > 2) {
                return false;
            }
            world.func_147465_d(x, y, z, this.logBlock, dirMeta, 0);
            if (this.leavesMeta > -1) {
                this.addLeaves(world, rand, dir, x, y, z);
            }
            x += dir == 0 ? 1 : 0;
            z += dir == 1 ? 1 : 0;
        }
        return true;
    }

    private int airCheck(World world, Random rand, int x, int y, int z) {
        Block b = world.func_147439_a(x, y - 1, z);
        if (b.func_149688_o() == Material.field_151579_a || b.func_149688_o() == Material.field_151582_l || b.func_149688_o() == Material.field_151586_h || b.func_149688_o() == Material.field_151585_k) {
            b = world.func_147439_a(x, y - 2, z);
            if (b.func_149688_o() == Material.field_151579_a || b.func_149688_o() == Material.field_151582_l || b.func_149688_o() == Material.field_151586_h || b.func_149688_o() == Material.field_151585_k) {
                return 99;
            }
            return 1;
        }
        return 0;
    }

    private void addLeaves(World world, Random rand, int dir, int x, int y, int z) {
        Block b;
        if (dir == 0) {
            b = world.func_147439_a(x, y, z - 1);
            if ((b.func_149688_o() == Material.field_151579_a || b.func_149688_o() == Material.field_151582_l || b.func_149688_o() == Material.field_151585_k) && rand.nextInt(3) == 0) {
                world.func_147465_d(x, y, z - 1, this.leavesBlock, this.leavesMeta, 0);
            }
            if (((b = world.func_147439_a(x, y, z + 1)).func_149688_o() == Material.field_151579_a || b.func_149688_o() == Material.field_151582_l || b.func_149688_o() == Material.field_151585_k) && rand.nextInt(3) == 0) {
                world.func_147465_d(x, y, z + 1, this.leavesBlock, this.leavesMeta, 0);
            }
        } else {
            b = world.func_147439_a(x - 1, y, z);
            if ((b.func_149688_o() == Material.field_151579_a || b.func_149688_o() == Material.field_151582_l || b.func_149688_o() == Material.field_151585_k) && rand.nextInt(3) == 0) {
                world.func_147465_d(x - 1, y, z, this.leavesBlock, this.leavesMeta, 0);
            }
            if (((b = world.func_147439_a(x + 1, y, z)).func_149688_o() == Material.field_151579_a || b.func_149688_o() == Material.field_151582_l || b.func_149688_o() == Material.field_151585_k) && rand.nextInt(3) == 0) {
                world.func_147465_d(x + 1, y, z, this.leavesBlock, this.leavesMeta, 0);
            }
        }
        if (((b = world.func_147439_a(x, y + 1, z)).func_149688_o() == Material.field_151579_a || b.func_149688_o() == Material.field_151582_l || b.func_149688_o() == Material.field_151585_k) && rand.nextInt(3) == 0) {
            world.func_147465_d(x, y + 1, z, this.leavesBlock, this.leavesMeta, 0);
        }
    }
}

