/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.gen;

import net.minecraft.world.biome.BiomeGenBase;
import rtg.util.CellNoise;
import rtg.util.OpenSimplexNoise;
import rtg.util.PlaneLocation;
import rtg.util.TimeTracker;
import rtg.util.TimedHashMap;
import rtg.world.biome.BiomeAnalyzer;
import rtg.world.biome.RTGBiomeProvider;
import rtg.world.biome.realistic.RealisticBiomeBase;
import rtg.world.gen.ChunkLandscape;

public class LandscapeGenerator {
    private final int sampleSize = 8;
    private final int sampleArraySize;
    private final int[] biomeData;
    private float[][] weightings;
    private final OpenSimplexNoise simplex;
    private final CellNoise cell;
    private float[] weightedBiomes = new float[BiomeGenBase.func_150565_n().length];
    private BiomeAnalyzer analyzer = new BiomeAnalyzer();
    private TimedHashMap<PlaneLocation, ChunkLandscape> storage = new TimedHashMap(60000);
    public static String biomeLayoutActivity = "Biome Layout";
    private static String rtgTerrain = "RTG Terrain";
    private static String rtgNoise = "RTG Noise";

    public LandscapeGenerator(OpenSimplexNoise simplex, CellNoise cell) {
        this.sampleArraySize = 21;
        this.biomeData = new int[this.sampleArraySize * this.sampleArraySize];
        this.simplex = simplex;
        this.cell = cell;
        this.setWeightings();
    }

    private void setWeightings() {
        this.weightings = new float[this.sampleArraySize * this.sampleArraySize][256];
        int adjustment = 4;
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                int locationIndex = (i + adjustment) * 25 + (j + adjustment);
                TimeTracker.manager.start("Weighting");
                float totalWeight = 0.0f;
                float limit = (float)Math.pow(3136.0, 0.7);
                for (int mapX = 0; mapX < this.sampleArraySize; ++mapX) {
                    for (int mapZ = 0; mapZ < this.sampleArraySize; ++mapZ) {
                        float yDist;
                        float xDist = i - this.chunkCoordinate(mapX);
                        float distanceSquared = xDist * xDist + (yDist = (float)(j - this.chunkCoordinate(mapZ))) * yDist;
                        float distance = (float)Math.pow(distanceSquared, 0.7);
                        float weight = 1.0f - distance / limit;
                        if (weight < 0.0f) {
                            weight = 0.0f;
                        }
                        this.weightings[mapX * this.sampleArraySize + mapZ][i * 16 + j] = weight;
                    }
                }
            }
        }
    }

    private int chunkCoordinate(int biomeMapCoordinate) {
        return (biomeMapCoordinate - 8) * 8;
    }

    public int getBiomeDataAt(RTGBiomeProvider cmr, int worldX, int worldY) {
        int chunkX = worldX & 0xF;
        int chunkY = worldY & 0xF;
        ChunkLandscape target = this.landscape(cmr, worldX - chunkX, worldY - chunkY);
        return target.biome[chunkX * 16 + chunkY].field_76756_M;
    }

    public synchronized ChunkLandscape landscape(RTGBiomeProvider cmr, int worldX, int worldY) {
        PlaneLocation.Invariant location = new PlaneLocation.Invariant(worldX, worldY);
        ChunkLandscape preExisting = this.storage.get(location);
        if (preExisting != null) {
            return preExisting;
        }
        ChunkLandscape result = new ChunkLandscape();
        this.getNewerNoise(cmr, worldX, worldY, result);
        int[] biomeIndices = cmr.getBiomesGens(worldX, worldY, 16, 16);
        this.analyzer.newRepair(biomeIndices, result.biome, this.biomeData, this.sampleSize, result.noise, result.river);
        this.storage.put(location, result);
        return result;
    }

    private synchronized void getNewerNoise(RTGBiomeProvider cmr, int x, int y, ChunkLandscape landscape) {
        int j;
        int i;
        TimeTracker.manager.start(rtgNoise);
        TimeTracker.manager.start(biomeLayoutActivity);
        for (int i2 = -8; i2 < 13; ++i2) {
            for (int j2 = -8; j2 < 13; ++j2) {
                this.biomeData[(i2 + 8) * this.sampleArraySize + (j2 + 8)] = cmr.getBiomeDataAt((int)(x + i2 * 8), (int)(y + j2 * 8)).field_76756_M;
            }
        }
        TimeTracker.manager.stop(biomeLayoutActivity);
        int adjustment = 4;
        for (i = 0; i < 16; ++i) {
            for (j = 0; j < 16; ++j) {
                TimeTracker.manager.start("Weighting");
                float totalWeight = 0.0f;
                for (int mapX = 0; mapX < this.sampleArraySize; ++mapX) {
                    for (int mapZ = 0; mapZ < this.sampleArraySize; ++mapZ) {
                        float weight = this.weightings[mapX * this.sampleArraySize + mapZ][i * 16 + j];
                        if (!(weight > 0.0f)) continue;
                        totalWeight += weight;
                        int n = this.biomeData[mapX * this.sampleArraySize + mapZ];
                        this.weightedBiomes[n] = this.weightedBiomes[n] + weight;
                    }
                }
                int biomeIndex = 0;
                while (biomeIndex < this.weightedBiomes.length) {
                    int n = biomeIndex++;
                    this.weightedBiomes[n] = this.weightedBiomes[n] / totalWeight;
                }
                landscape.noise[i * 16 + j] = 0.0f;
                TimeTracker.manager.stop("Weighting");
                TimeTracker.manager.start("Generating");
                float river = cmr.getRiverStrength(x + i, y + j);
                landscape.river[i * 16 + j] = -river;
                float totalBorder = 0.0f;
                for (int k = 0; k < 256; ++k) {
                    if (!(this.weightedBiomes[k] > 0.0f)) continue;
                    totalBorder += this.weightedBiomes[k];
                    int n = i * 16 + j;
                    landscape.noise[n] = landscape.noise[n] + RealisticBiomeBase.getBiome(k).rNoise(this.simplex, this.cell, x + i, y + j, this.weightedBiomes[k], river + 1.0f) * this.weightedBiomes[k];
                    this.weightedBiomes[k] = 0.0f;
                }
                if ((double)totalBorder < 0.999 || (double)totalBorder > 1.001) {
                    throw new RuntimeException("" + totalBorder);
                }
                TimeTracker.manager.stop("Generating");
            }
        }
        TimeTracker.manager.start(biomeLayoutActivity);
        for (i = 0; i < 16; ++i) {
            for (j = 0; j < 16; ++j) {
                landscape.biome[i * 16 + j] = cmr.getBiomeDataAt(x + ((i - 7) * 8 + 4), y + ((j - 7) * 8 + 4));
            }
        }
        TimeTracker.manager.stop(biomeLayoutActivity);
        TimeTracker.manager.stop(rtgNoise);
    }
}

