/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.biome.realistic.vanilla;

import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.biome.BiomeGenBase;
import rtg.api.biome.BiomeConfig;
import rtg.world.biome.deco.DecoFlowersRTG;
import rtg.world.biome.deco.DecoGrass;
import rtg.world.biome.deco.DecoShrub;
import rtg.world.biome.deco.DecoTree;
import rtg.world.biome.deco.helper.DecoHelperThisOrThat;
import rtg.world.biome.realistic.vanilla.RealisticBiomeVanillaBase;
import rtg.world.gen.feature.tree.rtg.TreeRTGQuercusRobur;
import rtg.world.gen.surface.vanilla.SurfaceVanillaPlains;
import rtg.world.gen.terrain.TerrainBase;
import rtg.world.gen.terrain.vanilla.TerrainVanillaPlains;

public class RealisticBiomeVanillaPlains
extends RealisticBiomeVanillaBase {
    public static Block topBlock = BiomeGenBase.field_76772_c.field_76752_A;
    public static Block fillerBlock = BiomeGenBase.field_76772_c.field_76753_B;

    public RealisticBiomeVanillaPlains(BiomeConfig config) {
        super(config, BiomeGenBase.field_76772_c, BiomeGenBase.field_76781_i, (TerrainBase)new TerrainVanillaPlains(), new SurfaceVanillaPlains(config, topBlock, fillerBlock));
        DecoShrub decoShrubOak = new DecoShrub();
        decoShrubOak.logBlock = Blocks.field_150364_r;
        decoShrubOak.logMeta = 0;
        decoShrubOak.leavesBlock = Blocks.field_150362_t;
        decoShrubOak.leavesMeta = 0;
        decoShrubOak.maxY = 110;
        decoShrubOak.loops = 1;
        decoShrubOak.chance = 36;
        this.addDeco(decoShrubOak);
        DecoFlowersRTG decoFlowersRTG = new DecoFlowersRTG();
        decoFlowersRTG.flowers = new int[]{0, 2, 3, 4, 5, 6, 7, 8, 9};
        decoFlowersRTG.maxY = 128;
        decoFlowersRTG.strengthFactor = 2.0f;
        this.addDeco(decoFlowersRTG);
        DecoGrass decoGrass = new DecoGrass();
        decoGrass.minY = 60;
        decoGrass.maxY = 128;
        decoGrass.loops = 6;
        this.addDeco(decoGrass);
        DecoTree oakTrees = new DecoTree(new TreeRTGQuercusRobur());
        oakTrees.treeType = DecoTree.TreeType.RTG_TREE;
        oakTrees.treeCondition = DecoTree.TreeCondition.NOISE_GREATER_AND_RANDOM_CHANCE;
        oakTrees.distribution = new DecoTree.Distribution(100.0f, 6.0f, 0.8f);
        oakTrees.treeConditionNoise = 0.4f;
        oakTrees.treeConditionChance = 48;
        oakTrees.logBlock = Blocks.field_150364_r;
        oakTrees.logMeta = 0;
        oakTrees.leavesBlock = Blocks.field_150362_t;
        oakTrees.leavesMeta = 0;
        oakTrees.noLeaves = false;
        DecoTree birchTrees = new DecoTree(oakTrees);
        birchTrees.logMeta = (byte)2;
        birchTrees.leavesMeta = (byte)2;
        this.addDeco(new DecoHelperThisOrThat(4, DecoHelperThisOrThat.ChanceType.NOT_EQUALS_ZERO, oakTrees, birchTrees));
    }
}

