/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.biome.realistic.highlands;

import highlands.Highlands;
import highlands.api.HighlandsBiomes;
import highlands.api.HighlandsBlocks;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.biome.BiomeGenBase;
import rtg.api.biome.BiomeConfig;
import rtg.world.biome.deco.DecoBaseBiomeDecorations;
import rtg.world.biome.deco.DecoBoulder;
import rtg.world.biome.deco.DecoFallenTree;
import rtg.world.biome.deco.DecoFlowersRTG;
import rtg.world.biome.deco.DecoGrass;
import rtg.world.biome.deco.DecoHLTree;
import rtg.world.biome.deco.DecoJungleGrassVines;
import rtg.world.biome.deco.DecoJungleLilypadVines;
import rtg.world.biome.deco.DecoTree;
import rtg.world.biome.realistic.highlands.RealisticBiomeHLBase;
import rtg.world.gen.surface.highlands.SurfaceHLTropics;
import rtg.world.gen.terrain.TerrainBase;
import rtg.world.gen.terrain.highlands.TerrainHLTropics;

public class RealisticBiomeHLTropics
extends RealisticBiomeHLBase {
    public static BiomeGenBase hlBiome = HighlandsBiomes.tropics;
    public static Block topBlock = RealisticBiomeHLTropics.hlBiome.field_76752_A;
    public static Block fillerBlock = RealisticBiomeHLTropics.hlBiome.field_76753_B;

    public RealisticBiomeHLTropics(BiomeConfig config) {
        super(config, hlBiome, BiomeGenBase.field_76781_i, (TerrainBase)new TerrainHLTropics(), new SurfaceHLTropics(config, topBlock, fillerBlock));
        this.waterSurfaceLakeChance = 3;
        DecoHLTree highlandsShrubs = new DecoHLTree();
        highlandsShrubs.logMeta = (byte)3;
        highlandsShrubs.leavesMeta = 0;
        highlandsShrubs.strengthFactorForLoops = 4.0f;
        highlandsShrubs.treeType = DecoHLTree.TreeType.HIGHLANDS_SHRUB;
        highlandsShrubs.treeCondition = DecoTree.TreeCondition.ALWAYS_GENERATE;
        highlandsShrubs.maxY = 90;
        this.addDeco(highlandsShrubs);
        DecoHLTree thinCanopyTrees = new DecoHLTree();
        thinCanopyTrees.thickTrunk = false;
        thinCanopyTrees.minSize = 13;
        thinCanopyTrees.maxSize = 24;
        thinCanopyTrees.strengthFactorForLoops = 2.0f;
        thinCanopyTrees.treeType = DecoHLTree.TreeType.CANOPY;
        thinCanopyTrees.treeCondition = DecoTree.TreeCondition.ALWAYS_GENERATE;
        thinCanopyTrees.maxY = 120;
        this.addDeco(thinCanopyTrees);
        DecoFallenTree decoFallenTree = new DecoFallenTree();
        decoFallenTree.loops = 1;
        decoFallenTree.distribution.noiseDivisor = 100.0f;
        decoFallenTree.distribution.noiseFactor = 5.0f;
        decoFallenTree.distribution.noiseAddend = 0.8f;
        decoFallenTree.logCondition = DecoFallenTree.LogCondition.NOISE_GREATER_AND_RANDOM_CHANCE;
        decoFallenTree.logConditionNoise = 0.0f;
        decoFallenTree.logConditionChance = 10;
        decoFallenTree.maxY = 90;
        decoFallenTree.logBlock = Highlands.vanillaBlocksFlag ? Blocks.field_150364_r : HighlandsBlocks.canopyWood;
        decoFallenTree.logMeta = 0;
        decoFallenTree.leavesBlock = Highlands.vanillaBlocksFlag ? Blocks.field_150362_t : HighlandsBlocks.canopyLeaves;
        decoFallenTree.leavesMeta = (byte)-1;
        decoFallenTree.minSize = 4;
        decoFallenTree.maxSize = 7;
        this.addDeco(decoFallenTree, this.config._boolean("decorationLogs"));
        DecoBoulder decoBoulder = new DecoBoulder();
        decoBoulder.boulderBlock = Blocks.field_150347_e;
        decoBoulder.chance = 16;
        decoBoulder.maxY = 95;
        decoBoulder.strengthFactor = 2.0f;
        this.addDeco(decoBoulder);
        DecoBaseBiomeDecorations decoBaseBiomeDecorations = new DecoBaseBiomeDecorations();
        decoBaseBiomeDecorations.equalsZeroChance = 4;
        decoBaseBiomeDecorations.maxY = 210;
        this.addDeco(decoBaseBiomeDecorations);
        DecoJungleLilypadVines decoJungleLilypadVines = new DecoJungleLilypadVines();
        this.addDeco(decoJungleLilypadVines);
        DecoJungleGrassVines decoJungleGrassVines = new DecoJungleGrassVines();
        this.addDeco(decoJungleLilypadVines);
        DecoFlowersRTG decoFlowersRTG = new DecoFlowersRTG();
        decoFlowersRTG.flowers = new int[]{3, 6, 8};
        decoFlowersRTG.chance = 3;
        decoFlowersRTG.maxY = 120;
        decoFlowersRTG.strengthFactor = 2.0f;
        this.addDeco(decoFlowersRTG);
        DecoGrass decoGrass = new DecoGrass();
        decoGrass.maxY = 128;
        decoGrass.loops = 16;
        decoGrass.randomGrassBlocks = new Block[]{Blocks.field_150329_H, HighlandsBlocks.leafyFern};
        decoGrass.randomGrassMetas = new byte[]{2, 0};
        this.addDeco(decoGrass);
    }
}

