/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.biome.realistic.highlands;

import highlands.Highlands;
import highlands.api.HighlandsBiomes;
import highlands.api.HighlandsBlocks;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.feature.WorldGenerator;
import rtg.api.biome.BiomeConfig;
import rtg.world.biome.deco.DecoBoulder;
import rtg.world.biome.deco.DecoFallenTree;
import rtg.world.biome.deco.DecoFlowersRTG;
import rtg.world.biome.deco.DecoGrass;
import rtg.world.biome.deco.DecoJungleLilypadVines;
import rtg.world.biome.deco.DecoShrub;
import rtg.world.biome.deco.DecoTree;
import rtg.world.biome.deco.helper.DecoHelperThisOrThat;
import rtg.world.biome.realistic.highlands.RealisticBiomeHLBase;
import rtg.world.gen.feature.tree.highlands.HLPalmTreeRTG;
import rtg.world.gen.feature.tree.rtg.TreeRTGCocosNucifera;
import rtg.world.gen.surface.highlands.SurfaceHLTropicalIslands;
import rtg.world.gen.terrain.TerrainBase;
import rtg.world.gen.terrain.highlands.TerrainHLTropicalIslands;

public class RealisticBiomeHLTropicalIslands
extends RealisticBiomeHLBase {
    public static BiomeGenBase hlBiome = HighlandsBiomes.tropicalIslands;
    public static Block topBlock = RealisticBiomeHLTropicalIslands.hlBiome.field_76752_A;
    public static Block fillerBlock = RealisticBiomeHLTropicalIslands.hlBiome.field_76753_B;

    public RealisticBiomeHLTropicalIslands(BiomeConfig config) {
        super(config, hlBiome, BiomeGenBase.field_76781_i, (TerrainBase)new TerrainHLTropicalIslands(90.0f, 180.0f, 13.0f, 100.0f, 1.0f, 260.0f, 59.0f), new SurfaceHLTropicalIslands(config, topBlock, fillerBlock));
        this.waterSurfaceLakeChance = 4;
        DecoTree highlandsPalmTrees = new DecoTree((WorldGenerator)new HLPalmTreeRTG(8, 7, false));
        highlandsPalmTrees.treeType = DecoTree.TreeType.WORLDGEN;
        highlandsPalmTrees.treeCondition = DecoTree.TreeCondition.NOISE_GREATER_AND_RANDOM_CHANCE;
        highlandsPalmTrees.distribution = new DecoTree.Distribution(100.0f, 6.0f, 0.8f);
        highlandsPalmTrees.treeConditionNoise = -0.4f;
        highlandsPalmTrees.treeConditionChance = 1;
        highlandsPalmTrees.maxY = 160;
        this.addDeco(highlandsPalmTrees);
        DecoTree vanillaPalmTrees = new DecoTree(new TreeRTGCocosNucifera());
        vanillaPalmTrees.treeType = DecoTree.TreeType.RTG_TREE;
        vanillaPalmTrees.treeCondition = DecoTree.TreeCondition.NOISE_GREATER_AND_RANDOM_CHANCE;
        vanillaPalmTrees.distribution = new DecoTree.Distribution(80.0f, 60.0f, -15.0f);
        vanillaPalmTrees.treeConditionNoise = 0.0f;
        vanillaPalmTrees.treeConditionChance = 4;
        vanillaPalmTrees.logBlock = Blocks.field_150364_r;
        vanillaPalmTrees.logMeta = (byte)3;
        vanillaPalmTrees.leavesBlock = Blocks.field_150362_t;
        vanillaPalmTrees.leavesMeta = (byte)3;
        vanillaPalmTrees.minTrunkSize = 7;
        vanillaPalmTrees.maxTrunkSize = 8;
        vanillaPalmTrees.minCrownSize = 8;
        vanillaPalmTrees.maxCrownSize = 12;
        vanillaPalmTrees.noLeaves = false;
        this.addDeco(vanillaPalmTrees);
        DecoShrub decoShrubVanilla = new DecoShrub();
        decoShrubVanilla.logBlock = Blocks.field_150364_r;
        decoShrubVanilla.logMeta = (byte)3;
        decoShrubVanilla.leavesBlock = Blocks.field_150362_t;
        decoShrubVanilla.leavesMeta = (byte)3;
        decoShrubVanilla.maxY = 100;
        decoShrubVanilla.strengthFactor = 4.0f;
        decoShrubVanilla.chance = 3;
        DecoShrub decoShrubHL = new DecoShrub();
        decoShrubHL.logBlock = Highlands.vanillaBlocksFlag ? Blocks.field_150364_r : HighlandsBlocks.palmWood;
        decoShrubHL.logMeta = (byte)(Highlands.vanillaBlocksFlag ? 3 : 0);
        decoShrubHL.leavesBlock = Highlands.vanillaBlocksFlag ? Blocks.field_150362_t : HighlandsBlocks.palmLeaves;
        decoShrubHL.leavesMeta = (byte)(Highlands.vanillaBlocksFlag ? 3 : 0);
        decoShrubHL.maxY = 100;
        decoShrubHL.strengthFactor = 4.0f;
        decoShrubHL.chance = 3;
        this.addDeco(new DecoHelperThisOrThat(4, DecoHelperThisOrThat.ChanceType.NOT_EQUALS_ZERO, decoShrubVanilla, decoShrubHL));
        DecoFallenTree decoFallenTree = new DecoFallenTree();
        decoFallenTree.loops = 1;
        decoFallenTree.distribution.noiseDivisor = 100.0f;
        decoFallenTree.distribution.noiseFactor = 6.0f;
        decoFallenTree.distribution.noiseAddend = 0.8f;
        decoFallenTree.logCondition = DecoFallenTree.LogCondition.NOISE_GREATER_AND_RANDOM_CHANCE;
        decoFallenTree.logConditionNoise = 0.0f;
        decoFallenTree.logConditionChance = 24;
        decoFallenTree.maxY = 120;
        decoFallenTree.logBlock = Blocks.field_150364_r;
        decoFallenTree.logMeta = (byte)3;
        decoFallenTree.leavesBlock = Blocks.field_150362_t;
        decoFallenTree.leavesMeta = (byte)-1;
        decoFallenTree.minSize = 4;
        decoFallenTree.maxSize = 8;
        this.addDeco(decoFallenTree, this.config._boolean("decorationLogs"));
        DecoJungleLilypadVines decoJungleLilypadVines = new DecoJungleLilypadVines();
        this.addDeco(decoJungleLilypadVines);
        DecoFlowersRTG decoFlowersRTG = new DecoFlowersRTG();
        decoFlowersRTG.flowers = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9};
        decoFlowersRTG.chance = 3;
        decoFlowersRTG.maxY = 120;
        decoFlowersRTG.strengthFactor = 4.0f;
        this.addDeco(decoFlowersRTG);
        DecoBoulder decoBoulder = new DecoBoulder();
        decoBoulder.boulderBlock = Blocks.field_150341_Y;
        decoBoulder.chance = 36;
        decoBoulder.maxY = 95;
        decoBoulder.strengthFactor = 1.0f;
        this.addDeco(decoBoulder);
        DecoGrass decoFern = new DecoGrass(2);
        decoFern.maxY = 128;
        decoFern.strengthFactor = 10.0f;
        this.addDeco(decoFern);
        DecoGrass decoGrass = new DecoGrass();
        decoGrass.maxY = 128;
        decoGrass.strengthFactor = 4.0f;
        this.addDeco(decoGrass);
        this.noLakes = true;
        this.noWaterFeatures = true;
    }
}

