/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.biome.realistic.highlands;

import highlands.api.HighlandsBiomes;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.biome.BiomeGenBase;
import rtg.api.biome.BiomeConfig;
import rtg.world.biome.deco.DecoBoulder;
import rtg.world.biome.deco.DecoFallenTree;
import rtg.world.biome.deco.DecoGrass;
import rtg.world.biome.deco.DecoMushrooms;
import rtg.world.biome.deco.DecoPumpkin;
import rtg.world.biome.deco.DecoShrub;
import rtg.world.biome.deco.DecoTree;
import rtg.world.biome.realistic.highlands.RealisticBiomeHLBase;
import rtg.world.gen.feature.tree.rtg.TreeRTGPinusNigra;
import rtg.world.gen.surface.highlands.SurfaceHLRockMountains;
import rtg.world.gen.terrain.TerrainBase;
import rtg.world.gen.terrain.highlands.TerrainHLRockMountains;

public class RealisticBiomeHLRockMountains
extends RealisticBiomeHLBase {
    public static BiomeGenBase hlBiome = HighlandsBiomes.rockMountains;
    public static Block topBlock = RealisticBiomeHLRockMountains.hlBiome.field_76752_A;
    public static Block fillerBlock = RealisticBiomeHLRockMountains.hlBiome.field_76753_B;

    public RealisticBiomeHLRockMountains(BiomeConfig config) {
        super(config, hlBiome, BiomeGenBase.field_76781_i, (TerrainBase)new TerrainHLRockMountains(230.0f, 100.0f, 68.0f), new SurfaceHLRockMountains(config, topBlock, fillerBlock, false, null, 0.0f, 1.5f, 60.0f, 65.0f, 1.5f));
        this.generatesEmeralds = true;
        this.noWaterFeatures = true;
        DecoBoulder decoBoulder = new DecoBoulder();
        decoBoulder.boulderBlock = Blocks.field_150341_Y;
        decoBoulder.chance = 16;
        decoBoulder.maxY = 95;
        decoBoulder.strengthFactor = 3.0f;
        this.addDeco(decoBoulder);
        DecoTree decoTrees = new DecoTree(new TreeRTGPinusNigra());
        decoTrees.logBlock = Blocks.field_150364_r;
        decoTrees.logMeta = 0;
        decoTrees.leavesBlock = Blocks.field_150362_t;
        decoTrees.leavesMeta = 0;
        decoTrees.minTrunkSize = 18;
        decoTrees.maxTrunkSize = 27;
        decoTrees.minCrownSize = 7;
        decoTrees.maxCrownSize = 10;
        decoTrees.strengthFactorForLoops = 4.0f;
        decoTrees.strengthNoiseFactorXForLoops = true;
        decoTrees.distribution.noiseDivisor = 100.0f;
        decoTrees.distribution.noiseFactor = 6.0f;
        decoTrees.distribution.noiseAddend = 0.8f;
        decoTrees.treeType = DecoTree.TreeType.RTG_TREE;
        decoTrees.treeCondition = DecoTree.TreeCondition.RANDOM_CHANCE;
        decoTrees.treeConditionChance = 24;
        decoTrees.maxY = 100;
        this.addDeco(decoTrees);
        DecoFallenTree decoFallenTree = new DecoFallenTree();
        decoFallenTree.distribution.noiseDivisor = 100.0f;
        decoFallenTree.distribution.noiseFactor = 6.0f;
        decoFallenTree.distribution.noiseAddend = 0.8f;
        decoFallenTree.logCondition = DecoFallenTree.LogCondition.NOISE_GREATER_AND_RANDOM_CHANCE;
        decoFallenTree.logConditionNoise = 0.0f;
        decoFallenTree.logConditionChance = 6;
        decoFallenTree.maxY = 100;
        decoFallenTree.logBlock = Blocks.field_150364_r;
        decoFallenTree.logMeta = 1;
        decoFallenTree.leavesBlock = Blocks.field_150362_t;
        decoFallenTree.leavesMeta = (byte)-1;
        decoFallenTree.minSize = 3;
        decoFallenTree.maxSize = 6;
        this.addDeco(decoFallenTree, this.config._boolean("decorationLogs"));
        DecoShrub decoShrub = new DecoShrub();
        decoShrub.maxY = 100;
        decoShrub.strengthFactor = 2.0f;
        this.addDeco(decoShrub);
        DecoMushrooms decoMushrooms = new DecoMushrooms();
        decoMushrooms.maxY = 90;
        decoMushrooms.randomType = DecoMushrooms.RandomType.X_DIVIDED_BY_STRENGTH;
        decoMushrooms.randomFloat = 3.0f;
        this.addDeco(decoMushrooms);
        DecoPumpkin decoPumpkin = new DecoPumpkin();
        decoPumpkin.maxY = 90;
        decoPumpkin.randomType = DecoPumpkin.RandomType.X_DIVIDED_BY_STRENGTH;
        decoPumpkin.randomFloat = 20.0f;
        this.addDeco(decoPumpkin);
        DecoGrass decoGrass = new DecoGrass();
        decoGrass.maxY = 128;
        decoGrass.strengthFactor = 10.0f;
        this.addDeco(decoGrass);
        this.noLakes = true;
        this.noWaterFeatures = true;
    }
}

