/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.biome.realistic.highlands;

import highlands.api.HighlandsBiomes;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.feature.WorldGenerator;
import rtg.api.biome.BiomeConfig;
import rtg.world.biome.deco.DecoCactus;
import rtg.world.biome.deco.DecoFallenTree;
import rtg.world.biome.deco.DecoFlowersRTG;
import rtg.world.biome.deco.DecoGrass;
import rtg.world.biome.deco.DecoTree;
import rtg.world.biome.realistic.highlands.RealisticBiomeHLBase;
import rtg.world.gen.feature.tree.highlands.HLPalmTreeRTG;
import rtg.world.gen.feature.tree.rtg.TreeRTGCocosNucifera;
import rtg.world.gen.surface.highlands.SurfaceHLOasis;
import rtg.world.gen.terrain.TerrainBase;
import rtg.world.gen.terrain.highlands.TerrainHLOasis;

public class RealisticBiomeHLOasis
extends RealisticBiomeHLBase {
    public static BiomeGenBase hlBiome = HighlandsBiomes.oasis;
    public static Block topBlock = RealisticBiomeHLOasis.hlBiome.field_76752_A;
    public static Block fillerBlock = RealisticBiomeHLOasis.hlBiome.field_76753_B;

    public RealisticBiomeHLOasis(BiomeConfig config) {
        super(config, hlBiome, BiomeGenBase.field_76781_i, (TerrainBase)new TerrainHLOasis(), new SurfaceHLOasis(config, (Block)Blocks.field_150354_m, fillerBlock));
        DecoTree highlandsPalmTrees = new DecoTree((WorldGenerator)new HLPalmTreeRTG(8, 7, false));
        highlandsPalmTrees.treeType = DecoTree.TreeType.WORLDGEN;
        highlandsPalmTrees.treeCondition = DecoTree.TreeCondition.NOISE_GREATER_AND_RANDOM_CHANCE;
        highlandsPalmTrees.distribution = new DecoTree.Distribution(100.0f, 6.0f, 0.8f);
        highlandsPalmTrees.treeConditionNoise = 0.0f;
        highlandsPalmTrees.treeConditionChance = 2;
        highlandsPalmTrees.maxY = 75;
        this.addDeco(highlandsPalmTrees);
        DecoTree vanillaPalmTrees = new DecoTree(new TreeRTGCocosNucifera());
        vanillaPalmTrees.treeType = DecoTree.TreeType.RTG_TREE;
        vanillaPalmTrees.treeCondition = DecoTree.TreeCondition.NOISE_GREATER_AND_RANDOM_CHANCE;
        vanillaPalmTrees.distribution = new DecoTree.Distribution(80.0f, 60.0f, -15.0f);
        vanillaPalmTrees.treeConditionNoise = 0.0f;
        vanillaPalmTrees.treeConditionChance = 6;
        vanillaPalmTrees.maxY = 75;
        vanillaPalmTrees.logBlock = Blocks.field_150364_r;
        vanillaPalmTrees.logMeta = (byte)3;
        vanillaPalmTrees.leavesBlock = Blocks.field_150362_t;
        vanillaPalmTrees.leavesMeta = (byte)3;
        vanillaPalmTrees.minTrunkSize = 7;
        vanillaPalmTrees.maxTrunkSize = 8;
        vanillaPalmTrees.minCrownSize = 8;
        vanillaPalmTrees.maxCrownSize = 12;
        vanillaPalmTrees.noLeaves = false;
        this.addDeco(vanillaPalmTrees);
        DecoFallenTree decoFallenTree = new DecoFallenTree();
        decoFallenTree.loops = 1;
        decoFallenTree.distribution = new DecoFallenTree.Distribution(80.0f, 60.0f, -15.0f);
        decoFallenTree.logCondition = DecoFallenTree.LogCondition.NOISE_LESS_AND_RANDOM_CHANCE;
        decoFallenTree.logConditionNoise = 0.0f;
        decoFallenTree.logConditionChance = 24;
        decoFallenTree.maxY = 70;
        decoFallenTree.logBlock = Blocks.field_150364_r;
        decoFallenTree.logMeta = (byte)3;
        decoFallenTree.leavesBlock = Blocks.field_150362_t;
        decoFallenTree.leavesMeta = (byte)-1;
        decoFallenTree.minSize = 4;
        decoFallenTree.maxSize = 6;
        this.addDeco(decoFallenTree, this.config._boolean("decorationLogs"));
        DecoCactus decoCactus = new DecoCactus();
        decoCactus.maxY = 90;
        decoCactus.strengthFactor = 3.0f;
        decoCactus.chance = 2;
        this.addDeco(decoCactus);
        DecoFlowersRTG decoFlowersRTG = new DecoFlowersRTG();
        decoFlowersRTG.flowers = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9};
        decoFlowersRTG.chance = 4;
        decoFlowersRTG.maxY = 120;
        decoFlowersRTG.strengthFactor = 2.0f;
        this.addDeco(decoFlowersRTG);
        DecoGrass decoGrass = new DecoGrass();
        decoGrass.maxY = 128;
        decoGrass.strengthFactor = 6.0f;
        this.addDeco(decoGrass);
    }
}

