/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.biome.realistic.highlands;

import highlands.Highlands;
import highlands.api.HighlandsBiomes;
import highlands.api.HighlandsBlocks;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.biome.BiomeGenBase;
import rtg.api.biome.BiomeConfig;
import rtg.world.biome.deco.DecoBase;
import rtg.world.biome.deco.DecoBaseBiomeDecorations;
import rtg.world.biome.deco.DecoFallenTree;
import rtg.world.biome.deco.DecoGrass;
import rtg.world.biome.deco.DecoTree;
import rtg.world.biome.deco.helper.DecoHelper5050;
import rtg.world.biome.deco.helper.DecoHelperRandomSplit;
import rtg.world.biome.realistic.highlands.RealisticBiomeHLBase;
import rtg.world.gen.feature.tree.rtg.TreeRTGPiceaPungens;
import rtg.world.gen.feature.tree.rtg.TreeRTGPinusPonderosa;
import rtg.world.gen.surface.highlands.SurfaceHLAutumnForest;
import rtg.world.gen.terrain.TerrainBase;
import rtg.world.gen.terrain.highlands.TerrainHLAutumnForest;

public class RealisticBiomeHLAutumnForest
extends RealisticBiomeHLBase {
    public static BiomeGenBase hlBiome = HighlandsBiomes.autumnForest;
    public static Block topBlock = RealisticBiomeHLAutumnForest.hlBiome.field_76752_A;
    public static Block fillerBlock = RealisticBiomeHLAutumnForest.hlBiome.field_76753_B;

    public RealisticBiomeHLAutumnForest(BiomeConfig config) {
        super(config, hlBiome, BiomeGenBase.field_76781_i, (TerrainBase)new TerrainHLAutumnForest(0.0f, 50.0f, 68.0f, 200.0f), new SurfaceHLAutumnForest(config, topBlock, fillerBlock));
        this.noWaterFeatures = false;
        DecoTree yellowPines = new DecoTree(new TreeRTGPinusPonderosa());
        yellowPines.logBlock = Blocks.field_150364_r;
        yellowPines.logMeta = 0;
        yellowPines.leavesBlock = Highlands.vanillaBlocksFlag ? Blocks.field_150362_t : HighlandsBlocks.autumnYellowLeaves;
        yellowPines.leavesMeta = Highlands.vanillaBlocksFlag ? (byte)0 : 0;
        yellowPines.minTrunkSize = 6;
        yellowPines.maxTrunkSize = 14;
        yellowPines.minCrownSize = 8;
        yellowPines.maxCrownSize = 20;
        yellowPines.strengthFactorForLoops = 6.0f;
        yellowPines.treeType = DecoTree.TreeType.RTG_TREE;
        yellowPines.distribution.noiseDivisor = 100.0f;
        yellowPines.distribution.noiseFactor = 6.0f;
        yellowPines.distribution.noiseAddend = 0.8f;
        yellowPines.treeCondition = DecoTree.TreeCondition.NOISE_GREATER_AND_RANDOM_CHANCE;
        yellowPines.treeConditionNoise = -0.4f;
        yellowPines.treeConditionChance = 1;
        yellowPines.maxY = 110;
        DecoTree orangePines = new DecoTree(yellowPines);
        orangePines.leavesBlock = Highlands.vanillaBlocksFlag ? Blocks.field_150362_t : HighlandsBlocks.autumnOrangeLeaves;
        orangePines.leavesMeta = (byte)(Highlands.vanillaBlocksFlag ? 2 : 0);
        DecoTree spruceTrees = new DecoTree(new TreeRTGPiceaPungens());
        spruceTrees.logBlock = Blocks.field_150364_r;
        spruceTrees.logMeta = 1;
        spruceTrees.leavesBlock = Blocks.field_150362_t;
        spruceTrees.leavesMeta = 1;
        spruceTrees.minTrunkSize = 4;
        spruceTrees.maxTrunkSize = 10;
        spruceTrees.minCrownSize = 6;
        spruceTrees.maxCrownSize = 17;
        spruceTrees.strengthFactorForLoops = 5.0f;
        spruceTrees.treeType = DecoTree.TreeType.RTG_TREE;
        spruceTrees.distribution.noiseDivisor = 100.0f;
        spruceTrees.distribution.noiseFactor = 6.0f;
        spruceTrees.distribution.noiseAddend = 0.8f;
        spruceTrees.treeCondition = DecoTree.TreeCondition.NOISE_GREATER_AND_RANDOM_CHANCE;
        spruceTrees.treeConditionNoise = 0.0f;
        spruceTrees.treeConditionChance = 1;
        spruceTrees.maxY = 110;
        DecoHelperRandomSplit decoTrees = new DecoHelperRandomSplit();
        decoTrees.decos = new DecoBase[]{yellowPines, orangePines, spruceTrees};
        decoTrees.chances = new int[]{8, 8, 4};
        this.addDeco(decoTrees);
        DecoTree deadPineTree = new DecoTree(new TreeRTGPinusPonderosa());
        deadPineTree.logBlock = Blocks.field_150364_r;
        deadPineTree.logMeta = 0;
        deadPineTree.leavesBlock = Blocks.field_150362_t;
        deadPineTree.leavesMeta = 0;
        deadPineTree.minTrunkSize = 4;
        deadPineTree.maxTrunkSize = 7;
        deadPineTree.minCrownSize = 8;
        deadPineTree.maxCrownSize = 18;
        deadPineTree.treeType = DecoTree.TreeType.RTG_TREE;
        deadPineTree.treeCondition = DecoTree.TreeCondition.RANDOM_CHANCE;
        deadPineTree.treeConditionChance = 18;
        deadPineTree.maxY = 120;
        deadPineTree.noLeaves = true;
        this.addDeco(deadPineTree);
        DecoFallenTree decoFallenOak = new DecoFallenTree();
        decoFallenOak.logCondition = DecoFallenTree.LogCondition.RANDOM_CHANCE;
        decoFallenOak.logConditionChance = 20;
        decoFallenOak.maxY = 90;
        decoFallenOak.logBlock = Blocks.field_150364_r;
        decoFallenOak.logMeta = 0;
        decoFallenOak.leavesBlock = Blocks.field_150362_t;
        decoFallenOak.leavesMeta = (byte)-1;
        decoFallenOak.minSize = 4;
        decoFallenOak.maxSize = 8;
        DecoFallenTree decoFallenSpruce = new DecoFallenTree(decoFallenOak);
        decoFallenSpruce.logConditionChance = 24;
        decoFallenSpruce.logMeta = 1;
        decoFallenSpruce.minSize = 3;
        decoFallenSpruce.maxSize = 5;
        DecoHelper5050 decoFallenTree = new DecoHelper5050(decoFallenOak, decoFallenSpruce);
        this.addDeco(decoFallenTree, this.config._boolean("decorationLogs"));
        DecoBaseBiomeDecorations decoBaseBiomeDecorations = new DecoBaseBiomeDecorations();
        decoBaseBiomeDecorations.notEqualsZeroChance = 3;
        this.addDeco(decoBaseBiomeDecorations);
        DecoGrass decoGrass = new DecoGrass();
        decoGrass.minY = 53;
        decoGrass.maxY = 128;
        decoGrass.loops = 8;
        this.addDeco(decoGrass);
    }
}

