/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.biome.realistic.biomesoplenty;

import biomesoplenty.api.content.BOPCBiomes;
import biomesoplenty.api.content.BOPCBlocks;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.biome.BiomeGenBase;
import rtg.api.biome.BiomeConfig;
import rtg.util.CellNoise;
import rtg.util.OpenSimplexNoise;
import rtg.util.SimplexOctave;
import rtg.world.biome.deco.DecoBaseBiomeDecorations;
import rtg.world.biome.deco.DecoBoulder;
import rtg.world.biome.deco.DecoFallenTree;
import rtg.world.biome.deco.helper.DecoHelper5050;
import rtg.world.biome.realistic.biomesoplenty.RealisticBiomeBOPBase;
import rtg.world.gen.surface.biomesoplenty.SurfaceBOPShield;
import rtg.world.gen.terrain.TerrainBase;
import rtg.world.gen.terrain.biomesoplenty.TerrainBOPShield;

public class RealisticBiomeBOPShield
extends RealisticBiomeBOPBase {
    public static BiomeGenBase bopBiome = BOPCBiomes.shield;
    public static Block topBlock = RealisticBiomeBOPShield.bopBiome.field_76752_A;
    public static Block fillerBlock = RealisticBiomeBOPShield.bopBiome.field_76753_B;
    private float lakeInterval = 80.0f;

    public RealisticBiomeBOPShield(BiomeConfig config) {
        super(config, bopBiome, BiomeGenBase.field_76781_i, (TerrainBase)new TerrainBOPShield(0.0f, 100.0f, 68.0f, 170.0f), new SurfaceBOPShield(config, topBlock, fillerBlock));
        DecoBaseBiomeDecorations decoBaseBiomeDecorations = new DecoBaseBiomeDecorations();
        this.addDeco(decoBaseBiomeDecorations);
        DecoBoulder decoBoulder = new DecoBoulder();
        decoBoulder.boulderBlock = Blocks.field_150347_e;
        decoBoulder.maxY = 80;
        decoBoulder.chance = 16;
        decoBoulder.strengthFactor = 1.0f;
        this.addDeco(decoBoulder);
        DecoFallenTree decoFallenTree1 = new DecoFallenTree();
        decoFallenTree1.distribution.noiseDivisor = 80.0f;
        decoFallenTree1.distribution.noiseFactor = 60.0f;
        decoFallenTree1.distribution.noiseAddend = -15.0f;
        decoFallenTree1.logCondition = DecoFallenTree.LogCondition.RANDOM_CHANCE;
        decoFallenTree1.logConditionNoise = 0.0f;
        decoFallenTree1.logConditionChance = 6;
        decoFallenTree1.maxY = 100;
        decoFallenTree1.logBlock = BOPCBlocks.logs4;
        decoFallenTree1.logMeta = 0;
        decoFallenTree1.leavesBlock = Blocks.field_150362_t;
        decoFallenTree1.leavesMeta = (byte)-1;
        decoFallenTree1.minSize = 3;
        decoFallenTree1.maxSize = 4;
        DecoFallenTree decoFallenTree2 = new DecoFallenTree();
        decoFallenTree2.distribution.noiseDivisor = 80.0f;
        decoFallenTree2.distribution.noiseFactor = 60.0f;
        decoFallenTree2.distribution.noiseAddend = -15.0f;
        decoFallenTree2.logCondition = DecoFallenTree.LogCondition.RANDOM_CHANCE;
        decoFallenTree2.logConditionNoise = 0.0f;
        decoFallenTree2.logConditionChance = 6;
        decoFallenTree2.maxY = 100;
        decoFallenTree2.logBlock = Blocks.field_150364_r;
        decoFallenTree2.logMeta = 1;
        decoFallenTree2.leavesBlock = Blocks.field_150362_t;
        decoFallenTree2.leavesMeta = (byte)-1;
        decoFallenTree2.minSize = 3;
        decoFallenTree2.maxSize = 4;
        DecoHelper5050 decoHelperHelper5050 = new DecoHelper5050(decoFallenTree1, decoFallenTree2);
        this.addDeco(decoHelperHelper5050, this.config._boolean("decorationLogs"));
    }

    @Override
    public float lakePressure(OpenSimplexNoise simplex, CellNoise simplexCell, int x, int y, float border) {
        float baseLakes = super.lakePressure(simplex, simplexCell, x, y, border);
        SimplexOctave.Derivative jitter = new SimplexOctave.Derivative();
        simplex.riverJitter().evaluateNoise((double)x / 30.0, (double)y / 30.0, jitter);
        double pX = (double)x + jitter.deltax() * 15.0;
        double pY = (double)y + jitter.deltay() * 15.0;
        simplex.mountain().evaluateNoise((double)x / 10.0, (double)y / 10.0, jitter);
        pX += jitter.deltax() * 4.0;
        pY += jitter.deltay() * 4.0;
        double[] lakeResults = simplexCell.river().eval((float)x / this.lakeInterval, (float)y / this.lakeInterval);
        float results = 1.0f - (float)((lakeResults[1] - lakeResults[0]) / lakeResults[1]);
        if ((double)results > 1.01) {
            throw new RuntimeException("" + lakeResults[0] + " , " + lakeResults[1]);
        }
        if ((double)results < -0.01) {
            throw new RuntimeException("" + lakeResults[0] + " , " + lakeResults[1]);
        }
        return Math.min(baseLakes, results);
    }
}

