/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.biome.realistic;

import cpw.mods.fml.common.eventhandler.Event;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.feature.WorldGenDungeons;
import net.minecraft.world.gen.feature.WorldGenLakes;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.OreGenEvent;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import rtg.api.biome.BiomeConfig;
import rtg.config.rtg.ConfigRTG;
import rtg.util.CellNoise;
import rtg.util.OpenSimplexNoise;
import rtg.util.PlaneLocation;
import rtg.util.RandomUtil;
import rtg.util.SimplexOctave;
import rtg.world.biome.BiomeBase;
import rtg.world.biome.RTGBiomeProvider;
import rtg.world.biome.WorldChunkManagerRTG;
import rtg.world.biome.deco.DecoBase;
import rtg.world.biome.deco.DecoBaseBiomeDecorations;
import rtg.world.biome.deco.collection.DecoCollectionBase;
import rtg.world.biome.realistic.vanilla.RealisticBiomeVanillaRedwoodTaigaHills;
import rtg.world.gen.feature.WorldGenClay;
import rtg.world.gen.feature.WorldGenPond;
import rtg.world.gen.feature.WorldGenVolcano;
import rtg.world.gen.surface.SurfaceBase;
import rtg.world.gen.surface.SurfaceGeneric;
import rtg.world.gen.terrain.TerrainBase;

public class RealisticBiomeBase
extends BiomeBase {
    private static final RealisticBiomeBase[] arrRealisticBiomeIds = new RealisticBiomeBase[BiomeGenBase.func_150565_n().length];
    public final BiomeGenBase baseBiome;
    public final BiomeGenBase riverBiome;
    public BiomeConfig config;
    public TerrainBase terrain;
    public SurfaceBase[] surfaces;
    public int surfacesLength;
    public SurfaceBase surfaceGeneric;
    public int waterSurfaceLakeChance;
    public int lavaSurfaceLakeChance;
    public int waterUndergroundLakeChance;
    public int lavaUndergroundLakeChance;
    public int clayPerVein;
    public boolean generateVillages;
    public boolean generatesEmeralds;
    public Block emeraldEmeraldBlock;
    public byte emeraldEmeraldMeta;
    public Block emeraldStoneBlock;
    public byte emeraldStoneMeta;
    public ArrayList<DecoBase> decos;
    private float lakeInterval = 989.0f;
    private float lakeShoreLevel = 0.15f;
    private float lakeWaterLevel = 0.11f;
    private float lakeDepressionLevel = 0.3f;
    public boolean noLakes = false;
    public boolean noWaterFeatures = false;
    private float largeBendSize = 100.0f;
    private float mediumBendSize = 40.0f;
    private float smallBendSize = 15.0f;
    public boolean disallowStoneBeaches = false;
    public boolean disallowAllBeaches = false;
    public static final float actualRiverProportion = 0.1875f;
    public static ArrayList<ChunkDecoration> decoStack = new ArrayList();

    public RealisticBiomeBase(BiomeConfig config, BiomeGenBase biome) {
        this(config, biome, BiomeGenBase.field_76781_i);
    }

    public RealisticBiomeBase(BiomeConfig config, BiomeGenBase biome, BiomeGenBase river) {
        super(biome.field_76756_M);
        this.config = config;
        if (biome.field_76756_M == 160 && this instanceof RealisticBiomeVanillaRedwoodTaigaHills) {
            RealisticBiomeBase.arrRealisticBiomeIds[161] = this;
            this.field_76791_y = "Redwood Taiga Hills";
        } else {
            RealisticBiomeBase.arrRealisticBiomeIds[biome.field_76756_M] = this;
        }
        this.baseBiome = biome;
        this.riverBiome = river;
        this.waterSurfaceLakeChance = 10;
        this.lavaSurfaceLakeChance = 0;
        this.waterUndergroundLakeChance = 1;
        this.lavaUndergroundLakeChance = 1;
        this.clayPerVein = 20;
        this.generateVillages = true;
        this.generatesEmeralds = false;
        this.emeraldEmeraldBlock = Blocks.field_150412_bA;
        this.emeraldEmeraldMeta = 0;
        this.emeraldStoneBlock = Blocks.field_150348_b;
        this.emeraldStoneMeta = 0;
        this.decos = new ArrayList();
        DecoBaseBiomeDecorations decoBaseBiomeDecorations = new DecoBaseBiomeDecorations();
        decoBaseBiomeDecorations.allowed = false;
        this.addDeco(decoBaseBiomeDecorations);
        this.lakeInterval *= ConfigRTG.lakeFrequencyMultiplier;
        this.lakeWaterLevel *= ConfigRTG.lakeSizeMultiplier();
        this.lakeShoreLevel *= ConfigRTG.lakeSizeMultiplier();
        this.lakeDepressionLevel *= ConfigRTG.lakeSizeMultiplier();
        this.largeBendSize *= ConfigRTG.lakeFrequencyMultiplier;
        this.mediumBendSize *= ConfigRTG.lakeFrequencyMultiplier;
        this.smallBendSize *= ConfigRTG.lakeFrequencyMultiplier;
    }

    public static RealisticBiomeBase getBiome(int id) {
        return arrRealisticBiomeIds[id];
    }

    public RealisticBiomeBase(BiomeConfig config, BiomeGenBase b, BiomeGenBase riverbiome, TerrainBase t, SurfaceBase[] s) {
        this(config, b, riverbiome);
        this.terrain = t;
        this.surfaces = s;
        this.surfacesLength = s.length;
    }

    public RealisticBiomeBase(BiomeConfig config, BiomeGenBase b, BiomeGenBase riverbiome, TerrainBase t, SurfaceBase s) {
        this(config, b, riverbiome, t, new SurfaceBase[]{s});
        this.surfaceGeneric = new SurfaceGeneric(config, s.getTopBlock(), s.getFillerBlock());
    }

    public void rPopulatePreDecorate(IChunkProvider ichunkprovider, World worldObj, Random rand, int chunkX, int chunkZ, boolean villageBuilding) {
        int l4;
        int i8;
        int i82;
        int l42;
        int i2;
        int worldX = chunkX * 16;
        int worldZ = chunkZ * 16;
        boolean gen = true;
        gen = TerrainGen.populate((IChunkProvider)ichunkprovider, (World)worldObj, (Random)rand, (int)chunkX, (int)chunkZ, (boolean)villageBuilding, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.LAKE);
        if (ConfigRTG.enableWaterUndergroundLakes && gen && this.waterUndergroundLakeChance > 0) {
            i2 = worldX + rand.nextInt(16);
            l42 = RandomUtil.getRandomInt(rand, 1, 50);
            i82 = worldZ + rand.nextInt(16);
            if (rand.nextInt(this.waterUndergroundLakeChance) == 0 && RandomUtil.getRandomInt(rand, 1, ConfigRTG.waterUndergroundLakeChance) == 1) {
                new WorldGenLakes(Blocks.field_150355_j).func_76484_a(worldObj, rand, i2, l42, i82);
            }
        }
        if (ConfigRTG.enableWaterSurfaceLakes && !villageBuilding && gen && this.waterSurfaceLakeChance > 0) {
            i2 = worldX + rand.nextInt(16);
            i8 = worldZ + rand.nextInt(16);
            l4 = worldObj.func_72976_f(i2, i8);
            if (rand.nextInt(this.waterSurfaceLakeChance) == 0 && RandomUtil.getRandomInt(rand, 1, ConfigRTG.waterSurfaceLakeChance) == 1 && l4 > 63) {
                new WorldGenPond(Blocks.field_150355_j).func_76484_a(worldObj, rand, i2, l4, i8);
            }
        }
        gen = TerrainGen.populate((IChunkProvider)ichunkprovider, (World)worldObj, (Random)rand, (int)chunkX, (int)chunkZ, (boolean)villageBuilding, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.LAVA);
        if (ConfigRTG.enableLavaUndergroundLakes && gen && this.lavaUndergroundLakeChance > 0) {
            i2 = worldX + rand.nextInt(16);
            l42 = RandomUtil.getRandomInt(rand, 1, 50);
            i82 = worldZ + rand.nextInt(16);
            if (rand.nextInt(this.lavaUndergroundLakeChance) == 0 && RandomUtil.getRandomInt(rand, 1, ConfigRTG.lavaUndergroundLakeChance) == 1) {
                new WorldGenLakes(Blocks.field_150353_l).func_76484_a(worldObj, rand, i2, l42, i82);
            }
        }
        if (ConfigRTG.enableLavaSurfaceLakes && !villageBuilding && gen && this.lavaSurfaceLakeChance > 0) {
            i2 = worldX + rand.nextInt(16);
            i8 = worldZ + rand.nextInt(16);
            l4 = worldObj.func_72976_f(i2, i8);
            if (rand.nextInt(this.lavaSurfaceLakeChance) == 0 && RandomUtil.getRandomInt(rand, 1, ConfigRTG.lavaSurfaceLakeChance) == 1 && l4 > 63) {
                new WorldGenPond(Blocks.field_150353_l).func_76484_a(worldObj, rand, i2, l4, i8);
            }
        }
        if (ConfigRTG.generateDungeons && (gen = TerrainGen.populate((IChunkProvider)ichunkprovider, (World)worldObj, (Random)rand, (int)chunkX, (int)chunkZ, (boolean)villageBuilding, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.DUNGEON))) {
            for (int k1 = 0; k1 < ConfigRTG.dungeonFrequency; ++k1) {
                int j5 = worldX + rand.nextInt(16);
                int k8 = rand.nextInt(128);
                int j11 = worldZ + rand.nextInt(16);
                new WorldGenDungeons().func_76484_a(worldObj, rand, j5, k8, j11);
            }
        }
    }

    public void rPopulatePostDecorate(IChunkProvider ichunkprovider, World worldObj, Random rand, int chunkX, int chunkZ, boolean flag) {
        if (!ConfigRTG.generateOreEmerald && this.generatesEmeralds) {
            this.rRemoveEmeralds(worldObj, rand, chunkX, chunkZ);
        }
    }

    public void rDecorateSeedBiome(World world, Random rand, int chunkX, int chunkY, OpenSimplexNoise simplex, CellNoise cell, float strength, float river, BiomeGenBase seedBiome) {
        if (strength > 0.3f) {
            seedBiome.func_76728_a(world, rand, chunkX, chunkY);
        } else {
            this.rOreGenSeedBiome(world, rand, chunkX, chunkY, simplex, cell, strength, river, seedBiome);
        }
    }

    public void rOreGenSeedBiome(World world, Random rand, int chunkX, int chunkY, OpenSimplexNoise simplex, CellNoise cell, float strength, float river, BiomeGenBase seedBiome) {
        MinecraftForge.ORE_GEN_BUS.post((Event)new OreGenEvent.Pre(world, rand, chunkX, chunkY));
        if (TerrainGen.generateOre((World)world, (Random)rand, (WorldGenerator)seedBiome.field_76760_I.field_76823_i, (int)chunkX, (int)chunkY, (OreGenEvent.GenerateMinable.EventType)OreGenEvent.GenerateMinable.EventType.DIRT)) {
            this.genStandardOre1(20, seedBiome.field_76760_I.field_76823_i, 0, 256, world, rand, chunkX, chunkY);
        }
        if (TerrainGen.generateOre((World)world, (Random)rand, (WorldGenerator)seedBiome.field_76760_I.field_76820_j, (int)chunkX, (int)chunkY, (OreGenEvent.GenerateMinable.EventType)OreGenEvent.GenerateMinable.EventType.GRAVEL)) {
            this.genStandardOre1(10, seedBiome.field_76760_I.field_76820_j, 0, 256, world, rand, chunkX, chunkY);
        }
        if (TerrainGen.generateOre((World)world, (Random)rand, (WorldGenerator)seedBiome.field_76760_I.field_76821_k, (int)chunkX, (int)chunkY, (OreGenEvent.GenerateMinable.EventType)OreGenEvent.GenerateMinable.EventType.COAL)) {
            this.genStandardOre1(20, seedBiome.field_76760_I.field_76821_k, 0, 128, world, rand, chunkX, chunkY);
        }
        if (TerrainGen.generateOre((World)world, (Random)rand, (WorldGenerator)seedBiome.field_76760_I.field_76818_l, (int)chunkX, (int)chunkY, (OreGenEvent.GenerateMinable.EventType)OreGenEvent.GenerateMinable.EventType.IRON)) {
            this.genStandardOre1(20, seedBiome.field_76760_I.field_76818_l, 0, 64, world, rand, chunkX, chunkY);
        }
        if (TerrainGen.generateOre((World)world, (Random)rand, (WorldGenerator)seedBiome.field_76760_I.field_76819_m, (int)chunkX, (int)chunkY, (OreGenEvent.GenerateMinable.EventType)OreGenEvent.GenerateMinable.EventType.GOLD)) {
            this.genStandardOre1(2, seedBiome.field_76760_I.field_76819_m, 0, 32, world, rand, chunkX, chunkY);
        }
        if (TerrainGen.generateOre((World)world, (Random)rand, (WorldGenerator)seedBiome.field_76760_I.field_76816_n, (int)chunkX, (int)chunkY, (OreGenEvent.GenerateMinable.EventType)OreGenEvent.GenerateMinable.EventType.REDSTONE)) {
            this.genStandardOre1(8, seedBiome.field_76760_I.field_76816_n, 0, 16, world, rand, chunkX, chunkY);
        }
        if (TerrainGen.generateOre((World)world, (Random)rand, (WorldGenerator)seedBiome.field_76760_I.field_76817_o, (int)chunkX, (int)chunkY, (OreGenEvent.GenerateMinable.EventType)OreGenEvent.GenerateMinable.EventType.DIAMOND)) {
            this.genStandardOre1(1, seedBiome.field_76760_I.field_76817_o, 0, 16, world, rand, chunkX, chunkY);
        }
        if (TerrainGen.generateOre((World)world, (Random)rand, (WorldGenerator)seedBiome.field_76760_I.field_76831_p, (int)chunkX, (int)chunkY, (OreGenEvent.GenerateMinable.EventType)OreGenEvent.GenerateMinable.EventType.LAPIS)) {
            this.genStandardOre2(1, seedBiome.field_76760_I.field_76831_p, 16, 16, world, rand, chunkX, chunkY);
        }
        if (ConfigRTG.generateOreEmerald && this.generatesEmeralds) {
            this.rGenerateEmeralds(world, rand, chunkX, chunkY);
        }
        MinecraftForge.ORE_GEN_BUS.post((Event)new OreGenEvent.Post(world, rand, chunkX, chunkY));
    }

    public void rMapVolcanoes(Block[] blocks, byte[] metadata, World world, RTGBiomeProvider cmr, Random mapRand, int baseX, int baseY, int chunkX, int chunkY, OpenSimplexNoise simplex, CellNoise cell, float[] noise) {
        float river;
        int chance;
        boolean allowed;
        RealisticBiomeBase neighbourBiome = RealisticBiomeBase.getBiome(((WorldChunkManagerRTG)cmr).func_76935_a((int)(baseX * 16), (int)(baseY * 16)).field_76756_M);
        boolean bl = allowed = !ConfigRTG.enableVolcanoes ? false : neighbourBiome.config._boolean("allowVolcanoes");
        if (!allowed) {
            return;
        }
        int n = chance = neighbourBiome.config._int("volcanoChance") == -1 ? ConfigRTG.volcanoChance : neighbourBiome.config._int("volcanoChance");
        if (chance < 1) {
            return;
        }
        if (baseX % 4 == 0 && baseY % 4 == 0 && mapRand.nextInt(chance) == 0 && (river = cmr.getRiverStrength(baseX * 16, baseY * 16) + 1.0f) > 0.98f && cmr.isBorderlessAt(baseX * 16, baseY * 16)) {
            long i1 = mapRand.nextLong() / 2L * 2L + 1L;
            long j1 = mapRand.nextLong() / 2L * 2L + 1L;
            mapRand.setSeed((long)chunkX * i1 + (long)chunkY * j1 ^ world.func_72905_C());
            WorldGenVolcano.build(blocks, metadata, world, mapRand, baseX, baseY, chunkX, chunkY, simplex, cell, noise);
        }
    }

    public void generateMapGen(Block[] blocks, byte[] metadata, Long seed, World world, RTGBiomeProvider cmr, Random mapRand, int chunkX, int chunkY, OpenSimplexNoise simplex, CellNoise cell, float[] noise) {
        int baseY;
        int baseX;
        int mapGenRadius = 5;
        int volcanoGenRadius = 15;
        mapRand.setSeed(seed);
        long l = mapRand.nextLong() / 2L * 2L + 1L;
        long l1 = mapRand.nextLong() / 2L * 2L + 1L;
        for (baseX = chunkX - 5; baseX <= chunkX + 5; ++baseX) {
            for (baseY = chunkY - 5; baseY <= chunkY + 5; ++baseY) {
                mapRand.setSeed((long)baseX * l + (long)baseY * l1 ^ seed);
                this.rMapGen(blocks, metadata, world, cmr, mapRand, baseX, baseY, chunkX, chunkY, simplex, cell, noise);
            }
        }
        for (baseX = chunkX - 15; baseX <= chunkX + 15; ++baseX) {
            for (baseY = chunkY - 15; baseY <= chunkY + 15; ++baseY) {
                mapRand.setSeed((long)baseX * l + (long)baseY * l1 ^ seed);
                this.rMapVolcanoes(blocks, metadata, world, cmr, mapRand, baseX, baseY, chunkX, chunkY, simplex, cell, noise);
            }
        }
    }

    public void rMapGen(Block[] blocks, byte[] metadata, World world, RTGBiomeProvider cmr, Random mapRand, int chunkX, int chunkY, int baseX, int baseY, OpenSimplexNoise simplex, CellNoise cell, float[] noise) {
    }

    public float rNoise(OpenSimplexNoise simplex, CellNoise cell, int x, int y, float border, float river) {
        if (this.noWaterFeatures) {
            float borderForRiver = border * 2.0f;
            if (borderForRiver > 1.0f) {
                borderForRiver = 1.0f;
            }
            river = 1.0f - (1.0f - borderForRiver) * (1.0f - river);
            return this.terrain.generateNoise(simplex, cell, x, y, border, river);
        }
        float lakeStrength = this.lakePressure(simplex, cell, x, y, border);
        float lakeFlattening = this.lakeFlattening(lakeStrength, this.lakeShoreLevel, this.lakeDepressionLevel);
        float riverFlattening = river * 1.25f - 0.25f;
        if (riverFlattening < 0.0f) {
            riverFlattening = 0.0f;
        }
        if (river < 1.0f && lakeFlattening < 1.0f) {
            riverFlattening = (1.0f - riverFlattening) / riverFlattening + (1.0f - lakeFlattening) / lakeFlattening;
            riverFlattening = 1.0f / (riverFlattening + 1.0f);
        } else if (lakeFlattening < riverFlattening) {
            riverFlattening = lakeFlattening;
        }
        lakeFlattening = this.lakeFlattening(lakeStrength, this.lakeWaterLevel, this.lakeDepressionLevel);
        if (river < 1.0f && lakeFlattening < 1.0f) {
            river = (1.0f - river) / river + (1.0f - lakeFlattening) / lakeFlattening;
            river = 1.0f / (river + 1.0f);
        } else if (lakeFlattening < river) {
            river = lakeFlattening;
        }
        float terrainNoise = this.terrain.generateNoise(simplex, cell, x, y, border, riverFlattening);
        return this.erodedNoise(simplex, cell, x, y, river, border, terrainNoise, lakeFlattening);
    }

    public float erodedNoise(OpenSimplexNoise simplex, CellNoise simplexCell, int x, int y, float river, float border, float biomeHeight, double lakeFlattening) {
        float r = 1.0f;
        float riverFlattening = river;
        if (riverFlattening < 0.0f) {
            riverFlattening = 0.0f;
        }
        if ((r = riverFlattening / 0.1875f) < 1.0f && biomeHeight > 57.0f) {
            return biomeHeight * r + (57.0f + simplex.noise2((float)x / 12.0f, (float)y / 12.0f) * 2.0f + simplex.noise2((float)x / 8.0f, (float)y / 8.0f) * 1.5f) * (1.0f - r);
        }
        return biomeHeight;
    }

    public float lakeFlattening(OpenSimplexNoise simplex, CellNoise simplexCell, int x, int y, float border) {
        return this.lakeFlattening(this.lakePressure(simplex, simplexCell, x, y, border), this.lakeWaterLevel, this.lakeDepressionLevel);
    }

    public float lakePressure(OpenSimplexNoise simplex, CellNoise simplexCell, int x, int y, float border) {
        if (this.noLakes) {
            return 1.0f;
        }
        SimplexOctave.Disk jitter = new SimplexOctave.Disk();
        simplex.riverJitter().evaluateNoise((double)x / 240.0, (double)y / 240.0, jitter);
        double pX = (double)x + jitter.deltax() * (double)this.largeBendSize;
        double pY = (double)y + jitter.deltay() * (double)this.largeBendSize;
        simplex.mountain().evaluateNoise((double)x / 80.0, (double)y / 80.0, jitter);
        pX += jitter.deltax() * (double)this.mediumBendSize;
        pY += jitter.deltay() * (double)this.mediumBendSize;
        simplex.octave(4).evaluateNoise((double)x / 30.0, (double)y / 30.0, jitter);
        double[] lakeResults = simplexCell.river().eval((float)(pX += jitter.deltax() * (double)this.smallBendSize) / this.lakeInterval, (float)(pY += jitter.deltay() * (double)this.smallBendSize) / this.lakeInterval);
        float results = 1.0f - (float)((lakeResults[1] - lakeResults[0]) / lakeResults[1]);
        if ((double)results > 1.01) {
            throw new RuntimeException("" + lakeResults[0] + " , " + lakeResults[1]);
        }
        if ((double)results < -0.01) {
            throw new RuntimeException("" + lakeResults[0] + " , " + lakeResults[1]);
        }
        return results;
    }

    public float lakeFlattening(float pressure, float bottomLevel, float topLevel) {
        if (pressure > topLevel) {
            return 1.0f;
        }
        if (pressure < bottomLevel) {
            return 0.0f;
        }
        return (float)Math.pow((pressure - bottomLevel) / (topLevel - bottomLevel), 1.0);
    }

    public void rReplace(Block[] blocks, byte[] metadata, int i, int j, int x, int y, int depth, World world, Random rand, OpenSimplexNoise simplex, CellNoise cell, float[] noise, float river, BiomeGenBase[] base) {
        float riverRegion;
        float f = riverRegion = this.noWaterFeatures ? 0.0f : river;
        if (ConfigRTG.enableRTGBiomeSurfaces && this.config.getPropertyById((String)"useRTGSurfaces").valueBoolean) {
            for (int s = 0; s < this.surfacesLength; ++s) {
                this.surfaces[s].paintTerrain(blocks, metadata, i, j, x, y, depth, world, rand, simplex, cell, noise, riverRegion, base);
            }
        } else {
            this.surfaceGeneric.paintTerrain(blocks, metadata, i, j, x, y, depth, world, rand, simplex, cell, noise, riverRegion, base);
        }
    }

    public float r3Dnoise(float z) {
        return 0.0f;
    }

    public void rDecorateClay(World worldObj, Random rand, int chunkX, int chunkZ, float river, int worldX, int worldZ) {
        if (TerrainGen.decorate((World)worldObj, (Random)rand, (int)chunkX, (int)chunkZ, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.CLAY) && river > 0.85f) {
            for (int j2 = 0; j2 < 3; ++j2) {
                int l5 = worldX + rand.nextInt(16);
                int i9 = 53 + rand.nextInt(15);
                int l11 = worldZ + rand.nextInt(16);
                new WorldGenClay(Blocks.field_150435_aG, 0, this.clayPerVein).func_76484_a(worldObj, rand, l5, i9, l11);
            }
        }
    }

    protected void genStandardOre1(int numBlocks, WorldGenerator oreGen, int minY, int maxY, World worldObj, Random rand, int chunkX, int chunkZ) {
        for (int l = 0; l < numBlocks; ++l) {
            int i1 = chunkX + rand.nextInt(16);
            int j1 = rand.nextInt(maxY - minY) + minY;
            int k1 = chunkZ + rand.nextInt(16);
            oreGen.func_76484_a(worldObj, rand, i1, j1, k1);
        }
    }

    protected void genStandardOre2(int numBlocks, WorldGenerator oreGen, int minY, int maxY, World worldObj, Random rand, int chunkX, int chunkZ) {
        for (int l = 0; l < numBlocks; ++l) {
            int i1 = chunkX + rand.nextInt(16);
            int j1 = rand.nextInt(maxY) + rand.nextInt(maxY) + (minY - maxY);
            int k1 = chunkZ + rand.nextInt(16);
            oreGen.func_76484_a(worldObj, rand, i1, j1, k1);
        }
    }

    public void rGenerateEmeralds(World world, Random rand, int chunkX, int chunkZ) {
        int k = 3 + rand.nextInt(6);
        for (int l = 0; l < k; ++l) {
            int k1;
            int j1;
            int i1 = chunkX + rand.nextInt(16);
            if (!world.func_147439_a(i1, j1 = rand.nextInt(28) + 4, k1 = chunkZ + rand.nextInt(16)).isReplaceableOreGen(world, i1, j1, k1, this.emeraldStoneBlock)) continue;
            world.func_147465_d(i1, j1, k1, this.emeraldEmeraldBlock, (int)this.emeraldEmeraldMeta, 2);
        }
    }

    public void rRemoveEmeralds(World world, Random rand, int chunkX, int chunkZ) {
        int endX = chunkX * 16 + 16;
        int endZ = chunkZ * 16 + 16;
        int maxY = world.func_72976_f(chunkX, chunkZ);
        for (int x = chunkX * 16; x < endX; ++x) {
            for (int z = chunkZ * 16; z < endZ; ++z) {
                for (int y = 0; y < maxY; ++y) {
                    if (!world.func_147439_a(x, y, z).isReplaceableOreGen(world, x, y, z, this.emeraldEmeraldBlock)) continue;
                    world.func_147465_d(x, y, z, this.emeraldStoneBlock, (int)this.emeraldStoneMeta, 2);
                }
            }
        }
    }

    public TerrainBase getTerrain() {
        return this.terrain;
    }

    public SurfaceBase getSurface() {
        if (this.surfacesLength == 0) {
            throw new RuntimeException("No realistic surfaces found for " + this.baseBiome.field_76791_y + " (" + this.baseBiome.field_76756_M + ").");
        }
        return this.surfaces[0];
    }

    public SurfaceBase[] getSurfaces() {
        return this.surfaces;
    }

    public void decorateInAnOrderlyFashion(World world, Random rand, int worldX, int worldY, OpenSimplexNoise simplex, CellNoise cell, float strength, float river) {
        for (int i = 0; i < this.decos.size(); ++i) {
            decoStack.add(new ChunkDecoration(new PlaneLocation.Invariant(worldX, worldY), this.decos.get(i)));
            if (decoStack.size() > 20) {
                String problem = "";
                for (ChunkDecoration inStack : decoStack) {
                    problem = problem + "" + inStack.chunkLocation.toString() + " " + inStack.decoration.getClass().getSimpleName();
                }
                throw new RuntimeException(problem);
            }
            if (this.decos.get(i).preGenerate(this, world, rand, worldX, worldY, simplex, cell, strength, river)) {
                this.decos.get(i).generate(this, world, rand, worldX, worldY, simplex, cell, strength, river);
            }
            decoStack.remove(decoStack.size() - 1);
        }
    }

    public void addDeco(DecoBase deco, boolean allowed) {
        if (allowed) {
            if (!deco.properlyDefined()) {
                throw new RuntimeException(deco.toString());
            }
            if (deco instanceof DecoBaseBiomeDecorations) {
                for (int i = 0; i < this.decos.size(); ++i) {
                    if (!(this.decos.get(i) instanceof DecoBaseBiomeDecorations)) continue;
                    this.decos.remove(i);
                    break;
                }
            }
            this.decos.add(deco);
        }
    }

    public void addDeco(DecoBase deco) {
        if (!deco.properlyDefined()) {
            throw new RuntimeException(deco.toString());
        }
        this.addDeco(deco, true);
    }

    public void addDecoCollection(DecoCollectionBase decoCollection) {
        if (decoCollection.decos.size() > 0) {
            for (int i = 0; i < decoCollection.decos.size(); ++i) {
                this.addDeco(decoCollection.decos.get(i));
            }
        }
    }

    private class ChunkDecoration {
        PlaneLocation chunkLocation;
        DecoBase decoration;

        ChunkDecoration(PlaneLocation chunkLocation, DecoBase decoration) {
            this.chunkLocation = chunkLocation;
            this.decoration = decoration;
        }
    }
}

