/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.biome.deco.collection;

import net.minecraft.init.Blocks;
import net.minecraft.world.gen.feature.WorldGenerator;
import rtg.world.biome.deco.DecoBase;
import rtg.world.biome.deco.DecoFallenTree;
import rtg.world.biome.deco.DecoFlowersRTG;
import rtg.world.biome.deco.DecoGrass;
import rtg.world.biome.deco.DecoShrub;
import rtg.world.biome.deco.DecoTree;
import rtg.world.biome.deco.collection.DecoCollectionBase;
import rtg.world.biome.deco.helper.DecoHelper5050;
import rtg.world.biome.deco.helper.DecoHelperRandomSplit;
import rtg.world.gen.feature.tree.rtg.TreeRTGPiceaSitchensis;
import rtg.world.gen.feature.tree.rtg.TreeRTGPinusPonderosa;
import rtg.world.gen.feature.tree.vanilla.WorldGenForestRTG;
import rtg.world.gen.feature.tree.vanilla.WorldGenTreesRTG;

public class DecoCollectionForest
extends DecoCollectionBase {
    public DecoCollectionForest(boolean fallenTrees) {
        DecoTree oakPines = new DecoTree(new TreeRTGPinusPonderosa());
        oakPines.logBlock = Blocks.field_150364_r;
        oakPines.logMeta = 0;
        oakPines.leavesBlock = Blocks.field_150362_t;
        oakPines.leavesMeta = 0;
        oakPines.minTrunkSize = 11;
        oakPines.maxTrunkSize = 21;
        oakPines.minCrownSize = 15;
        oakPines.maxCrownSize = 29;
        oakPines.strengthFactorForLoops = 8.0f;
        oakPines.treeType = DecoTree.TreeType.RTG_TREE;
        oakPines.distribution.noiseDivisor = 100.0f;
        oakPines.distribution.noiseFactor = 6.0f;
        oakPines.distribution.noiseAddend = 0.8f;
        oakPines.treeCondition = DecoTree.TreeCondition.NOISE_GREATER_AND_RANDOM_CHANCE;
        oakPines.treeConditionNoise = 0.0f;
        oakPines.treeConditionChance = 1;
        oakPines.maxY = 85;
        DecoTree sprucePines = new DecoTree(oakPines);
        sprucePines.logMeta = 1;
        sprucePines.leavesMeta = 1;
        DecoHelper5050 decoPines = new DecoHelper5050(oakPines, sprucePines);
        this.addDeco(decoPines);
        DecoTree oakPine = new DecoTree(new TreeRTGPiceaSitchensis());
        oakPine.logBlock = Blocks.field_150364_r;
        oakPine.logMeta = 0;
        oakPine.leavesBlock = Blocks.field_150362_t;
        oakPine.leavesMeta = 0;
        oakPine.minTrunkSize = 4;
        oakPine.maxTrunkSize = 10;
        oakPine.minCrownSize = 6;
        oakPine.maxCrownSize = 14;
        oakPine.strengthFactorForLoops = 3.0f;
        oakPine.treeType = DecoTree.TreeType.RTG_TREE;
        oakPine.treeCondition = DecoTree.TreeCondition.RANDOM_CHANCE;
        oakPine.treeConditionChance = 4;
        oakPine.maxY = 100;
        WorldGenTreesRTG vanillaTreeDefinition = new WorldGenTreesRTG();
        DecoTree vanillaTrees = new DecoTree((WorldGenerator)vanillaTreeDefinition);
        vanillaTrees.strengthFactorForLoops = 3.0f;
        vanillaTrees.treeType = DecoTree.TreeType.WORLDGEN;
        vanillaTrees.treeCondition = DecoTree.TreeCondition.RANDOM_CHANCE;
        vanillaTrees.treeConditionChance = 4;
        vanillaTrees.maxY = 120;
        WorldGenForestRTG vanillaForestDefinition = new WorldGenForestRTG();
        DecoTree vanillaForest = new DecoTree((WorldGenerator)vanillaForestDefinition);
        vanillaForest.strengthFactorForLoops = 3.0f;
        vanillaForest.treeType = DecoTree.TreeType.WORLDGEN;
        vanillaForest.treeCondition = DecoTree.TreeCondition.RANDOM_CHANCE;
        vanillaForest.treeConditionChance = 4;
        vanillaForest.maxY = 120;
        DecoHelperRandomSplit decoHelperRandomSplit = new DecoHelperRandomSplit();
        decoHelperRandomSplit.decos = new DecoBase[]{oakPine, vanillaTrees, vanillaForest};
        decoHelperRandomSplit.chances = new int[]{8, 4, 1};
        this.addDeco(decoHelperRandomSplit);
        DecoFallenTree decoFallenOak = new DecoFallenTree();
        decoFallenOak.logCondition = DecoFallenTree.LogCondition.RANDOM_CHANCE;
        decoFallenOak.logConditionChance = 16;
        decoFallenOak.maxY = 80;
        decoFallenOak.logBlock = Blocks.field_150364_r;
        decoFallenOak.logMeta = 0;
        decoFallenOak.leavesBlock = Blocks.field_150362_t;
        decoFallenOak.leavesMeta = (byte)-1;
        decoFallenOak.minSize = 3;
        decoFallenOak.maxSize = 6;
        DecoFallenTree decoFallenSpruce = new DecoFallenTree();
        decoFallenSpruce.logCondition = DecoFallenTree.LogCondition.RANDOM_CHANCE;
        decoFallenSpruce.logConditionChance = 24;
        decoFallenSpruce.maxY = 80;
        decoFallenSpruce.logBlock = Blocks.field_150364_r;
        decoFallenSpruce.logMeta = 1;
        decoFallenSpruce.leavesBlock = Blocks.field_150362_t;
        decoFallenSpruce.leavesMeta = (byte)-1;
        decoFallenSpruce.minSize = 3;
        decoFallenSpruce.maxSize = 6;
        DecoHelper5050 decoFallenTree = new DecoHelper5050(decoFallenOak, decoFallenSpruce);
        this.addDeco(decoFallenTree, fallenTrees);
        DecoShrub decoShrubOak = new DecoShrub();
        decoShrubOak.maxY = 140;
        decoShrubOak.strengthFactor = 4.0f;
        decoShrubOak.chance = 3;
        this.addDeco(decoShrubOak);
        DecoShrub decoShrubSpruce = new DecoShrub();
        decoShrubSpruce.logBlock = Blocks.field_150364_r;
        decoShrubSpruce.logMeta = 1;
        decoShrubSpruce.leavesBlock = Blocks.field_150362_t;
        decoShrubSpruce.leavesMeta = 1;
        decoShrubSpruce.maxY = 140;
        decoShrubSpruce.strengthFactor = 4.0f;
        decoShrubSpruce.chance = 9;
        this.addDeco(decoShrubSpruce);
        DecoFlowersRTG decoFlowersRTG = new DecoFlowersRTG();
        decoFlowersRTG.flowers = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
        decoFlowersRTG.maxY = 128;
        decoFlowersRTG.strengthFactor = 6.0f;
        this.addDeco(decoFlowersRTG);
        DecoGrass decoGrass = new DecoGrass();
        decoGrass.minY = 60;
        decoGrass.maxY = 128;
        decoGrass.loops = 8;
        this.addDeco(decoGrass);
    }
}

