/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.biome.deco;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import rtg.util.CellNoise;
import rtg.util.OpenSimplexNoise;
import rtg.util.RandomUtil;
import rtg.world.biome.deco.DecoBase;
import rtg.world.biome.realistic.RealisticBiomeBase;
import rtg.world.gen.feature.tree.rtg.TreeRTG;

public class DecoTree
extends DecoBase {
    public int loops = 1;
    public float strengthFactorForLoops = 0.0f;
    public boolean strengthNoiseFactorForLoops = false;
    public boolean strengthNoiseFactorXForLoops = false;
    public TreeType treeType = TreeType.RTG_TREE;
    public TreeRTG tree = null;
    public WorldGenerator worldGen = null;
    public Distribution distribution = new Distribution(100.0f, 5.0f, 0.8f);
    public TreeCondition treeCondition = TreeCondition.NOISE_GREATER_AND_RANDOM_CHANCE;
    public float treeConditionNoise = 0.0f;
    public int treeConditionChance = 1;
    public float treeConditionFloat = 0.0f;
    public int minY = 62;
    public int maxY = 230;
    public Block logBlock = Blocks.field_150364_r;
    public byte logMeta = 0;
    public Block leavesBlock = Blocks.field_150362_t;
    public byte leavesMeta = (byte)-1;
    public int minSize = 2;
    public int maxSize = 4;
    public int minTrunkSize = 2;
    public int maxTrunkSize = 4;
    public int minCrownSize = 2;
    public int maxCrownSize = 4;
    public boolean noLeaves = false;

    public DecoTree() {
        this.addDecoTypes(DecoBase.DecoType.TREE);
    }

    public DecoTree(DecoTree source) {
        this();
        this.loops = source.loops;
        this.strengthFactorForLoops = source.strengthFactorForLoops;
        this.strengthNoiseFactorForLoops = source.strengthNoiseFactorForLoops;
        this.strengthNoiseFactorXForLoops = source.strengthNoiseFactorXForLoops;
        this.treeType = source.treeType;
        this.tree = source.tree;
        this.distribution = source.distribution;
        this.treeCondition = source.treeCondition;
        this.treeConditionNoise = source.treeConditionNoise;
        this.treeConditionChance = source.treeConditionChance;
        this.minY = source.minY;
        this.maxY = source.maxY;
        this.logBlock = source.logBlock;
        this.logMeta = source.logMeta;
        this.leavesBlock = source.leavesBlock;
        this.leavesMeta = source.leavesMeta;
        this.minSize = source.minSize;
        this.maxSize = source.maxSize;
        this.minTrunkSize = source.minTrunkSize;
        this.maxTrunkSize = source.maxTrunkSize;
        this.minCrownSize = source.minCrownSize;
        this.maxCrownSize = source.maxCrownSize;
        this.noLeaves = source.noLeaves;
    }

    public DecoTree(TreeRTG tree) {
        this();
        this.tree = tree;
        this.logBlock = tree.logBlock;
        this.logMeta = tree.logMeta;
        this.leavesBlock = tree.leavesBlock;
        this.leavesMeta = tree.leavesMeta;
    }

    public DecoTree(WorldGenerator worldGen) {
        this();
        this.worldGen = worldGen;
    }

    @Override
    public boolean properlyDefined() {
        if (this.treeType == TreeType.RTG_TREE && this.tree == null) {
            return false;
        }
        return super.properlyDefined();
    }

    @Override
    public void generate(RealisticBiomeBase biome, World world, Random rand, int chunkX, int chunkY, OpenSimplexNoise simplex, CellNoise cell, float strength, float river) {
        if (this.allowed && TerrainGen.decorate((World)world, (Random)rand, (int)chunkX, (int)chunkY, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.TREE)) {
            float noise = simplex.noise2((float)chunkX / this.distribution.noiseDivisor, (float)chunkY / this.distribution.noiseDivisor) * this.distribution.noiseFactor + this.distribution.noiseAddend;
            int loopCount = this.loops;
            loopCount = this.strengthFactorForLoops > 0.0f ? (int)(this.strengthFactorForLoops * strength) : loopCount;
            loopCount = this.strengthNoiseFactorForLoops ? (int)(noise * strength) : loopCount;
            loopCount = this.strengthNoiseFactorXForLoops ? (int)(noise * this.strengthFactorForLoops * strength) : loopCount;
            block4: for (int i = 0; i < loopCount; ++i) {
                int intX = chunkX + rand.nextInt(16);
                int intZ = chunkY + rand.nextInt(16);
                int intY = world.func_72976_f(intX, intZ);
                switch (this.treeType) {
                    case RTG_TREE: {
                        if (intY > this.maxY || intY < this.minY || !this.isValidTreeCondition(noise, rand, strength)) continue block4;
                        this.tree.setLogBlock(this.logBlock);
                        this.tree.setLogMeta(this.logMeta);
                        this.tree.setLeavesBlock(this.leavesBlock);
                        this.tree.setLeavesMeta(this.leavesMeta);
                        this.tree.setTrunkSize(RandomUtil.getRandomInt(rand, this.minTrunkSize, this.maxTrunkSize));
                        this.tree.setCrownSize(RandomUtil.getRandomInt(rand, this.minCrownSize, this.maxCrownSize));
                        this.tree.setNoLeaves(this.noLeaves);
                        this.tree.func_76487_a(1.0, 1.0, 1.0);
                        this.tree.func_76484_a(world, rand, intX, intY, intZ);
                        continue block4;
                    }
                    case WORLDGEN: {
                        if (intY > this.maxY || intY < this.minY || !this.isValidTreeCondition(noise, rand, strength)) continue block4;
                        WorldGenerator worldgenerator = this.worldGen;
                        worldgenerator.func_76487_a(1.0, 1.0, 1.0);
                        worldgenerator.func_76484_a(world, rand, intX, intY, intZ);
                        continue block4;
                    }
                }
            }
        }
    }

    public boolean isValidTreeCondition(float noise, Random rand, float strength) {
        switch (this.treeCondition) {
            case ALWAYS_GENERATE: {
                return true;
            }
            case NOISE_GREATER_AND_RANDOM_CHANCE: {
                return noise > this.treeConditionNoise && rand.nextInt(this.treeConditionChance) == 0;
            }
            case RANDOM_CHANCE: {
                return rand.nextInt(this.treeConditionChance) == 0;
            }
            case X_DIVIDED_BY_STRENGTH: {
                return rand.nextInt((int)(this.treeConditionFloat / strength)) == 0;
            }
        }
        return false;
    }

    public static enum TreeCondition {
        ALWAYS_GENERATE,
        NOISE_GREATER_AND_RANDOM_CHANCE,
        RANDOM_CHANCE,
        X_DIVIDED_BY_STRENGTH;

    }

    public static enum TreeType {
        RTG_TREE,
        WORLDGEN;

    }

    public static class Distribution {
        public float noiseDivisor;
        public float noiseFactor;
        public float noiseAddend;

        public Distribution(float noiseDivisor, float noiseFactor, float noiseAddend) {
            this.noiseDivisor = noiseDivisor;
            this.noiseFactor = noiseFactor;
            this.noiseAddend = noiseAddend;
        }
    }
}

