/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.biome.deco;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import rtg.util.CellNoise;
import rtg.util.OpenSimplexNoise;
import rtg.world.biome.deco.DecoBase;
import rtg.world.biome.realistic.RealisticBiomeBase;
import rtg.world.gen.feature.WorldGenShrubRTG;

public class DecoShrub
extends DecoBase {
    public int size = -1;
    public boolean useDefaultRandom = false;
    public Block[] randomLogBlocks = new Block[]{Blocks.field_150364_r, Blocks.field_150364_r};
    public byte[] randomLogMetas = new byte[]{0, 1};
    public Block[] randomLeavesBlocks = new Block[]{Blocks.field_150362_t, Blocks.field_150362_t};
    public byte[] randomLeavesMetas = new byte[]{0, 1};
    public float strengthFactor = 3.0f;
    public int minY = 1;
    public int maxY = 255;
    public int chance = 1;
    public int notEqualsZerochance = 1;
    public int loops = 1;
    public int minSize = 3;
    public int maxSize = 4;
    public Block logBlock = Blocks.field_150364_r;
    public byte logMeta = 0;
    public Block leavesBlock = Blocks.field_150362_t;
    public byte leavesMeta = 0;

    public DecoShrub() {
        this.addDecoTypes(DecoBase.DecoType.SHRUB);
    }

    public DecoShrub(boolean useDefaultRandom) {
        this();
        this.useDefaultRandom = true;
    }

    @Override
    public void generate(RealisticBiomeBase biome, World world, Random rand, int chunkX, int chunkY, OpenSimplexNoise simplex, CellNoise cell, float strength, float river) {
        if (this.allowed) {
            int n = this.size = this.size == -1 ? rand.nextInt(4) + 1 : this.size;
            if (this.minSize > 0 && this.maxSize > 0 && this.maxSize >= this.minSize) {
                this.size = this.minSize + rand.nextInt(this.maxSize - this.minSize + 1);
            }
            if (this.useDefaultRandom && this.randomLogBlocks.length > 0 && this.randomLogBlocks.length == this.randomLogMetas.length && this.randomLogBlocks.length == this.randomLeavesBlocks.length && this.randomLogBlocks.length == this.randomLeavesMetas.length) {
                int rnd = rand.nextInt(this.randomLogBlocks.length);
                this.logBlock = this.randomLogBlocks[rnd];
                this.logMeta = this.randomLogMetas[rnd];
                this.leavesBlock = this.randomLeavesBlocks[rnd];
                this.leavesMeta = this.randomLeavesMetas[rnd];
            }
            WorldGenShrubRTG worldGenerator = new WorldGenShrubRTG(this.size, this.logBlock, this.logMeta, this.leavesBlock, this.leavesMeta);
            int loopCount = this.loops;
            loopCount = this.strengthFactor > 0.0f ? (int)(this.strengthFactor * strength) : loopCount;
            for (int i = 0; i < loopCount; ++i) {
                int intX = chunkX + rand.nextInt(16);
                int intZ = chunkY + rand.nextInt(16);
                int intY = world.func_72976_f(intX, intZ);
                if (this.notEqualsZerochance > 1) {
                    if (intY < this.minY || intY > this.maxY || rand.nextInt(this.notEqualsZerochance) == 0) continue;
                    worldGenerator.func_76484_a(world, rand, intX, intY, intZ);
                    continue;
                }
                if (intY < this.minY || intY > this.maxY || rand.nextInt(this.chance) != 0) continue;
                worldGenerator.func_76484_a(world, rand, intX, intY, intZ);
            }
        }
    }
}

