/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.biome.deco;

import java.util.Random;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenReed;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import rtg.util.CellNoise;
import rtg.util.OpenSimplexNoise;
import rtg.world.biome.deco.DecoBase;
import rtg.world.biome.realistic.RealisticBiomeBase;

public class DecoReed
extends DecoBase {
    public float strengthFactor = 0.0f;
    public int maxY = 255;
    public int loops = 1;

    public DecoReed() {
        this.addDecoTypes(DecoBase.DecoType.REED);
    }

    @Override
    public void generate(RealisticBiomeBase biome, World world, Random rand, int chunkX, int chunkY, OpenSimplexNoise simplex, CellNoise cell, float strength, float river) {
        if (this.allowed && TerrainGen.decorate((World)world, (Random)rand, (int)chunkX, (int)chunkY, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.REED)) {
            WorldGenReed worldGenerator = new WorldGenReed();
            this.loops = this.strengthFactor > 0.0f ? (int)(this.strengthFactor * strength) : this.loops;
            for (int i = 0; i < this.loops; ++i) {
                int intX = chunkX + rand.nextInt(16) + 8;
                int intY = rand.nextInt(this.maxY);
                int intZ = chunkY + rand.nextInt(16) + 8;
                if (intY > this.maxY) continue;
                worldGenerator.func_76484_a(world, rand, intX, intY, intZ);
            }
        }
    }
}

