/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.biome.deco;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenFlowers;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import rtg.util.CellNoise;
import rtg.util.OpenSimplexNoise;
import rtg.world.biome.deco.DecoBase;
import rtg.world.biome.realistic.RealisticBiomeBase;

public class DecoMushrooms
extends DecoBase {
    public float strengthFactor = 0.0f;
    public int maxY = 255;
    public float randomFloat = 1.0f;
    public RandomType randomType = RandomType.USE_CHANCE_VALUE;
    public int chance = 1;
    public int loops = 1;

    public DecoMushrooms() {
        this.addDecoTypes(DecoBase.DecoType.MUSHROOM);
    }

    @Override
    public void generate(RealisticBiomeBase biome, World world, Random rand, int chunkX, int chunkY, OpenSimplexNoise simplex, CellNoise cell, float strength, float river) {
        if (this.allowed && TerrainGen.decorate((World)world, (Random)rand, (int)chunkX, (int)chunkY, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.SHROOM)) {
            switch (this.randomType) {
                case ALWAYS_GENERATE: {
                    this.chance = 1;
                    break;
                }
                case USE_CHANCE_VALUE: {
                    break;
                }
                case X_DIVIDED_BY_STRENGTH: {
                    this.chance = (int)(this.randomFloat / strength);
                    break;
                }
            }
            WorldGenFlowers worldGeneratorBrownShrooms = new WorldGenFlowers((Block)Blocks.field_150338_P);
            WorldGenFlowers worldGeneratorRedShrooms = new WorldGenFlowers((Block)Blocks.field_150337_Q);
            this.loops = this.strengthFactor > 0.0f ? (int)(this.strengthFactor * strength) : this.loops;
            for (int i = 0; i < this.loops; ++i) {
                if (rand.nextInt(this.chance) != 0) continue;
                int intX = chunkX + rand.nextInt(16);
                int intY = rand.nextInt(this.maxY);
                int intZ = chunkY + rand.nextInt(16);
                if (intY > this.maxY) continue;
                if (rand.nextBoolean()) {
                    worldGeneratorBrownShrooms.func_76484_a(world, rand, intX, intY, intZ);
                    continue;
                }
                worldGeneratorRedShrooms.func_76484_a(world, rand, intX, intY, intZ);
            }
        }
    }

    public static enum RandomType {
        ALWAYS_GENERATE,
        USE_CHANCE_VALUE,
        X_DIVIDED_BY_STRENGTH;

    }
}

