/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.biome.deco;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import rtg.util.CellNoise;
import rtg.util.OpenSimplexNoise;
import rtg.world.biome.deco.DecoBase;
import rtg.world.biome.realistic.RealisticBiomeBase;
import rtg.world.gen.feature.WorldGenGrass;

public class DecoGrass
extends DecoBase {
    protected static final int MAX_LOOPS = 10;
    public float strengthFactor = 0.0f;
    public int minY = 1;
    public int maxY = 255;
    public int loops = 1;
    public int chance = 1;
    public int notEqualsZerochance = 1;
    private Block block = Blocks.field_150329_H;
    private int meta = 1;
    public Block[] randomGrassBlocks = new Block[0];
    public byte[] randomGrassMetas = new byte[0];
    protected boolean useRandomGrass = this.randomGrassBlocks.length > 0 && this.randomGrassBlocks.length == this.randomGrassMetas.length;
    private WorldGenGrass grassGenerator;

    public DecoGrass() {
        this.addDecoTypes(DecoBase.DecoType.GRASS);
        this.grassGenerator = new WorldGenGrass(this.block, this.meta);
    }

    public DecoGrass(int meta) {
        this();
        this.meta = meta;
        this.grassGenerator = new WorldGenGrass.SingleType(this.block, meta);
    }

    public DecoGrass(Block block) {
        this();
        this.block = block;
        this.grassGenerator = new WorldGenGrass.SingleType(block, this.meta);
    }

    public DecoGrass(Block[] randomBlocks, byte[] randomMetas) {
        this();
        if (randomBlocks.length != randomMetas.length) {
            throw new RuntimeException("Mismatch in block and metadata arrays for DecoGrass");
        }
        this.randomGrassBlocks = randomBlocks;
        this.randomGrassMetas = randomMetas;
        this.grassGenerator = new WorldGenGrass.RandomType(this.randomGrassBlocks, this.randomGrassMetas);
    }

    @Override
    public void generate(RealisticBiomeBase biome, World world, Random rand, int chunkX, int chunkY, OpenSimplexNoise simplex, CellNoise cell, float strength, float river) {
        if (this.allowed && TerrainGen.decorate((World)world, (Random)rand, (int)chunkX, (int)chunkY, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.GRASS)) {
            this.loops = this.strengthFactor > 0.0f ? (int)(this.strengthFactor * strength) : this.loops;
            this.loops = this.loops > 10 ? 10 : this.loops;
            for (int i = 0; i < this.loops * 64; ++i) {
                int intX = chunkX + rand.nextInt(16);
                int intY = this.minY + (rand.nextInt(this.maxY - this.minY) + 1);
                int intZ = chunkY + rand.nextInt(16);
                if (this.useRandomGrass) {
                    // empty if block
                }
                if (this.notEqualsZerochance > 1) {
                    if (intY < this.minY || intY > this.maxY || rand.nextInt(this.notEqualsZerochance) == 0) continue;
                    this.grassGenerator.func_76484_a(world, rand, intX, intY, intZ);
                    continue;
                }
                if (intY < this.minY || intY > this.maxY || rand.nextInt(this.chance) != 0) continue;
                this.grassGenerator.func_76484_a(world, rand, intX, intY, intZ);
            }
        }
    }
}

