/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.biome.deco;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import rtg.util.CellNoise;
import rtg.util.OpenSimplexNoise;
import rtg.world.biome.deco.DecoBase;
import rtg.world.biome.realistic.RealisticBiomeBase;
import rtg.world.gen.feature.WorldGenLog;

public class DecoFallenTree
extends DecoBase {
    public int loops = 1;
    public Distribution distribution = new Distribution(100.0f, 5.0f, 0.8f);
    public LogCondition logCondition = LogCondition.NOISE_GREATER_AND_RANDOM_CHANCE;
    public float logConditionNoise = 0.0f;
    public int logConditionChance = 1;
    public int maxY = 80;
    public Block logBlock = Blocks.field_150364_r;
    public byte logMeta = 0;
    public Block leavesBlock = Blocks.field_150362_t;
    public byte leavesMeta = (byte)-1;
    public int minSize = 2;
    public int maxSize = 4;
    public Block[] randomLogBlocks = new Block[0];
    public byte[] randomLogMetas = new byte[0];
    protected boolean useRandomLogs = this.randomLogBlocks.length > 0 && this.randomLogBlocks.length == this.randomLogMetas.length;

    public DecoFallenTree() {
        this.addDecoTypes(DecoBase.DecoType.FALLEN_TREE);
    }

    public DecoFallenTree(DecoFallenTree source) {
        this();
        this.loops = source.loops;
        this.distribution = source.distribution;
        this.logCondition = source.logCondition;
        this.logConditionNoise = source.logConditionNoise;
        this.logConditionChance = source.logConditionChance;
        this.maxY = source.maxY;
        this.logBlock = source.logBlock;
        this.logMeta = source.logMeta;
        this.leavesBlock = source.leavesBlock;
        this.leavesMeta = source.leavesMeta;
        this.minSize = source.minSize;
        this.maxSize = source.maxSize;
        this.randomLogBlocks = source.randomLogBlocks;
        this.randomLogMetas = source.randomLogMetas;
        this.useRandomLogs = source.useRandomLogs;
    }

    @Override
    public void generate(RealisticBiomeBase biome, World world, Random rand, int chunkX, int chunkY, OpenSimplexNoise simplex, CellNoise cell, float strength, float river) {
        if (this.allowed) {
            float noise = simplex.noise2((float)chunkX / this.distribution.noiseDivisor, (float)chunkY / this.distribution.noiseDivisor) * this.distribution.noiseFactor + this.distribution.noiseAddend;
            if (this.useRandomLogs) {
                this.logBlock = this.randomLogBlocks[rand.nextInt(this.randomLogBlocks.length)];
                this.logMeta = this.randomLogMetas[rand.nextInt(this.randomLogMetas.length)];
            }
            WorldGenLog worldGenerator = null;
            worldGenerator = this.maxSize > this.minSize ? new WorldGenLog(this.logBlock, this.logMeta, this.leavesBlock, this.leavesMeta, this.minSize + rand.nextInt(this.maxSize - this.minSize)) : (this.maxSize == this.minSize ? new WorldGenLog(this.logBlock, this.logMeta, this.leavesBlock, this.leavesMeta, this.minSize) : new WorldGenLog(this.logBlock, this.logMeta, this.leavesBlock, this.leavesMeta, 4));
            for (int i = 0; i < this.loops; ++i) {
                int z22;
                int x22;
                int y22;
                if (!this.isValidLogCondition(noise, strength, rand) || (y22 = world.func_72976_f(x22 = chunkX + rand.nextInt(16), z22 = chunkY + rand.nextInt(16))) > this.maxY) continue;
                worldGenerator.func_76484_a(world, rand, x22, y22, z22);
            }
        }
    }

    public boolean isValidLogCondition(float noise, float strength, Random rand) {
        switch (this.logCondition) {
            case ALWAYS_GENERATE: {
                return true;
            }
            case RANDOM_CHANCE: {
                return rand.nextInt(this.logConditionChance) == 0;
            }
            case NOISE_GREATER_AND_RANDOM_CHANCE: {
                return noise > this.logConditionNoise && rand.nextInt(this.logConditionChance) == 0;
            }
            case NOISE_LESS_AND_RANDOM_CHANCE: {
                return noise < this.logConditionNoise && rand.nextInt(this.logConditionChance) == 0;
            }
            case X_DIVIDED_BY_STRENGTH: {
                return rand.nextInt((int)(this.logConditionNoise / strength)) == 0;
            }
        }
        return false;
    }

    public static enum LogCondition {
        ALWAYS_GENERATE,
        RANDOM_CHANCE,
        NOISE_GREATER_AND_RANDOM_CHANCE,
        NOISE_LESS_AND_RANDOM_CHANCE,
        X_DIVIDED_BY_STRENGTH;

    }

    public static class Distribution {
        public float noiseDivisor;
        public float noiseFactor;
        public float noiseAddend;

        public Distribution(float noiseDivisor, float noiseFactor, float noiseAddend) {
            this.noiseDivisor = noiseDivisor;
            this.noiseFactor = noiseFactor;
            this.noiseAddend = noiseAddend;
        }
    }
}

