/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.biome.deco;

import enhancedbiomes.api.EBAPI;
import enhancedbiomes.blocks.EnhancedBiomesBlocks;
import enhancedbiomes.helpers.TreeGen;
import enhancedbiomes.world.gen.WorldGenSpikedBush;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraft.world.gen.feature.WorldGenForest;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import rtg.util.CellNoise;
import rtg.util.OpenSimplexNoise;
import rtg.world.biome.deco.DecoBase;
import rtg.world.biome.deco.DecoTree;
import rtg.world.biome.realistic.RealisticBiomeBase;
import rtg.world.gen.feature.WorldGenShrubRTG;
import rtg.world.gen.feature.tree.vanilla.WorldGenTreesRTG;

public class DecoEBTree
extends DecoTree {
    public TreeType treeType;

    public DecoEBTree() {
        this.loops = 1;
        this.strengthFactorForLoops = 0.0f;
        this.strengthNoiseFactorForLoops = false;
        this.strengthNoiseFactorXForLoops = false;
        this.treeType = TreeType.DEAD;
        this.distribution = new DecoTree.Distribution(100.0f, 5.0f, 0.8f);
        this.treeCondition = DecoTree.TreeCondition.NOISE_GREATER_AND_RANDOM_CHANCE;
        this.treeConditionNoise = 0.0f;
        this.treeConditionChance = 1;
        this.minY = 1;
        this.maxY = 255;
        this.logBlock = Blocks.field_150364_r;
        this.logMeta = 0;
        this.leavesBlock = Blocks.field_150362_t;
        this.leavesMeta = (byte)-1;
        this.minSize = 2;
        this.maxSize = 4;
        this.addDecoTypes(DecoBase.DecoType.TREE);
    }

    @Override
    public boolean properlyDefined() {
        return true;
    }

    @Override
    public void generate(RealisticBiomeBase biome, World world, Random rand, int chunkX, int chunkY, OpenSimplexNoise simplex, CellNoise cell, float strength, float river) {
        if (this.allowed && TerrainGen.decorate((World)world, (Random)rand, (int)chunkX, (int)chunkY, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.TREE)) {
            float noise = simplex.noise2((float)chunkX / this.distribution.noiseDivisor, (float)chunkY / this.distribution.noiseDivisor) * this.distribution.noiseFactor + this.distribution.noiseAddend;
            int loopCount = this.loops;
            loopCount = this.strengthFactorForLoops > 0.0f ? (int)(this.strengthFactorForLoops * strength) : loopCount;
            loopCount = this.strengthNoiseFactorForLoops ? (int)(noise * strength) : loopCount;
            loopCount = this.strengthNoiseFactorXForLoops ? (int)(noise * this.strengthFactorForLoops * strength) : loopCount;
            block12: for (int i = 0; i < loopCount; ++i) {
                int intX = chunkX + rand.nextInt(16) + 8;
                int intZ = chunkY + rand.nextInt(16) + 8;
                int intY = world.func_72976_f(intX, intZ);
                switch (this.treeType) {
                    case ALDER: {
                        if (intY > this.maxY || intY < this.minY || !this.isValidTreeCondition(noise, rand, strength)) continue block12;
                        WorldGenAbstractTree worldgenerator = TreeGen.alder((Random)rand);
                        worldgenerator.func_76487_a(1.0, 1.0, 1.0);
                        worldgenerator.func_76484_a(world, rand, intX, intY, intZ);
                        continue block12;
                    }
                    case BIRCH: {
                        if (intY > this.maxY || intY < this.minY || !this.isValidTreeCondition(noise, rand, strength)) continue block12;
                        WorldGenAbstractTree worldgenerator = TreeGen.birch();
                        worldgenerator.func_76487_a(1.0, 1.0, 1.0);
                        worldgenerator.func_76484_a(world, rand, intX, intY, intZ);
                        continue block12;
                    }
                    case CYPRESS: {
                        if (intY > this.maxY || intY < this.minY || !this.isValidTreeCondition(noise, rand, strength)) continue block12;
                        WorldGenAbstractTree worldgenerator = TreeGen.cypress((Random)rand);
                        worldgenerator.func_76487_a(1.0, 1.0, 1.0);
                        worldgenerator.func_76484_a(world, rand, intX, intY, intZ);
                        continue block12;
                    }
                    case DEAD: {
                        if (intY > this.maxY || intY < this.minY || !this.isValidTreeCondition(noise, rand, strength)) continue block12;
                        WorldGenAbstractTree worldgenerator = TreeGen.dead((Random)rand);
                        worldgenerator.func_76487_a(1.0, 1.0, 1.0);
                        worldgenerator.func_76484_a(world, rand, intX, intY, intZ);
                        continue block12;
                    }
                    case EUCALYPTUS: {
                        if (intY > this.maxY || intY < this.minY || !this.isValidTreeCondition(noise, rand, strength)) continue block12;
                        WorldGenAbstractTree worldgenerator = TreeGen.eucalyptus((Random)rand);
                        worldgenerator.func_76487_a(1.0, 1.0, 1.0);
                        worldgenerator.func_76484_a(world, rand, intX, intY, intZ);
                        continue block12;
                    }
                    case EUCALYPTUS_SHRUB: {
                        if (intY > this.maxY || intY < this.minY || !this.isValidTreeCondition(noise, rand, strength)) continue block12;
                        WorldGenAbstractTree worldgenerator = TreeGen.eucalyptus_shrub((Random)rand);
                        worldgenerator.func_76487_a(1.0, 1.0, 1.0);
                        worldgenerator.func_76484_a(world, rand, intX, intY, intZ);
                        continue block12;
                    }
                    case FORESTED_VALLEY: {
                        if (intY > this.maxY || intY < this.minY || !this.isValidTreeCondition(noise, rand, strength)) continue block12;
                        WorldGenAbstractTree worldgenerator = rand.nextInt(2) == 0 ? TreeGen.birch() : (rand.nextInt(10) != 0 ? new WorldGenTreesRTG(false) : new WorldGenForest(false, false));
                        worldgenerator.func_76487_a(1.0, 1.0, 1.0);
                        worldgenerator.func_76484_a(world, rand, intX, intY, intZ);
                        continue block12;
                    }
                    case GREAT_OAK: {
                        if (intY > this.maxY || intY < this.minY || !this.isValidTreeCondition(noise, rand, strength)) continue block12;
                        WorldGenAbstractTree worldgenerator = TreeGen.greatOak((Random)rand);
                        worldgenerator.func_76487_a(1.0, 1.0, 1.0);
                        worldgenerator.func_76484_a(world, rand, intX, intY, intZ);
                        continue block12;
                    }
                    case MANGROVE: {
                        if (intY > this.maxY || intY < this.minY || !this.isValidTreeCondition(noise, rand, strength)) continue block12;
                        WorldGenAbstractTree worldgenerator = TreeGen.mangrove();
                        worldgenerator.func_76487_a(1.0, 1.0, 1.0);
                        worldgenerator.func_76484_a(world, rand, intX, intY, intZ);
                        continue block12;
                    }
                    case SCRUB: {
                        if (intY > this.maxY || intY < this.minY || !this.isValidTreeCondition(noise, rand, strength)) continue block12;
                        if (rand.nextInt(4) != 0) {
                            WorldGenSpikedBush spikedBush = new WorldGenSpikedBush(Blocks.field_150364_r, 0, (Block)Blocks.field_150362_t, 0, EBAPI.ebGrassify((Block)EnhancedBiomesBlocks.dirtEB, Blocks.field_150346_d));
                            spikedBush.func_76484_a(world, rand, intX, intY, intZ);
                            continue block12;
                        }
                        new WorldGenShrubRTG(rand.nextInt(4) + 1, Blocks.field_150364_r, 0, (Block)Blocks.field_150362_t, (byte)rand.nextInt(3)).func_76484_a(world, rand, intX, intY, intZ);
                        continue block12;
                    }
                }
            }
        }
    }

    public static enum TreeType {
        ALDER,
        BIRCH,
        CYPRESS,
        DEAD,
        EUCALYPTUS,
        EUCALYPTUS_SHRUB,
        FORESTED_VALLEY,
        GREAT_OAK,
        MANGROVE,
        SCRUB;

    }
}

