/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.biome.deco;

import java.util.Random;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenDesertWells;
import rtg.util.CellNoise;
import rtg.util.OpenSimplexNoise;
import rtg.world.biome.deco.DecoBase;
import rtg.world.biome.realistic.RealisticBiomeBase;

public class DecoDesertWell
extends DecoBase {
    public float strengthFactor = 0.0f;
    public int maxY = 255;
    public int loops = 1;
    public int chance = 1;

    public DecoDesertWell() {
        this.addDecoTypes(DecoBase.DecoType.DESERT_WELL);
    }

    @Override
    public void generate(RealisticBiomeBase biome, World world, Random rand, int chunkX, int chunkY, OpenSimplexNoise simplex, CellNoise cell, float strength, float river) {
        if (this.allowed) {
            WorldGenDesertWells worldGenerator = new WorldGenDesertWells();
            this.loops = this.strengthFactor > 0.0f ? (int)(this.strengthFactor * strength) : this.loops;
            for (int i = 0; i < this.loops; ++i) {
                if (rand.nextInt(this.chance) != 0) continue;
                int intX = chunkX + rand.nextInt(16) + 8;
                int intY = rand.nextInt(this.maxY);
                int intZ = chunkY + rand.nextInt(16) + 8;
                if (intY > this.maxY) continue;
                worldGenerator.func_76484_a(world, rand, intX, intY, intZ);
            }
        }
    }
}

