/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.biome.deco;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import rtg.util.CellNoise;
import rtg.util.OpenSimplexNoise;
import rtg.world.biome.deco.DecoBase;
import rtg.world.biome.realistic.RealisticBiomeBase;
import rtg.world.gen.feature.WorldGenBlob;

public class DecoBoulder
extends DecoBase {
    public Block boulderBlock = Blocks.field_150347_e;
    public byte boulderMeta = 0;
    public float strengthFactor = 2.0f;
    public int minY = 1;
    public int maxY = 255;
    public int chance = 10;
    public boolean water = true;

    public DecoBoulder() {
        this.addDecoTypes(DecoBase.DecoType.BOULDER);
    }

    @Override
    public void generate(RealisticBiomeBase biome, World world, Random rand, int chunkX, int chunkY, OpenSimplexNoise simplex, CellNoise cell, float strength, float river) {
        if (this.allowed) {
            WorldGenBlob worldGenerator = new WorldGenBlob(this.boulderBlock, this.boulderMeta, 0, rand, this.water);
            int l1 = 0;
            while ((float)l1 < this.strengthFactor * strength) {
                int j1;
                int i1 = chunkX + rand.nextInt(16);
                int k1 = world.func_72976_f(i1, j1 = chunkY + rand.nextInt(16));
                if (k1 >= this.minY && k1 <= this.maxY && rand.nextInt(this.chance) == 0) {
                    worldGenerator.func_76484_a(world, rand, i1, k1, j1);
                }
                ++l1;
            }
        }
    }
}

