/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.biome.deco;

import java.util.ArrayList;
import java.util.Random;
import net.minecraft.world.World;
import rtg.util.CellNoise;
import rtg.util.OpenSimplexNoise;
import rtg.world.biome.realistic.RealisticBiomeBase;

public class DecoBase {
    public boolean allowed = true;
    public ArrayList<DecoType> decoTypes = new ArrayList();
    public boolean checkRiver = false;
    public float minRiver = -2.0f;
    public float maxRiver = 2.0f;

    public boolean properlyDefined() {
        return true;
    }

    public boolean preGenerate(RealisticBiomeBase biome, World world, Random rand, int chunkX, int chunkY, OpenSimplexNoise simplex, CellNoise cell, float strength, float river) {
        return !this.checkRiver || !(river > this.maxRiver) && !(river < this.minRiver);
    }

    public void generate(RealisticBiomeBase biome, World world, Random rand, int chunkX, int chunkY, OpenSimplexNoise simplex, CellNoise cell, float strength, float river) {
    }

    public void addDecoTypes(DecoType ... decos) {
        for (int i = 0; i < decos.length; ++i) {
            this.decoTypes.add(decos[i]);
        }
    }

    public static enum DecoType {
        BASE_BIOME_DECORATION,
        BOULDER,
        CACTUS,
        DEAD_BUSH,
        DESERT_WELL,
        FALLEN_TREE,
        FERN,
        FERN_DOUBLE,
        FLOWER,
        GRASS,
        GRASS_DOUBLE,
        LILYPAD,
        MUSHROOM,
        PUMPKIN,
        REED,
        ROCK_SPIRE,
        SHRUB,
        TEST,
        TREE,
        VINE;

    }
}

