/*
 * Decompiled with CFR 0.152.
 */
package rtg.util;

import java.util.Random;
import rtg.util.CellOctave;

public class VoronoiCellOctave
implements CellOctave {
    private static final double SQRT_2 = 1.4142135623730951;
    private static final double SQRT_3 = 1.7320508075688772;
    private boolean useDistance = false;
    private long seed;
    private long ySeed;
    private long zSeed;
    private short distanceMethod;

    public VoronoiCellOctave(long seed, short distanceMethod, boolean useDistance) {
        this.seed = seed;
        this.ySeed = new Random(seed).nextLong();
        this.zSeed = new Random(this.ySeed).nextLong();
        this.distanceMethod = distanceMethod;
        this.useDistance = useDistance;
    }

    private double distance(double xDist, double zDist) {
        return Math.sqrt(xDist * xDist + zDist * zDist);
    }

    private double getDistance2D(double xDist, double zDist) {
        switch (this.distanceMethod) {
            case 0: {
                return Math.sqrt(xDist * xDist + zDist * zDist) / 1.4142135623730951;
            }
            case 1: {
                return xDist + zDist;
            }
        }
        return Double.NaN;
    }

    private double getDistance(double xDist, double yDist, double zDist) {
        switch (this.distanceMethod) {
            case 0: {
                return Math.sqrt(xDist * xDist + yDist * yDist + zDist * zDist) / 1.7320508075688772;
            }
            case 1: {
                return xDist + yDist + zDist;
            }
        }
        return Double.NaN;
    }

    public boolean isUseDistance() {
        return this.useDistance;
    }

    public void setUseDistance(boolean useDistance) {
        this.useDistance = useDistance;
    }

    public short getDistanceMethod() {
        return this.distanceMethod;
    }

    public long getSeed() {
        return this.seed;
    }

    public void setDistanceMethod(short distanceMethod) {
        this.distanceMethod = distanceMethod;
    }

    public void setSeed(long seed) {
        this.seed = seed;
        this.ySeed = new Random(seed).nextLong();
        this.zSeed = new Random(this.ySeed).nextLong();
    }

    @Override
    public float noise(double x, double z, double frequency) {
        int xInt = x > 0.0 ? (int)x : (int)(x *= frequency) - 1;
        int zInt = z > 0.0 ? (int)z : (int)(z *= frequency) - 1;
        double minDist = 3.2E7;
        double xCandidate = 0.0;
        double zCandidate = 0.0;
        for (int zCur = zInt - 2; zCur <= zInt + 2; ++zCur) {
            for (int xCur = xInt - 2; xCur <= xInt + 2; ++xCur) {
                double zPos;
                double zDist;
                double xPos = (double)xCur + VoronoiCellOctave.valueNoise2D(xCur, zCur, this.seed);
                double xDist = xPos - x;
                double dist = xDist * xDist + (zDist = (zPos = (double)zCur + VoronoiCellOctave.valueNoise2D(xCur, zCur, this.zSeed)) - z) * zDist;
                if (!(dist < minDist)) continue;
                minDist = dist;
                xCandidate = xPos;
                zCandidate = zPos;
            }
        }
        if (this.useDistance) {
            double xDist = xCandidate - x;
            double zDist = zCandidate - z;
            return (float)this.getDistance2D(xDist, zDist);
        }
        return (float)VoronoiCellOctave.valueNoise2D((int)Math.floor(xCandidate), (int)Math.floor(zCandidate), this.seed);
    }

    public float border2(double x, double z, double width, float depth) {
        int xInt = x > 0.0 ? (int)x : (int)(x *= 1.0) - 1;
        int zInt = z > 0.0 ? (int)z : (int)(z *= 1.0) - 1;
        double dCandidate = 3.2E7;
        double xCandidate = 0.0;
        double zCandidate = 0.0;
        double dNeighbour = 3.2E7;
        double xNeighbour = 0.0;
        double zNeighbour = 0.0;
        for (int zCur = zInt - 2; zCur <= zInt + 2; ++zCur) {
            for (int xCur = xInt - 2; xCur <= xInt + 2; ++xCur) {
                double xPos = (double)xCur + VoronoiCellOctave.valueNoise2D(xCur, zCur, this.seed);
                double zPos = (double)zCur + VoronoiCellOctave.valueNoise2D(xCur, zCur, this.zSeed);
                double xDist = xPos - x;
                double zDist = zPos - z;
                double dist = this.distance(xPos - x, zPos - z);
                if (dist < dCandidate) {
                    dNeighbour = dCandidate;
                    xNeighbour = xCandidate;
                    zNeighbour = zCandidate;
                    dCandidate = dist;
                    xCandidate = xPos;
                    zCandidate = zPos;
                    continue;
                }
                if (!(dist > dCandidate) || !(dist < dNeighbour)) continue;
                dNeighbour = dist;
                xNeighbour = xPos;
                zNeighbour = zPos;
            }
        }
        double c = (dNeighbour - dCandidate) / dNeighbour;
        if (c < width) {
            return ((float)(c / width) - 1.0f) * depth;
        }
        return 0.0f;
    }

    @Override
    public double[] eval(double x, double z) {
        int xInt = x > 0.0 ? (int)x : (int)x - 1;
        int zInt = z > 0.0 ? (int)z : (int)z - 1;
        double dCandidate = 3.2E7;
        double xCandidate = 0.0;
        double zCandidate = 0.0;
        double dNeighbour = 3.2E7;
        double xNeighbour = 0.0;
        double zNeighbour = 0.0;
        for (int zCur = zInt - 2; zCur <= zInt + 2; ++zCur) {
            for (int xCur = xInt - 2; xCur <= xInt + 2; ++xCur) {
                double zPos;
                double zDist;
                double xPos = (double)xCur + VoronoiCellOctave.valueNoise2D(xCur, zCur, this.seed);
                double xDist = xPos - x;
                double dist = xDist * xDist + (zDist = (zPos = (double)zCur + VoronoiCellOctave.valueNoise2D(xCur, zCur, this.zSeed)) - z) * zDist;
                if (dist < dCandidate) {
                    dNeighbour = dCandidate;
                    dCandidate = dist;
                    continue;
                }
                if (!(dist < dNeighbour)) continue;
                dNeighbour = dist;
            }
        }
        double[] result = new double[]{dCandidate, dNeighbour};
        return result;
    }

    public double noise(double x, double y, double z, double frequency) {
        int xInt = x > 0.0 ? (int)x : (int)(x *= frequency) - 1;
        int yInt = y > 0.0 ? (int)y : (int)(y *= frequency) - 1;
        int zInt = z > 0.0 ? (int)z : (int)(z *= frequency) - 1;
        double minDist = 3.2E7;
        double xCandidate = 0.0;
        double yCandidate = 0.0;
        double zCandidate = 0.0;
        Random rand = new Random(this.seed);
        for (int zCur = zInt - 2; zCur <= zInt + 2; ++zCur) {
            for (int yCur = yInt - 2; yCur <= yInt + 2; ++yCur) {
                for (int xCur = xInt - 2; xCur <= xInt + 2; ++xCur) {
                    double zPos;
                    double zDist;
                    double yPos;
                    double yDist;
                    double xPos = (double)xCur + VoronoiCellOctave.valueNoise3D(xCur, yCur, zCur, this.seed);
                    double xDist = xPos - x;
                    double dist = xDist * xDist + (yDist = (yPos = (double)yCur + VoronoiCellOctave.valueNoise3D(xCur, yCur, zCur, this.ySeed)) - y) * yDist + (zDist = (zPos = (double)zCur + VoronoiCellOctave.valueNoise3D(xCur, yCur, zCur, this.zSeed)) - z) * zDist;
                    if (!(dist < minDist)) continue;
                    minDist = dist;
                    xCandidate = xPos;
                    yCandidate = yPos;
                    zCandidate = zPos;
                }
            }
        }
        if (this.useDistance) {
            double xDist = xCandidate - x;
            double yDist = yCandidate - y;
            double zDist = zCandidate - z;
            return this.getDistance(xDist, yDist, zDist);
        }
        return VoronoiCellOctave.valueNoise3D((int)Math.floor(xCandidate), (int)Math.floor(yCandidate), (int)Math.floor(zCandidate), this.seed);
    }

    public static double valueNoise2D(int x, int z, long seed) {
        long n = (long)(1619 * x + 6971 * z) + 1013L * seed & Integer.MAX_VALUE;
        n = n >> 13 ^ n;
        return 1.0 - (double)(n * (n * n * 60493L + 19990303L) + 1376312589L & Integer.MAX_VALUE) / 1.073741824E9;
    }

    public static double valueNoise3D(int x, int y, int z, long seed) {
        long n = (long)(1619 * x + 31337 * y + 6971 * z) + 1013L * seed & Integer.MAX_VALUE;
        n = n >> 13 ^ n;
        return 1.0 - (double)(n * (n * n * 60493L + 19990303L) + 1376312589L & Integer.MAX_VALUE) / 1.073741824E9;
    }
}

