/*
 * Decompiled with CFR 0.152.
 */
package rtg.event;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.WeakHashMap;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.structure.MapGenStructureIO;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.BiomeEvent;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.InitMapGenEvent;
import net.minecraftforge.event.terraingen.OreGenEvent;
import net.minecraftforge.event.terraingen.WorldTypeEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.event.world.WorldEvent;
import rtg.RTG;
import rtg.config.rtg.ConfigRTG;
import rtg.util.Acceptor;
import rtg.util.Logger;
import rtg.world.WorldTypeRTG;
import rtg.world.biome.WorldChunkManagerRTG;
import rtg.world.biome.realistic.RealisticBiomeBase;
import rtg.world.gen.MapGenCavesRTG;
import rtg.world.gen.MapGenRavineRTG;
import rtg.world.gen.genlayer.RiverRemover;
import rtg.world.gen.structure.MapGenScatteredFeatureRTG;
import rtg.world.gen.structure.MapGenVillageRTG;

public class EventManagerRTG {
    public RealisticBiomeBase biome = null;
    private WeakHashMap<Integer, Acceptor<ChunkEvent.Load>> chunkLoadEvents = new WeakHashMap();

    public EventManagerRTG() {
        MapGenStructureIO.func_143034_b(MapGenScatteredFeatureRTG.Start.class, (String)"rtg_MapGenScatteredFeatureRTG");
        MapGenStructureIO.func_143034_b(MapGenVillageRTG.Start.class, (String)"rtg_MapGenVillageRTG");
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void eventListenerRTG(InitMapGenEvent event) {
        Logger.debug("event type = %s", event.type.toString());
        Logger.debug("event originalGen = %s", event.originalGen.toString());
        if (event.type == InitMapGenEvent.EventType.SCATTERED_FEATURE) {
            event.newGen = new MapGenScatteredFeatureRTG();
        } else if (event.type == InitMapGenEvent.EventType.VILLAGE) {
            if (ConfigRTG.enableVillageModifications) {
                event.newGen = new MapGenVillageRTG();
            }
        } else if (event.type == InitMapGenEvent.EventType.CAVE) {
            if (ConfigRTG.enableCaveModifications) {
                event.newGen = new MapGenCavesRTG();
            }
        } else if (event.type == InitMapGenEvent.EventType.RAVINE && ConfigRTG.enableRavineModifications) {
            event.newGen = new MapGenRavineRTG();
        }
        Logger.debug("event newGen = %s", event.newGen.toString());
    }

    @SubscribeEvent
    public void eventListenerRTG(WorldEvent.Load event) {
        if (!(event.world.func_72912_H().func_76067_t() instanceof WorldTypeRTG)) {
            MinecraftForge.TERRAIN_GEN_BUS.unregister((Object)RTG.eventMgr);
            MinecraftForge.ORE_GEN_BUS.unregister((Object)RTG.eventMgr);
            MinecraftForge.EVENT_BUS.unregister((Object)RTG.eventMgr);
        }
    }

    @SubscribeEvent
    public void onGenerateMinable(OreGenEvent.GenerateMinable event) {
        switch (event.type) {
            case COAL: {
                if (ConfigRTG.generateOreCoal) break;
                event.setResult(Event.Result.DENY);
                break;
            }
            case IRON: {
                if (ConfigRTG.generateOreIron) break;
                event.setResult(Event.Result.DENY);
                break;
            }
            case GOLD: {
                if (ConfigRTG.generateOreGold) break;
                event.setResult(Event.Result.DENY);
                break;
            }
            case DIAMOND: {
                if (ConfigRTG.generateOreDiamond) break;
                event.setResult(Event.Result.DENY);
                break;
            }
            case REDSTONE: {
                if (ConfigRTG.generateOreRedstone) break;
                event.setResult(Event.Result.DENY);
                break;
            }
            case LAPIS: {
                if (ConfigRTG.generateOreLapis) break;
                event.setResult(Event.Result.DENY);
                break;
            }
        }
    }

    @SubscribeEvent
    public void onBiomeGenInit(WorldTypeEvent.InitBiomeGens event) {
        if (!event.worldType.func_77127_a().equalsIgnoreCase("RTG")) {
            return;
        }
        if (event.newBiomeGens[0].getClass().getName().contains("GenLayerEB")) {
            return;
        }
        boolean stripRivers = true;
        if (stripRivers) {
            try {
                event.newBiomeGens = new RiverRemover().riverLess(event.originalBiomeGens);
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        if (!event.world.func_72912_H().func_76067_t().func_77127_a().equalsIgnoreCase("RTG")) {
            return;
        }
        if (event.world.field_73011_w.field_76574_g == 0) {
            Logger.info("World Seed: %d", event.world.func_72905_C());
        }
    }

    @SubscribeEvent
    public void onGetVillageBlockID(BiomeEvent.GetVillageBlockID event) {
        if (this.isDesertVillageBiome(event.biome == null ? this.biome : event.biome)) {
            Block originalBlock = event.original;
            if (originalBlock == Blocks.field_150347_e || originalBlock == Blocks.field_150344_f || originalBlock == Blocks.field_150364_r || originalBlock == Blocks.field_150363_s || originalBlock == Blocks.field_150351_n) {
                event.replacement = Blocks.field_150322_A;
            } else if (originalBlock == Blocks.field_150476_ad || originalBlock == Blocks.field_150446_ar) {
                event.replacement = Blocks.field_150372_bz;
            }
            if (event.replacement != null) {
                event.setResult(Event.Result.DENY);
            }
        }
    }

    @SubscribeEvent
    public void onGetVillageBlockMeta(BiomeEvent.GetVillageBlockMeta event) {
        boolean replaced = false;
        if (this.isDesertVillageBiome(event.biome == null ? this.biome : event.biome)) {
            Block originalBlock = event.original;
            if (originalBlock == Blocks.field_150364_r || originalBlock == Blocks.field_150363_s || originalBlock == Blocks.field_150347_e) {
                event.replacement = 0;
                replaced = true;
            }
            if (originalBlock == Blocks.field_150344_f) {
                event.replacement = 2;
                replaced = true;
            }
        }
        if (replaced) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public void preBiomeDecorate(DecorateBiomeEvent.Pre event) {
        if (event.world.func_72912_H().func_76067_t() instanceof WorldTypeRTG && event.world.func_72959_q() instanceof WorldChunkManagerRTG) {
            WorldChunkManagerRTG cmr = (WorldChunkManagerRTG)event.world.func_72959_q();
            this.biome = cmr.getBiomeDataAt(event.chunkX, event.chunkZ);
        }
    }

    private boolean isDesertVillageBiome(BiomeGenBase biome) {
        if (biome == null) {
            return false;
        }
        return BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.HOT) && BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.DRY) && BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SANDY);
    }

    @SubscribeEvent
    public void onChunkLoadEvent(ChunkEvent.Load loadEvent) {
        Integer dimension = loadEvent.world.field_73011_w.field_76574_g;
        Acceptor<ChunkEvent.Load> acceptor = this.chunkLoadEvents.get(dimension);
        if (acceptor != null) {
            acceptor.accept(loadEvent);
        }
    }

    public void setDimensionChunkLoadEvent(int dimension, Acceptor<ChunkEvent.Load> action) {
        this.chunkLoadEvents.put(dimension, action);
    }
}

