/*
 * Decompiled with CFR 0.152.
 */
package io.endertech.util.fluid;

import cofh.lib.util.BlockWrapper;
import cofh.lib.util.helpers.ServerHelper;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import io.endertech.util.ETItemWrapper;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemBucket;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;

public class BucketHandler {
    public static BucketHandler instance = new BucketHandler();
    private static BiMap<BlockWrapper, ETItemWrapper> buckets = HashBiMap.create();

    private BucketHandler() {
        if (instance != null) {
            throw new IllegalArgumentException();
        }
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public static void initialize() {
    }

    public static boolean registerBucket(Block block, int bMeta, ItemStack bucket) {
        if (block == null || bMeta < 0 || bucket == null || buckets.containsKey((Object)new BlockWrapper(block, bMeta))) {
            return false;
        }
        buckets.put((Object)new BlockWrapper(block, bMeta), (Object)new ETItemWrapper(bucket));
        return true;
    }

    public static ItemStack fillBucket(World world, int x, int y, int z) {
        int bMeta;
        Block block = world.func_147439_a(x, y, z);
        if (!buckets.containsKey((Object)new BlockWrapper(block, bMeta = world.func_72805_g(x, y, z)))) {
            IFluidBlock flBlock;
            if (block.equals(Blocks.field_150355_j) || block.equals(Blocks.field_150358_i)) {
                if (world.func_72805_g(x, y, z) == 0) {
                    world.func_147468_f(x, y, z);
                    return new ItemStack(Items.field_151131_as);
                }
                return null;
            }
            if (block.equals(Blocks.field_150353_l) || block.equals(Blocks.field_150356_k)) {
                if (world.func_72805_g(x, y, z) == 0) {
                    world.func_147468_f(x, y, z);
                    return new ItemStack(Items.field_151129_at);
                }
                return null;
            }
            if (block instanceof IFluidBlock && (flBlock = (IFluidBlock)block).canDrain(world, x, y, z)) {
                ItemStack stack = new ItemStack(Items.field_151133_ar);
                stack = FluidContainerRegistry.fillFluidContainer((FluidStack)flBlock.drain(world, x, y, z, false), (ItemStack)stack);
                if (stack != null) {
                    flBlock.drain(world, x, y, z, true);
                    return stack;
                }
            }
            return null;
        }
        if (!world.func_147468_f(x, y, z)) {
            return null;
        }
        ETItemWrapper result = (ETItemWrapper)buckets.get((Object)new BlockWrapper(block, bMeta));
        return new ItemStack(result.item, 1, result.metadata);
    }

    public static boolean emptyBucket(World world, int x, int y, int z, ItemStack bucket) {
        boolean solid;
        boolean r = false;
        BiMap inverseMap = buckets.inverse();
        if (!inverseMap.containsKey(new ETItemWrapper(bucket))) {
            if (bucket.func_77973_b() instanceof ItemBucket) {
                r = ((ItemBucket)bucket.func_77973_b()).func_77875_a(world, x, y, z);
                world.func_147471_g(x, y, z);
            }
            return r;
        }
        BlockWrapper result = (BlockWrapper)buckets.inverse().get((Object)new ETItemWrapper(bucket));
        Material material = world.func_147439_a(x, y, z).func_149688_o();
        boolean bl = solid = !material.func_76220_a();
        if (world.func_147437_c(x, y, z) || solid) {
            if (!world.field_72995_K && solid && !material.func_76224_d()) {
                world.func_147480_a(x, y, z, true);
            }
            r = world.func_147465_d(x, y, z, result.block, result.metadata, 3);
            world.func_147471_g(x, y, z);
        }
        return r;
    }

    public static void refreshMap() {
        HashBiMap tempMap = HashBiMap.create((int)buckets.size());
        for (Map.Entry entry : buckets.entrySet()) {
            BlockWrapper tempBlock = new BlockWrapper(((BlockWrapper)entry.getKey()).block, ((BlockWrapper)entry.getKey()).metadata);
            ETItemWrapper tempItem = new ETItemWrapper(((ETItemWrapper)entry.getValue()).item, ((ETItemWrapper)entry.getValue()).metadata);
            tempMap.put((Object)tempBlock, (Object)tempItem);
        }
        buckets.clear();
        buckets = tempMap;
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onBucketFill(FillBucketEvent event) {
        if (ServerHelper.isClientWorld(event.world) | event.result != null || event.getResult() != Event.Result.DEFAULT) {
            return;
        }
        ItemStack current = event.current;
        if (event.target.field_72313_a != MovingObjectPosition.MovingObjectType.BLOCK) {
            return;
        }
        boolean fill = true;
        int x = event.target.field_72311_b;
        int y = event.target.field_72312_c;
        int z = event.target.field_72309_d;
        int side = event.target.field_72310_e;
        if (!current.func_77973_b().equals(Items.field_151133_ar)) {
            if (FluidContainerRegistry.isBucket((ItemStack)current)) {
                ForgeDirection fside = ForgeDirection.getOrientation((int)side);
                Block block = event.world.func_147439_a(x, y, z);
                if (!block.isReplaceable((IBlockAccess)event.world, x += fside.offsetX, y += fside.offsetY, z += fside.offsetZ) && block.func_149688_o().func_76220_a()) {
                    x -= fside.offsetX;
                    y -= fside.offsetY;
                    z -= fside.offsetZ;
                }
                fill = false;
            } else {
                return;
            }
        }
        if (event.entityPlayer != null && (fill && !event.world.func_72962_a(event.entityPlayer, x, y, z) || !event.entityPlayer.func_82247_a(x, y, z, side, current))) {
            event.setCanceled(true);
            return;
        }
        ItemStack bucket = null;
        if (fill) {
            bucket = BucketHandler.fillBucket(event.world, x, y, z);
        } else if (BucketHandler.emptyBucket(event.world, x, y, z, current)) {
            bucket = new ItemStack(Items.field_151133_ar);
        }
        if (bucket == null) {
            return;
        }
        event.result = bucket;
        event.setResult(Event.Result.ALLOW);
    }
}

