/*
 * Decompiled with CFR 0.152.
 */
package io.endertech.multiblock.renderer;

import io.endertech.block.ETBlocks;
import io.endertech.config.GeneralConfig;
import io.endertech.multiblock.block.BlockTankController;
import io.endertech.multiblock.controller.ControllerTank;
import io.endertech.multiblock.tile.TileTankController;
import io.endertech.util.BlockCoord;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public class TankControllerRenderer
extends TileEntitySpecialRenderer
implements IItemRenderer {
    private RenderBlocks renderer = new RenderBlocks();

    public static ResourceLocation getFluidSheet(Fluid liquid) {
        return TextureMap.field_110575_b;
    }

    public void renderControllerBlock(RenderBlocks renderer, BlockTankController block, int meta, ForgeDirection front, double translateX, double translateY, double translateZ) {
        Tessellator tessellator = Tessellator.field_78398_a;
        renderer.func_147775_a((Block)block);
        GL11.glTranslated((double)translateX, (double)translateY, (double)translateZ);
        tessellator.func_78382_b();
        IIcon texture = block.bottomIcon;
        tessellator.func_78375_b(0.0f, -1.0f, 0.0f);
        renderer.func_147768_a((Block)block, 0.0, 0.0, 0.0, texture);
        texture = block.topIcon;
        tessellator.func_78375_b(0.0f, 1.0f, 0.0f);
        renderer.func_147806_b((Block)block, 0.0, 0.0, 0.0, texture);
        texture = block.sideIcon;
        tessellator.func_78375_b(0.0f, 0.0f, -1.0f);
        if (front == ForgeDirection.NORTH) {
            renderer.func_147761_c((Block)block, 0.0, 0.0, 0.0, block.func_149691_a(ForgeDirection.NORTH.ordinal(), meta));
        } else {
            renderer.func_147761_c((Block)block, 0.0, 0.0, 0.0, texture);
        }
        tessellator.func_78375_b(0.0f, 0.0f, 1.0f);
        if (front == ForgeDirection.SOUTH) {
            renderer.func_147734_d((Block)block, 0.0, 0.0, 0.0, block.func_149691_a(ForgeDirection.SOUTH.ordinal(), meta));
        } else {
            renderer.func_147734_d((Block)block, 0.0, 0.0, 0.0, texture);
        }
        tessellator.func_78375_b(-1.0f, 0.0f, 0.0f);
        if (front == ForgeDirection.WEST) {
            renderer.func_147798_e((Block)block, 0.0, 0.0, 0.0, block.func_149691_a(ForgeDirection.WEST.ordinal(), meta));
        } else {
            renderer.func_147798_e((Block)block, 0.0, 0.0, 0.0, texture);
        }
        tessellator.func_78375_b(1.0f, 0.0f, 0.0f);
        if (front == ForgeDirection.EAST) {
            renderer.func_147764_f((Block)block, 0.0, 0.0, 0.0, block.func_149691_a(ForgeDirection.EAST.ordinal(), meta));
        } else {
            renderer.func_147764_f((Block)block, 0.0, 0.0, 0.0, texture);
        }
        tessellator.func_78381_a();
    }

    public void func_147500_a(TileEntity tile, double x, double y, double z, float f) {
        if (!(tile instanceof TileTankController)) {
            return;
        }
        TileTankController tank = (TileTankController)tile;
        Block tempBlock = tile.func_145838_q();
        if (!(tempBlock instanceof BlockTankController)) {
            return;
        }
        BlockTankController block = (BlockTankController)tile.func_145838_q();
        int meta = tile.func_145832_p();
        this.func_147499_a(TextureMap.field_110575_b);
        GL11.glPushMatrix();
        this.renderer.field_147845_a = tile.func_145831_w();
        this.renderControllerBlock(this.renderer, block, meta, tank.getOrientation(), x, y, z);
        GL11.glPopMatrix();
        ControllerTank controller = tank.getTankController();
        if (controller == null) {
            return;
        }
        BlockCoord min = controller.getMinimumCoord();
        BlockCoord max = controller.getMaximumCoord();
        if (controller != null && controller.isAssembled() && min != null && controller.tank.getFluid() != null) {
            BlockCoord rMin = new BlockCoord(tile.field_145851_c - min.x, tile.field_145848_d - min.y, tile.field_145849_e - min.z);
            double diff = controller.tank.getFluidAmount() - controller.lastTank.getFluidAmount();
            double ratio = (diff - (double)controller.renderAddition) / diff;
            if (ratio <= 0.3) {
                ratio = 0.3;
            }
            if (ratio >= 0.8) {
                ratio = 0.8;
            }
            if (controller.renderedOnce) {
                controller.renderAddition = (int)((double)controller.renderAddition + diff * (double)f * ratio * 0.1);
            } else {
                controller.renderAddition = (int)((double)controller.renderAddition + diff);
                controller.renderedOnce = true;
            }
            if (diff < 0.0) {
                if ((double)controller.renderAddition < diff) {
                    controller.renderAddition = (int)diff;
                }
            } else if ((double)controller.renderAddition > diff) {
                controller.renderAddition = (int)diff;
            }
            double amount = controller.lastTank.getFluidAmount() + controller.renderAddition;
            double capacity = controller.tank.getCapacity();
            int unitHeights = max.y - min.y - 1;
            double capacityPerUnitHeight = capacity / (double)unitHeights;
            double[] levelAmounts = new double[unitHeights];
            int stopLevel = 0;
            for (int level = 0; level < unitHeights && stopLevel == 0; ++level) {
                double levelAmount = capacityPerUnitHeight;
                if ((amount -= capacityPerUnitHeight) <= 0.0) {
                    levelAmount += amount;
                    stopLevel = level + 1;
                }
                levelAmounts[level] = levelAmount;
            }
            boolean setOpacity = false;
            float opacity = 1.0f;
            Fluid fluid = controller.tank.getFluid().getFluid();
            IIcon texture = fluid.getStillIcon();
            if (texture == null) {
                return;
            }
            GL11.glPushMatrix();
            GL11.glTranslated((double)(x + 0.5 - (double)rMin.x + 1.0), (double)(y + 0.5 - (double)rMin.y + 1.0), (double)(z + 0.5 - (double)rMin.z + 1.0));
            GL11.glDisable((int)2896);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            int colour = fluid.getColor(new FluidStack(fluid, 1));
            this.func_147499_a(TankControllerRenderer.getFluidSheet(fluid));
            if (fluid.getDensity() < 0) {
                if (GeneralConfig.gasTopToBottom) {
                    GL11.glTranslatef((float)0.0f, (float)1.0f, (float)0.0f);
                    GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)1.0f);
                } else {
                    for (int i = 0; i < unitHeights; ++i) {
                        levelAmounts[i] = capacityPerUnitHeight;
                    }
                    setOpacity = true;
                    stopLevel = unitHeights;
                    opacity = (float)((double)(controller.lastTank.getFluidAmount() + controller.renderAddition) / capacity);
                    if (opacity < 0.2f) {
                        opacity = 0.2f;
                    }
                }
            }
            if (stopLevel != 0) {
                for (int level = 0; level < stopLevel; ++level) {
                    if (!(levelAmounts[level] > 0.0)) continue;
                    double height = levelAmounts[level] / capacityPerUnitHeight;
                    if (height > 0.0 && height < 0.02) {
                        height = 0.02;
                    }
                    this.renderFluidBlocks(height, colour, texture, max.x - min.x - 1, level, stopLevel, max.z - min.z - 1, setOpacity, opacity);
                }
            }
            GL11.glEnable((int)2896);
            GL11.glDisable((int)3042);
            GL11.glPopMatrix();
        }
    }

    public void renderFluidBlocks(double height, int colour, IIcon texture, int repx, int yoffset, int maxyoffset, int repz, boolean setOpacity, float opacity) {
        Tessellator t = Tessellator.field_78398_a;
        double ySouthEast = height;
        double yNorthEast = height;
        double ySouthWest = height;
        double yNorthWest = height;
        double uMin = texture.func_94214_a(0.0);
        double uMax = texture.func_94214_a(16.0);
        double vMin = texture.func_94207_b(0.0);
        double vMax = texture.func_94207_b(16.0);
        double vHeight = vMax - vMin;
        float r = (float)(colour >> 16 & 0xFF) / 255.0f;
        float g = (float)(colour >> 8 & 0xFF) / 255.0f;
        float b = (float)(colour & 0xFF) / 255.0f;
        for (int rx = 0; rx < repx; ++rx) {
            int ry = yoffset;
            for (int rz = 0; rz < repz; ++rz) {
                t.func_78382_b();
                if (!setOpacity) {
                    t.func_78386_a(r, g, b);
                } else {
                    t.func_78369_a(r, g, b, opacity);
                }
                if (rz == 0) {
                    t.func_78374_a(0.5 + (double)rx, -0.5 + (double)ry, -0.5, uMax, vMin);
                    t.func_78374_a(-0.5 + (double)rx, -0.5 + (double)ry, -0.5, uMin, vMin);
                    t.func_78374_a(-0.5 + (double)rx, -0.5 + yNorthWest + (double)ry, -0.5 + (double)rz, uMin, vMin + vHeight * yNorthWest);
                    t.func_78374_a(0.5 + (double)rx, -0.5 + yNorthEast + (double)ry, -0.5 + (double)rz, uMax, vMin + vHeight * yNorthEast);
                }
                if (rz == repz - 1) {
                    t.func_78374_a(0.5 + (double)rx, -0.5 + (double)ry, 0.5 + (double)rz, uMin, vMin);
                    t.func_78374_a(0.5 + (double)rx, -0.5 + ySouthEast + (double)ry, 0.5 + (double)rz, uMin, vMin + vHeight * ySouthEast);
                    t.func_78374_a(-0.5 + (double)rx, -0.5 + ySouthWest + (double)ry, 0.5 + (double)rz, uMax, vMin + vHeight * ySouthWest);
                    t.func_78374_a(-0.5 + (double)rx, -0.5 + (double)ry, 0.5 + (double)rz, uMax, vMin);
                }
                if (rx == repx - 1) {
                    t.func_78374_a(0.5 + (double)rx, -0.5 + (double)ry, -0.5 + (double)rz, uMin, vMin);
                    t.func_78374_a(0.5 + (double)rx, -0.5 + yNorthEast + (double)ry, -0.5 + (double)rz, uMin, vMin + vHeight * yNorthEast);
                    t.func_78374_a(0.5 + (double)rx, -0.5 + ySouthEast + (double)ry, 0.5 + (double)rz, uMax, vMin + vHeight * ySouthEast);
                    t.func_78374_a(0.5 + (double)rx, -0.5 + (double)ry, 0.5 + (double)rz, uMax, vMin);
                }
                if (rx == 0) {
                    t.func_78374_a(-0.5 + (double)rx, -0.5 + (double)ry, 0.5 + (double)rz, uMin, vMin);
                    t.func_78374_a(-0.5 + (double)rx, -0.5 + ySouthWest + (double)ry, 0.5 + (double)rz, uMin, vMin + vHeight * ySouthWest);
                    t.func_78374_a(-0.5 + (double)rx, -0.5 + yNorthWest + (double)ry, -0.5 + (double)rz, uMax, vMin + vHeight * yNorthWest);
                    t.func_78374_a(-0.5 + (double)rx, -0.5 + (double)ry, -0.5 + (double)rz, uMax, vMin);
                }
                if (ry == maxyoffset - 1) {
                    t.func_78374_a(0.5 + (double)rx, -0.5 + ySouthEast + (double)ry, 0.5 + (double)rz, uMax, vMin);
                    t.func_78374_a(0.5 + (double)rx, -0.5 + yNorthEast + (double)ry, -0.5 + (double)rz, uMin, vMin);
                    t.func_78374_a(-0.5 + (double)rx, -0.5 + yNorthWest + (double)ry, -0.5 + (double)rz, uMin, vMax);
                    t.func_78374_a(-0.5 + (double)rx, -0.5 + ySouthWest + (double)ry, 0.5 + (double)rz, uMax, vMax);
                }
                if (ry == 0) {
                    t.func_78374_a(0.5 + (double)rx, -0.5 + (double)ry, -0.5 + (double)rz, uMax, vMin);
                    t.func_78374_a(0.5 + (double)rx, -0.5 + (double)ry, 0.5 + (double)rz, uMin, vMin);
                    t.func_78374_a(-0.5 + (double)rx, -0.5 + (double)ry, 0.5 + (double)rz, uMin, vMax);
                    t.func_78374_a(-0.5 + (double)rx, -0.5 + (double)ry, -0.5 + (double)rz, uMax, vMax);
                }
                t.func_78381_a();
            }
        }
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return true;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        float x = 0.0f;
        float y = 0.0f;
        float z = 0.0f;
        switch (type) {
            case ENTITY: {
                x = -0.5f;
                y = -0.25f;
                z = -0.5f;
                break;
            }
            case EQUIPPED: {
                x = 0.0f;
                y = 0.0f;
                z = 0.0f;
                break;
            }
            case EQUIPPED_FIRST_PERSON: {
                x = 0.0f;
                y = 0.0f;
                z = 0.0f;
                break;
            }
            case INVENTORY: {
                x = 0.0f;
                y = -0.1f;
                z = 0.0f;
                break;
            }
            default: {
                return;
            }
        }
        GL11.glPushMatrix();
        GL11.glTranslatef((float)x, (float)y, (float)z);
        this.renderer.func_147775_a(ETBlocks.blockTankController);
        this.renderControllerBlock(this.renderer, (BlockTankController)ETBlocks.blockTankController, 0, ForgeDirection.EAST, 0.0, 0.0, 0.0);
        GL11.glPopMatrix();
    }
}

