/*
 * Decompiled with CFR 0.152.
 */
package io.endertech.multiblock.block;

import cofh.api.block.IDismantleable;
import cofh.lib.util.helpers.ServerHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.endertech.EnderTech;
import io.endertech.block.BlockET;
import io.endertech.multiblock.block.BlockTankPart;
import io.endertech.multiblock.controller.ControllerTank;
import io.endertech.multiblock.tile.TileTankController;
import io.endertech.multiblock.tile.TileTankPart;
import io.endertech.util.BlockCoord;
import io.endertech.util.IOutlineDrawer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;

public class BlockTankController
extends BlockET
implements ITileEntityProvider,
IOutlineDrawer,
IDismantleable {
    public static final int CONTROLLER_METADATA_BASE = 0;
    public static final int CONTROLLER_IDLE = 1;
    public static final int CONTROLLER_ACTIVE = 2;
    public static final String TEXTURE_BASE = "endertech:enderTankController";
    public static ItemStack itemBlockTankController;
    private static String[] _subBlocks;
    public IIcon sideIcon;
    public IIcon topIcon;
    public IIcon bottomIcon;
    private IIcon[] _icons = new IIcon[_subBlocks.length];

    public BlockTankController() {
        super(Material.field_151573_f);
        this.func_149711_c(10.0f);
        this.func_149752_b(20.0f);
        this.func_149647_a(EnderTech.tabET);
        this.func_149663_c("enderTankController");
    }

    public static boolean isController(int metadata) {
        return metadata >= 0 && metadata <= 2;
    }

    public TileEntity func_149915_a(World world, int metadata) {
        if (metadata >= 0 && metadata <= 2) {
            return new TileTankController();
        }
        throw new IllegalArgumentException("Unrecognized metadata");
    }

    public void init() {
        TileTankController.init();
        itemBlockTankController = new ItemStack((Block)this, 1, 0);
    }

    public int func_149645_b() {
        return -1;
    }

    public boolean func_149662_c() {
        return false;
    }

    public ItemStack getTankControllerItemStack() {
        return new ItemStack((Block)this, 1, 0);
    }

    public void func_149666_a(Item item, CreativeTabs par2CreativeTabs, List par3List) {
        par3List.add(this.getTankControllerItemStack());
    }

    @Override
    public boolean drawOutline(DrawBlockHighlightEvent event) {
        BlockCoord target = new BlockCoord(event.target.field_72311_b, event.target.field_72312_c, event.target.field_72309_d);
        World world = event.player.field_70170_p;
        TileEntity tile = world.func_147438_o(target.x, target.y, target.z);
        if (tile instanceof TileTankPart) {
            return ((TileTankPart)tile).drawOutline(event);
        }
        return false;
    }

    public int func_149692_a(int meta) {
        return 0;
    }

    public IIcon func_149691_a(int side, int meta) {
        return this._icons[meta];
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        for (int i = 0; i < _subBlocks.length; ++i) {
            this._icons[i] = iconRegister.func_94245_a("endertech:enderTankController." + _subBlocks[i]);
        }
        this.sideIcon = iconRegister.func_94245_a("endertech:machines/Machine_Resonant_Side");
        this.topIcon = iconRegister.func_94245_a("endertech:machines/Machine_Resonant_Top");
        this.bottomIcon = iconRegister.func_94245_a("endertech:machines/Machine_Resonant_Bottom");
    }

    @Override
    public ArrayList<ItemStack> dismantleBlock(EntityPlayer player, World world, int x, int y, int z, boolean returnDrops) {
        TileTankController tileTankController;
        ControllerTank controller;
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileTankController && ServerHelper.isServerWorld(world) && (controller = (tileTankController = (TileTankController)tile).getTankController()) != null && controller.isAssembled()) {
            controller.popInventoryContentsOut(world, x, y, z);
        }
        return BlockTankController.dismantleBlockInWorld(player, world, x, y, z, returnDrops);
    }

    @Override
    public boolean canDismantle(EntityPlayer player, World world, int x, int y, int z) {
        return BlockTankPart.canDismantleTankBlock(player, world, x, y, z);
    }

    public boolean canCreatureSpawn(EnumCreatureType type, IBlockAccess world, int x, int y, int z) {
        return false;
    }

    public boolean func_149742_c(World world, int x, int y, int z) {
        return BlockTankPart.canPlaceTankPartAt(world, x, y, z);
    }

    @Override
    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int faceHit, float par7, float par8, float par9) {
        boolean overridden = super.func_149727_a(world, x, y, z, player, faceHit, par7, par8, par9);
        if (!overridden) {
            overridden = BlockTankPart.onTankBlockActivated(world, x, y, z, player, faceHit, par7, par8, par9);
        }
        return overridden;
    }

    static {
        _subBlocks = new String[]{"controllerBase", "controllerIdle", "controllerActive"};
    }
}

