/*
 * Decompiled with CFR 0.152.
 */
package io.endertech.client.handler;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.InputEvent;
import io.endertech.item.IKeyHandler;
import io.endertech.network.PacketKeyPressed;
import io.endertech.util.Key;
import io.endertech.util.helper.LogHelper;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

public class KeyBindingHandler {
    public static ETKeyBinding keyToolIncrease = new ETKeyBinding("Tool Increase", 201, "key.endertech.tools", Key.KeyCode.TOOL_INCREASE);
    public static ETKeyBinding keyToolDecrease = new ETKeyBinding("Tool Decrease", 209, "key.endertech.tools", Key.KeyCode.TOOL_DECREASE);
    public static ETKeyBinding[] keyBindings = new ETKeyBinding[]{keyToolIncrease, keyToolDecrease};
    public static Map<String, Key.KeyCode> keyCodeMap = new HashMap<String, Key.KeyCode>();

    public static void init() {
        for (ETKeyBinding keyBinding : keyBindings) {
            ClientRegistry.registerKeyBinding((KeyBinding)keyBinding.getMinecraftKeyBinding());
            keyCodeMap.put(keyBinding.getMinecraftKeyBinding().func_151464_g(), keyBinding.getKeyCode());
        }
    }

    public static Key.KeyCode whichKeyPressed() {
        for (ETKeyBinding keyBinding : keyBindings) {
            if (!keyBinding.getMinecraftKeyBinding().func_151470_d()) continue;
            return keyCodeMap.get(keyBinding.getMinecraftKeyBinding().func_151464_g());
        }
        return Key.KeyCode.UNKNOWN;
    }

    @SubscribeEvent
    public void handleKeyInputEvent(InputEvent.KeyInputEvent event) {
        ItemStack equippedItem;
        EntityClientPlayerMP player;
        if (FMLClientHandler.instance().getClient().field_71415_G && (player = FMLClientHandler.instance().getClient().field_71439_g) != null && (equippedItem = player.func_71045_bC()) != null && equippedItem.func_77973_b() instanceof IKeyHandler) {
            Key.KeyCode keyCode = KeyBindingHandler.whichKeyPressed();
            Set<Key.KeyCode> handledKeyCodes = ((IKeyHandler)equippedItem.func_77973_b()).getHandledKeys();
            if (!handledKeyCodes.contains((Object)keyCode)) {
                return;
            }
            if (player.field_70170_p.field_72995_K) {
                LogHelper.debug("Remote, sent " + keyCode.toString() + " to server", new Object[0]);
                new PacketKeyPressed().sendKeyPressedPacket(keyCode);
            } else {
                LogHelper.debug("Client, handling key press: " + keyCode.toString(), new Object[0]);
                ((IKeyHandler)player.func_71045_bC().func_77973_b()).handleKey((EntityPlayer)player, equippedItem, keyCode);
            }
        }
    }

    private static class ETKeyBinding {
        private KeyBinding keyBinding;
        private Key.KeyCode keyCode;

        public ETKeyBinding(String description, int keyboardCode, String category, Key.KeyCode keyCode) {
            this.keyBinding = new KeyBinding(description, keyboardCode, category);
            this.keyCode = keyCode;
        }

        public Key.KeyCode getKeyCode() {
            return this.keyCode;
        }

        public KeyBinding getMinecraftKeyBinding() {
            return this.keyBinding;
        }
    }
}

