/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.world;

import cofh.lib.util.WeightedRandomBlock;
import cofh.lib.world.WorldGenMinableCluster;
import java.util.List;
import java.util.Random;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class WorldGenMinablePlate
extends WorldGenerator {
    private final List<WeightedRandomBlock> cluster;
    private final WeightedRandomBlock[] genBlock;
    private final int radius;
    public byte height = 1;
    public byte variation = (byte)2;
    public boolean slim = false;

    public WorldGenMinablePlate(List<WeightedRandomBlock> resource, int clusterSize, List<WeightedRandomBlock> block) {
        this.cluster = resource;
        this.radius = clusterSize;
        this.genBlock = block.toArray(new WeightedRandomBlock[block.size()]);
    }

    public boolean func_76484_a(World world, Random rand, int x, int y, int z) {
        ++y;
        int size = this.radius;
        if (this.radius > this.variation + 1) {
            size = rand.nextInt(this.radius - this.variation) + this.variation;
        }
        int dist = size * size;
        byte height = this.height;
        boolean r = false;
        for (int posX = x - size; posX <= x + size; ++posX) {
            int xDist = posX - x;
            xDist *= xDist;
            for (int posZ = z - size; posZ <= z + size; ++posZ) {
                int zSize = posZ - z;
                if (zSize * zSize + xDist > dist) continue;
                int posY = y - height;
                while (this.slim ? posY < y + height : posY <= y + height) {
                    r |= WorldGenMinableCluster.generateBlock(world, posX, posY, posZ, this.genBlock, this.cluster);
                    ++posY;
                }
            }
        }
        return r;
    }
}

