/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.transport;

import cofh.api.transport.IEnderAttuned;
import cofh.api.transport.IEnderDestination;
import cofh.api.transport.IEnderEnergyHandler;
import cofh.api.transport.IEnderFluidHandler;
import cofh.api.transport.IEnderItemHandler;
import cofh.lib.util.ArrayHashList;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.HashMap;
import java.util.List;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public final class EnderRegistry {
    private HashMap<String, TIntObjectHashMap<ArrayHashList<IEnderItemHandler>>> inputItem = new HashMap();
    private HashMap<String, TIntObjectHashMap<ArrayHashList<IEnderFluidHandler>>> inputFluid = new HashMap();
    private HashMap<String, TIntObjectHashMap<ArrayHashList<IEnderEnergyHandler>>> inputEnergy = new HashMap();
    private HashMap<String, TIntObjectHashMap<ArrayHashList<IEnderItemHandler>>> outputItem = new HashMap();
    private HashMap<String, TIntObjectHashMap<ArrayHashList<IEnderFluidHandler>>> outputFluid = new HashMap();
    private HashMap<String, TIntObjectHashMap<ArrayHashList<IEnderEnergyHandler>>> outputEnergy = new HashMap();
    private HashMap<String, TIntObjectHashMap<EnderDestination>> outputTeleport = new HashMap();
    private Configuration linkConf;

    public EnderRegistry(Configuration config) {
        this.linkConf = config;
        this.load();
    }

    private void load() {
        for (String channel : this.linkConf.getCategoryNames()) {
            ConfigCategory category = this.linkConf.getCategory(channel);
            TIntObjectHashMap map = this.outputTeleport.get(channel);
            if (map == null) {
                map = new TIntObjectHashMap();
                this.outputTeleport.put(channel, (TIntObjectHashMap<EnderDestination>)map);
            }
            for (Property prop : category.values()) {
                try {
                    int freq = Integer.parseInt(prop.getName());
                    String[] data = prop.getString().split("@");
                    if (data.length != 2) continue;
                    int dimension = Integer.parseInt(data[0]);
                    if ((data = data[1].split(",")).length != 3) continue;
                    int x = Integer.parseInt(data[0]);
                    int y = Integer.parseInt(data[1]);
                    int z = Integer.parseInt(data[2]);
                    EnderDestination dest = new EnderDestination(x, y, z, dimension);
                    map.put(freq, (Object)dest);
                }
                catch (Throwable throwable) {}
            }
        }
    }

    public void save() {
        if (this.linkConf.hasChanged()) {
            this.linkConf.save();
        }
    }

    private <T> T getElement(HashMap<String, TIntObjectHashMap<T>> map, IEnderAttuned theAttuned) {
        TIntObjectHashMap<T> list = map.get(theAttuned.getChannelString());
        if (list != null) {
            return (T)list.get(theAttuned.getFrequency());
        }
        return null;
    }

    public List<IEnderItemHandler> getLinkedItemInputs(IEnderItemHandler theAttuned) {
        return (List)this.getElement(this.inputItem, theAttuned);
    }

    public List<IEnderItemHandler> getLinkedItemOutputs(IEnderItemHandler theAttuned) {
        return (List)this.getElement(this.outputItem, theAttuned);
    }

    public List<IEnderFluidHandler> getLinkedFluidInputs(IEnderFluidHandler theAttuned) {
        return (List)this.getElement(this.inputFluid, theAttuned);
    }

    public List<IEnderFluidHandler> getLinkedFluidOutputs(IEnderFluidHandler theAttuned) {
        return (List)this.getElement(this.outputFluid, theAttuned);
    }

    public List<IEnderEnergyHandler> getLinkedEnergyInputs(IEnderEnergyHandler theAttuned) {
        return (List)this.getElement(this.inputEnergy, theAttuned);
    }

    public List<IEnderEnergyHandler> getLinkedEnergyOutputs(IEnderEnergyHandler theAttuned) {
        return (List)this.getElement(this.outputEnergy, theAttuned);
    }

    public boolean hasDestination(IEnderDestination theAttuned) {
        return this.hasDestination(theAttuned, true);
    }

    public boolean hasDestination(IEnderDestination theAttuned, boolean to) {
        TIntObjectHashMap<EnderDestination> map = this.outputTeleport.get(theAttuned.getChannelString());
        if (map == null) {
            return false;
        }
        EnderDestination dest = (EnderDestination)map.get(to ? theAttuned.getDestination() : theAttuned.getFrequency());
        return dest == null ? false : dest.hasOutput();
    }

    public IEnderDestination getDestination(IEnderDestination theAttuned) {
        return this.getDestination(theAttuned, true);
    }

    public IEnderDestination getDestination(IEnderDestination theAttuned, boolean requireLoaded) {
        final String channel = theAttuned.getChannelString();
        TIntObjectHashMap<EnderDestination> map = this.outputTeleport.get(channel);
        if (map == null) {
            return null;
        }
        final int frequency = theAttuned.getDestination();
        final EnderDestination dest = (EnderDestination)map.get(frequency);
        if (dest == null) {
            return null;
        }
        IEnderDestination out = dest.getOutput(requireLoaded);
        if (requireLoaded && out == null && !dest.isInvalid) {
            return new IEnderDestination(){

                @Override
                public String getChannelString() {
                    return channel;
                }

                @Override
                public int getFrequency() {
                    return frequency;
                }

                @Override
                public boolean setFrequency(int frequency2) {
                    return false;
                }

                @Override
                public boolean clearFrequency() {
                    return false;
                }

                @Override
                public boolean isNotValid() {
                    return true;
                }

                @Override
                public int x() {
                    return dest.x;
                }

                @Override
                public int y() {
                    return dest.y;
                }

                @Override
                public int z() {
                    return dest.z;
                }

                @Override
                public int dimension() {
                    return dest.dimension;
                }

                @Override
                public int getDestination() {
                    return -1;
                }

                @Override
                public boolean setDestination(int frequency2) {
                    return false;
                }

                @Override
                public boolean clearDestination() {
                    return false;
                }
            };
        }
        return out;
    }

    private <T extends IEnderAttuned> boolean addHandler(HashMap<String, TIntObjectHashMap<ArrayHashList<T>>> map, T theAttuned) {
        int freq;
        ArrayHashList<T> array;
        String channel = theAttuned.getChannelString();
        TIntObjectHashMap list = map.get(channel);
        if (list == null) {
            list = new TIntObjectHashMap();
            map.put(channel, list);
        }
        if ((array = (ArrayHashList<T>)list.get(freq = theAttuned.getFrequency())) == null) {
            array = new ArrayHashList<T>();
            list.put(freq, array);
        }
        return array.add(theAttuned);
    }

    public void addItemHandler(IEnderItemHandler theAttuned) {
        if (theAttuned.canSendItems()) {
            this.addHandler(this.inputItem, theAttuned);
        }
        if (theAttuned.canReceiveItems()) {
            this.addHandler(this.outputItem, theAttuned);
        }
    }

    public void addFluidHandler(IEnderFluidHandler theAttuned) {
        if (theAttuned.canSendFluid()) {
            this.addHandler(this.inputFluid, theAttuned);
        }
        if (theAttuned.canReceiveFluid()) {
            this.addHandler(this.outputFluid, theAttuned);
        }
    }

    public void addEnergyHandler(IEnderEnergyHandler theAttuned) {
        if (theAttuned.canSendEnergy()) {
            this.addHandler(this.inputEnergy, theAttuned);
        }
        if (theAttuned.canReceiveEnergy()) {
            this.addHandler(this.outputEnergy, theAttuned);
        }
    }

    public void addDestination(IEnderDestination theAttuned) {
        if (!this.hasDestination(theAttuned, false)) {
            String channel = theAttuned.getChannelString();
            TIntObjectHashMap map = this.outputTeleport.get(channel);
            if (map == null) {
                map = new TIntObjectHashMap();
                this.outputTeleport.put(channel, (TIntObjectHashMap<EnderDestination>)map);
            }
            int freq = theAttuned.getFrequency();
            EnderDestination dest = new EnderDestination(theAttuned);
            map.put(freq, (Object)dest);
            this.linkConf.get(channel, String.valueOf(freq), "").set(dest.toString());
        }
    }

    private <T> boolean removeHandler(HashMap<String, TIntObjectHashMap<ArrayHashList<T>>> map, IEnderAttuned theAttuned) {
        TIntObjectHashMap<ArrayHashList<T>> list = map.get(theAttuned.getChannelString());
        if (list == null) {
            return false;
        }
        ArrayHashList array = (ArrayHashList)list.get(theAttuned.getFrequency());
        if (array == null) {
            return false;
        }
        return array.remove(theAttuned);
    }

    public void removeItemHandler(IEnderItemHandler theAttuned) {
        this.removeHandler(this.inputItem, theAttuned);
        this.removeHandler(this.outputItem, theAttuned);
    }

    public void removeFluidHandler(IEnderFluidHandler theAttuned) {
        this.removeHandler(this.inputFluid, theAttuned);
        this.removeHandler(this.outputFluid, theAttuned);
    }

    public void removeEnergyHandler(IEnderEnergyHandler theAttuned) {
        this.removeHandler(this.inputEnergy, theAttuned);
        this.removeHandler(this.outputEnergy, theAttuned);
    }

    public void removeDestination(IEnderDestination theAttuned) {
        String channel = theAttuned.getChannelString();
        TIntObjectHashMap<EnderDestination> map = this.outputTeleport.get(channel);
        if (map == null) {
            return;
        }
        EnderDestination dest = (EnderDestination)map.get(theAttuned.getFrequency());
        if (dest == null) {
            return;
        }
        if (dest.dimension == theAttuned.dimension() && dest.x == theAttuned.x() && dest.y == theAttuned.y() && dest.z == theAttuned.z()) {
            int freq = theAttuned.getFrequency();
            map.remove(freq);
            this.linkConf.getCategory(channel).remove((Object)String.valueOf(freq));
        }
    }

    public void add(IEnderAttuned theAttuned) {
        if (theAttuned instanceof IEnderItemHandler) {
            this.addItemHandler((IEnderItemHandler)theAttuned);
        }
        if (theAttuned instanceof IEnderFluidHandler) {
            this.addFluidHandler((IEnderFluidHandler)theAttuned);
        }
        if (theAttuned instanceof IEnderEnergyHandler) {
            this.addEnergyHandler((IEnderEnergyHandler)theAttuned);
        }
        if (theAttuned instanceof IEnderDestination) {
            this.addDestination((IEnderDestination)theAttuned);
        }
    }

    public void remove(IEnderAttuned theAttuned) {
        if (theAttuned instanceof IEnderItemHandler) {
            this.removeItemHandler((IEnderItemHandler)theAttuned);
        }
        if (theAttuned instanceof IEnderFluidHandler) {
            this.removeFluidHandler((IEnderFluidHandler)theAttuned);
        }
        if (theAttuned instanceof IEnderEnergyHandler) {
            this.removeEnergyHandler((IEnderEnergyHandler)theAttuned);
        }
        if (theAttuned instanceof IEnderDestination) {
            this.removeDestination((IEnderDestination)theAttuned);
        }
    }

    private static class EnderDestination {
        private final int dimension;
        private final int x;
        private final int y;
        private final int z;
        private IEnderDestination output;
        private boolean isInvalid;

        public EnderDestination(IEnderDestination output) {
            this.x = output.x();
            this.y = output.y();
            this.z = output.z();
            this.dimension = output.dimension();
            this.output = output;
        }

        private EnderDestination(int x, int y, int z, int dimension) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.dimension = dimension;
        }

        public boolean hasOutput() {
            return !this.isInvalid && DimensionManager.isDimensionRegistered((int)this.dimension);
        }

        public IEnderDestination getOutput(boolean onlyLoaded) {
            if (this.output == null || this.output.isNotValid()) {
                this.output = null;
                if (!DimensionManager.isDimensionRegistered((int)this.dimension)) {
                    return null;
                }
                WorldServer world = DimensionManager.getWorld((int)this.dimension);
                if (world != null || onlyLoaded) {
                    return null;
                }
                DimensionManager.initDimension((int)this.dimension);
                world = DimensionManager.getWorld((int)this.dimension);
                if (!onlyLoaded || world.func_72899_e(this.x, this.y, this.z)) {
                    TileEntity te = world.func_147438_o(this.x, this.y, this.z);
                    if (te instanceof IEnderDestination) {
                        this.output = (IEnderDestination)te;
                    } else {
                        this.isInvalid = true;
                    }
                }
            }
            return this.output;
        }

        public String toString() {
            return String.format("%s@%s,%s,%s", this.dimension, this.x, this.y, this.z);
        }

        public int hashCode() {
            return this.dimension ^ this.y + this.x * (this.z * 100);
        }

        public boolean equals(Object o) {
            if (o == null || o.getClass() != EnderDestination.class) {
                return false;
            }
            EnderDestination other = (EnderDestination)o;
            return other.x == this.x && other.y == this.y && other.z == this.z && other.dimension == this.dimension;
        }
    }
}

