/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.network;

import io.netty.buffer.ByteBuf;

public final class ByteBufHelper {
    public static int readVarInt(ByteBuf data) {
        byte b;
        int r = 0;
        int i = 0;
        do {
            b = data.readByte();
            r |= (b & 0x7F) << i++ * 7;
            if (i <= 5) continue;
            throw new RuntimeException("VarInt too big");
        } while ((b & 0x80) == 128);
        return r;
    }

    public static void writeVarInt(int in, ByteBuf out) {
        if (in == 0) {
            out.writeByte(0);
        }
        while (in != 0) {
            out.writeByte(in & 0x7F | ((in & 0xFFFFFF80) != 0 ? 128 : 0));
            in >>>= 7;
        }
    }

    public static String readString(ByteBuf data) {
        int c;
        int count;
        int utflen = ByteBufHelper.readVarInt(data);
        byte[] bytearr = null;
        char[] chararr = null;
        bytearr = new byte[utflen];
        chararr = new char[utflen];
        int chararr_count = 0;
        data.readBytes(bytearr, 0, utflen);
        for (count = 0; count < utflen && (c = bytearr[count] & 0xFF) <= 127; ++count) {
            chararr[chararr_count++] = (char)c;
        }
        block6: while (count < utflen) {
            c = bytearr[count] & 0xFF;
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++count;
                    chararr[chararr_count++] = (char)c;
                    continue block6;
                }
                case 12: 
                case 13: {
                    if ((count += 2) > utflen) {
                        throw new IllegalArgumentException("malformed input: partial character at end");
                    }
                    byte char2 = bytearr[count - 1];
                    if ((char2 & 0xC0) != 128) {
                        throw new IllegalArgumentException("malformed input around byte " + count);
                    }
                    chararr[chararr_count++] = (char)((c & 0x1F) << 6 | char2 & 0x3F);
                    continue block6;
                }
                case 14: {
                    if ((count += 3) > utflen) {
                        throw new IllegalArgumentException("malformed input: partial character at end");
                    }
                    byte char2 = bytearr[count - 2];
                    byte char3 = bytearr[count - 1];
                    if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                        throw new IllegalArgumentException("malformed input around byte " + (count - 1));
                    }
                    chararr[chararr_count++] = (char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | (char3 & 0x3F) << 0);
                    continue block6;
                }
            }
            throw new IllegalArgumentException("malformed input around byte " + count);
        }
        return new String(chararr, 0, chararr_count);
    }

    public static void writeString(String str, ByteBuf out) {
        int i;
        char c;
        int strlen = str.length();
        int utflen = 0;
        int count = 0;
        boolean hasLarge = false;
        for (int i2 = 0; i2 < strlen; ++i2) {
            c = str.charAt(i2);
            if (c >= '\u0001' && c <= '\u007f') {
                ++utflen;
                continue;
            }
            if (c > '\u07ff') {
                utflen += 3;
                hasLarge = true;
                continue;
            }
            utflen += 2;
            hasLarge = true;
        }
        if (utflen < 0) {
            throw new IllegalArgumentException("encoded string too long: " + utflen + " bytes");
        }
        byte[] bytearr = new byte[utflen];
        ByteBufHelper.writeVarInt(utflen, out);
        if (!hasLarge) {
            for (i = 0; i < strlen; ++i) {
                bytearr[count++] = (byte)str.charAt(i);
            }
        }
        while (i < strlen) {
            c = str.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                bytearr[count++] = (byte)c;
            } else if (c > '\u07ff') {
                bytearr[count++] = (byte)(0xE0 | c >> 12 & 0xF);
                bytearr[count++] = (byte)(0x80 | c >> 6 & 0x3F);
                bytearr[count++] = (byte)(0x80 | c >> 0 & 0x3F);
            } else {
                bytearr[count++] = (byte)(0xC0 | c >> 6 & 0x1F);
                bytearr[count++] = (byte)(0x80 | c >> 0 & 0x3F);
            }
            ++i;
        }
        out.writeBytes(bytearr);
    }
}

