/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.gui.element;

import cofh.lib.gui.GuiBase;
import cofh.lib.gui.GuiColor;
import cofh.lib.gui.element.ElementBase;
import cofh.lib.gui.element.ElementButtonBase;
import org.lwjgl.opengl.GL11;

public abstract class ElementSlider
extends ElementBase {
    protected int _value;
    protected int _valueMin;
    protected int _valueMax;
    protected int _sliderWidth;
    protected int _sliderHeight;
    protected boolean _isDragging;
    public int borderColor = new GuiColor(120, 120, 120, 255).getColor();
    public int backgroundColor = new GuiColor(0, 0, 0, 255).getColor();

    protected ElementSlider(GuiBase containerScreen, int x, int y, int width, int height, int maxValue) {
        this(containerScreen, x, y, width, height, maxValue, 0);
    }

    protected ElementSlider(GuiBase containerScreen, int x, int y, int width, int height, int maxValue, int minValue) {
        super(containerScreen, x, y, width, height);
        this._valueMax = maxValue;
        this._valueMin = minValue;
    }

    public ElementSlider setColor(int backgroundColor, int borderColor) {
        this.borderColor = borderColor;
        this.backgroundColor = backgroundColor;
        return this;
    }

    public ElementSlider setSliderSize(int width, int height) {
        this._sliderWidth = width;
        this._sliderHeight = height;
        return this;
    }

    public ElementSlider setValue(int value) {
        if ((value = Math.max(this._valueMin, Math.min(this._valueMax, value))) != this._value) {
            this._value = value;
            this.onValueChanged(this._value);
        }
        return this;
    }

    public ElementSlider setLimits(int min, int max) {
        this._valueMin = min;
        this._valueMax = max;
        this.setValue(this._value);
        return this;
    }

    @Override
    public void drawBackground(int mouseX, int mouseY, float gameTicks) {
        this.drawModalRect(this.posX - 1, this.posY - 1, this.posX + this.sizeX + 1, this.posY + this.sizeY + 1, this.borderColor);
        this.drawModalRect(this.posX, this.posY, this.posX + this.sizeX, this.posY + this.sizeY, this.backgroundColor);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    protected void drawSlider(int mouseX, int mouseY, int sliderX, int sliderY) {
        int sliderMidX = this._sliderWidth / 2;
        int sliderMidY = this._sliderHeight / 2;
        int sliderEndX = this._sliderWidth - sliderMidX;
        int sliderEndY = this._sliderHeight - sliderMidY;
        if (!this.isEnabled()) {
            this.gui.bindTexture(ElementButtonBase.DISABLED);
        } else if (this.isHovering(mouseX, mouseY)) {
            this.gui.bindTexture(ElementButtonBase.HOVER);
        } else {
            this.gui.bindTexture(ElementButtonBase.ENABLED);
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.drawTexturedModalRect(sliderX, sliderY, 0, 0, sliderMidX, sliderMidY);
        this.drawTexturedModalRect(sliderX, sliderY + sliderMidY, 0, 256 - sliderEndY, sliderMidX, sliderEndY);
        this.drawTexturedModalRect(sliderX + sliderMidX, sliderY, 256 - sliderEndX, 0, sliderEndX, sliderMidY);
        this.drawTexturedModalRect(sliderX + sliderMidX, sliderY + sliderMidY, 256 - sliderEndX, 256 - sliderEndY, sliderEndX, sliderEndY);
    }

    @Override
    public void drawForeground(int mouseX, int mouseY) {
        int sliderX = this.posX + this.getSliderX();
        int sliderY = this.posY + this.getSliderY();
        this.drawSlider(mouseX, mouseY, sliderX, sliderY);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    protected boolean isHovering(int x, int y) {
        return this.intersectsWith(x, y);
    }

    public int getSliderX() {
        return 0;
    }

    public int getSliderY() {
        return 0;
    }

    @Override
    public boolean onMousePressed(int mouseX, int mouseY, int mouseButton) {
        this._isDragging = mouseButton == 0;
        this.update(mouseX, mouseY);
        return true;
    }

    @Override
    public void onMouseReleased(int mouseX, int mouseY) {
        if (this._isDragging) {
            this.onStopDragging();
        }
        this._isDragging = false;
    }

    @Override
    public void update(int mouseX, int mouseY) {
        if (this._isDragging) {
            this.dragSlider(mouseX - this.posX, mouseY - this.posY);
        }
    }

    protected abstract void dragSlider(int var1, int var2);

    @Override
    public boolean onMouseWheel(int mouseX, int mouseY, int movement) {
        if (movement > 0) {
            this.setValue(this._value - 1);
        } else if (movement < 0) {
            this.setValue(this._value + 1);
        }
        return true;
    }

    public void onValueChanged(int value) {
    }

    public void onStopDragging() {
    }

    public int getValue() {
        return this._value;
    }
}

