/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.util.potions;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import lib.enderwizards.sandstone.mod.config.ConfigReference;
import lib.enderwizards.sandstone.util.ContentHelper;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import org.apache.commons.lang3.math.NumberUtils;
import xreliquary.Reliquary;
import xreliquary.init.XRRecipes;
import xreliquary.items.ItemPotionEssence;
import xreliquary.util.potions.PotionEssence;
import xreliquary.util.potions.PotionIngredient;
import xreliquary.util.potions.XRPotionHelper;

public class PotionMap {
    private static List<PotionIngredient> ingredientsMap = new ArrayList<PotionIngredient>();
    private static TreeMap<String, List<String>> configList = new TreeMap();

    public static void init() {
        PotionMap.addPotionConfig(Items.field_151102_aT, PotionMap.speed(3, 0), PotionMap.haste(3, 0));
        PotionMap.addPotionConfig(Items.field_151034_e, PotionMap.heal(0), PotionMap.hboost(3, 0));
        PotionMap.addPotionConfig(Items.field_151044_h, PotionMap.blind(1, 0), PotionMap.absorb(3, 0));
        PotionMap.addPotionConfig(Items.field_151044_h, 1, PotionMap.invis(1, 0), PotionMap.wither(0, 0));
        PotionMap.addPotionConfig(Items.field_151008_G, PotionMap.jump(3, 0), PotionMap.weak(1, 0));
        PotionMap.addPotionConfig(Items.field_151014_N, PotionMap.harm(0), PotionMap.hboost(3, 0));
        PotionMap.addPotionConfig(Items.field_151015_O, PotionMap.heal(0), PotionMap.hboost(3, 0));
        PotionMap.addPotionConfig(Items.field_151145_ak, PotionMap.harm(0), PotionMap.dboost(3, 0));
        PotionMap.addPotionConfig(Items.field_151147_al, PotionMap.slow(1, 0), PotionMap.fatigue(1, 0));
        PotionMap.addPotionConfig(Items.field_151116_aA, PotionMap.resist(3, 0), PotionMap.absorb(3, 0));
        PotionMap.addPotionConfig(Items.field_151119_aD, PotionMap.slow(1, 0), PotionMap.hboost(3, 0));
        PotionMap.addPotionConfig(Items.field_151110_aK, PotionMap.absorb(3, 0), PotionMap.regen(0, 0));
        PotionMap.addPotionConfig(Items.field_151100_aR, 1, PotionMap.heal(0), PotionMap.hboost(3, 0));
        PotionMap.addPotionConfig(Items.field_151100_aR, 11, PotionMap.jump(3, 0), PotionMap.weak(1, 0));
        PotionMap.addPotionConfig(Items.field_151100_aR, 2, PotionMap.resist(3, 0), PotionMap.absorb(3, 0));
        PotionMap.addPotionConfig(Items.field_151100_aR, 15, PotionMap.weak(1, 0), PotionMap.fatigue(1, 0));
        PotionMap.addPotionConfig(Items.field_151080_bb, PotionMap.invis(1, 0), PotionMap.fireres(1, 0));
        PotionMap.addPotionConfig(Items.field_151082_bd, PotionMap.slow(1, 0), PotionMap.satur(0));
        PotionMap.addPotionConfig(Items.field_151076_bf, PotionMap.nausea(1, 0), PotionMap.poison(1, 0));
        PotionMap.addPotionConfig(Items.field_151078_bh, PotionMap.nausea(1, 0), PotionMap.hunger(1, 0), PotionMap.wither(0, 0));
        PotionMap.addPotionConfig(Items.field_151074_bl, PotionMap.dboost(0, 0), PotionMap.haste(0, 0));
        PotionMap.addPotionConfig(Items.field_151172_bF, PotionMap.vision(3, 0), PotionMap.hboost(3, 0));
        PotionMap.addPotionConfig(Items.field_151174_bG, PotionMap.hboost(3, 0), PotionMap.satur(0));
        PotionMap.addPotionConfig(Items.field_151115_aP, PotionMap.satur(0), PotionMap.breath(1, 0));
        PotionMap.addPotionConfig(Items.field_151070_bp, PotionMap.vision(4, 0), PotionMap.poison(2, 0));
        PotionMap.addPotionConfig(Items.field_151065_br, PotionMap.dboost(4, 0), PotionMap.harm(0));
        PotionMap.addPotionConfig(Items.field_151042_j, PotionMap.resist(4, 0), PotionMap.slow(2, 0));
        PotionMap.addPotionConfig(Items.field_151007_F, PotionMap.slow(2, 0), PotionMap.fatigue(2, 0));
        PotionMap.addPotionConfig(Items.field_151025_P, PotionMap.hboost(4, 0), PotionMap.satur(0));
        PotionMap.addPotionConfig(Items.field_151157_am, PotionMap.fatigue(2, 0), PotionMap.satur(0));
        PotionMap.addPotionConfig(Items.field_151123_aH, PotionMap.resist(4, 0), PotionMap.fireres(2, 0));
        PotionMap.addPotionConfig(Items.field_151101_aQ, PotionMap.satur(0), PotionMap.breath(2, 0));
        PotionMap.addPotionConfig(Items.field_151100_aR, 4, PotionMap.haste(4, 0), PotionMap.dboost(4, 0));
        PotionMap.addPotionConfig(Items.field_151100_aR, 0, PotionMap.blind(2, 0), PotionMap.invis(2, 0));
        PotionMap.addPotionConfig(Items.field_151103_aS, PotionMap.weak(2, 0), PotionMap.fatigue(2, 0));
        PotionMap.addPotionConfig(Items.field_151106_aX, PotionMap.heal(0), PotionMap.satur(0));
        PotionMap.addPotionConfig(Items.field_151127_ba, PotionMap.heal(0), PotionMap.speed(4, 0));
        PotionMap.addPotionConfig(Items.field_151083_be, PotionMap.resist(4, 0), PotionMap.satur(0));
        PotionMap.addPotionConfig(Items.field_151077_bg, PotionMap.jump(4, 0), PotionMap.satur(0));
        PotionMap.addPotionConfig(Items.field_151168_bH, PotionMap.satur(0), PotionMap.regen(1, 0));
        PotionMap.addPotionConfig(Items.field_151170_bI, PotionMap.poison(2, 0), PotionMap.wither(1, 0));
        PotionMap.addPotionConfig(Items.field_151128_bU, PotionMap.harm(0), PotionMap.dboost(4, 0));
        PotionMap.addPotionConfig(XRRecipes.zombieHeart(), PotionMap.nausea(2, 0), PotionMap.hunger(2, 0), PotionMap.wither(1, 0));
        PotionMap.addPotionConfig(XRRecipes.squidBeak(), PotionMap.hunger(2, 0), PotionMap.breath(2, 0));
        PotionMap.addPotionConfig(Items.field_151158_bO, PotionMap.invis(1, 0), PotionMap.fireres(1, 0), PotionMap.speed(3, 0), PotionMap.haste(3, 0), PotionMap.absorb(3, 0), PotionMap.regen(0, 0));
        PotionMap.addPotionConfig(Items.field_151064_bs, PotionMap.dboost(4, 0), PotionMap.harm(0), PotionMap.resist(4, 0), PotionMap.fireres(2, 0));
        PotionMap.addPotionConfig(Items.field_151060_bw, PotionMap.dboost(3, 0), PotionMap.haste(3, 0), PotionMap.heal(0), PotionMap.speed(4, 0));
        PotionMap.addPotionConfig(Items.field_151073_bk, PotionMap.regen(3, 0), PotionMap.absorb(5, 0));
        PotionMap.addPotionConfig(Items.field_151071_bq, PotionMap.vision(4, 0), PotionMap.poison(2, 0), PotionMap.speed(3, 0), PotionMap.haste(3, 0));
        PotionMap.addPotionConfig(Items.field_151150_bK, PotionMap.dboost(3, 0), PotionMap.haste(3, 0), PotionMap.hboost(3, 0), PotionMap.vision(3, 0));
        PotionMap.addPotionConfig(Items.field_151043_k, PotionMap.dboost(4, 0), PotionMap.haste(4, 0));
        PotionMap.addPotionConfig(XRRecipes.ribBone(), PotionMap.weak(3, 0), PotionMap.fatigue(3, 0));
        PotionMap.addPotionConfig(Items.field_151079_bi, PotionMap.invis(5, 0), PotionMap.speed(5, 0));
        PotionMap.addPotionConfig(Items.field_151072_bj, PotionMap.dboost(8, 0), PotionMap.harm(0));
        PotionMap.addPotionConfig(Items.field_151059_bz, PotionMap.dboost(4, 0), PotionMap.harm(0), PotionMap.blind(1, 0), PotionMap.absorb(3, 0));
        PotionMap.addPotionConfig(XRRecipes.creeperGland(), PotionMap.regen(3, 0), PotionMap.hboost(5, 0));
        PotionMap.addPotionConfig(XRRecipes.spiderFangs(), PotionMap.poison(3, 0), PotionMap.weak(3, 0));
        PotionMap.addPotionConfig(XRRecipes.slimePearl(), PotionMap.resist(5, 0), PotionMap.absorb(5, 0));
        PotionMap.addPotionConfig(XRRecipes.shellFragment(), PotionMap.absorb(5, 0), PotionMap.breath(5, 0));
        PotionMap.addPotionConfig(XRRecipes.batWing(), PotionMap.jump(5, 0), PotionMap.weak(3, 0));
        PotionMap.addPotionConfig(Items.field_151045_i, PotionMap.resist(6, 1), PotionMap.absorb(6, 1), PotionMap.fireres(6, 0));
        PotionMap.addPotionConfig(XRRecipes.witherRib(), PotionMap.wither(2, 1), PotionMap.weak(3, 1), PotionMap.slow(3, 1), PotionMap.fatigue(3, 1));
        PotionMap.addPotionConfig(Items.field_151061_bv, PotionMap.dboost(6, 1), PotionMap.invis(6, 0), PotionMap.speed(6, 1), PotionMap.harm(1));
        PotionMap.addPotionConfig(Items.field_151166_bC, PotionMap.haste(6, 1), PotionMap.speed(6, 1), PotionMap.hboost(6, 1));
        PotionMap.addPotionConfig(Items.field_151156_bN, PotionMap.hboost(24, 1), PotionMap.regen(24, 1), PotionMap.absorb(24, 1));
        PotionMap.addPotionConfig(XRRecipes.moltenCore(), PotionMap.dboost(6, 1), PotionMap.fireres(6, 0), PotionMap.harm(1));
        PotionMap.addPotionConfig(XRRecipes.stormEye(), PotionMap.haste(24, 1), PotionMap.speed(24, 1), PotionMap.jump(24, 1), PotionMap.harm(1));
        PotionMap.addPotionConfig(XRRecipes.fertileEssence(), PotionMap.hboost(8, 1), PotionMap.regen(3, 1), PotionMap.heal(1), PotionMap.satur(1), PotionMap.weak(9, 1), PotionMap.fatigue(9, 1));
        PotionMap.addPotionConfig(XRRecipes.frozenCore(), PotionMap.absorb(6, 1), PotionMap.slow(3, 1), PotionMap.fatigue(3, 1), PotionMap.harm(1), PotionMap.fireres(6, 0));
        PotionMap.addPotionConfig(XRRecipes.enderHeart(), PotionMap.vision(6, 0), PotionMap.invis(6, 0), PotionMap.harm(1), PotionMap.hboost(6, 1), PotionMap.dboost(6, 1), PotionMap.speed(6, 1), PotionMap.haste(6, 1));
        PotionMap.addPotionConfig(XRRecipes.infernalClaw(), PotionMap.harm(1), PotionMap.resist(6, 1), PotionMap.fireres(6, 0), PotionMap.dboost(6, 1), PotionMap.satur(1), PotionMap.heal(1));
        Set<String> orderedSet = configList.keySet();
        for (String key : orderedSet) {
            List<String> value = configList.get(key);
            Reliquary.CONFIG.require("potion_ingredient", key, new ConfigReference(value));
        }
    }

    public static String harm(int potency) {
        return PotionMap.effectString("harm", Integer.toString(0), Integer.toString(potency));
    }

    public static String heal(int potency) {
        return PotionMap.effectString("heal", Integer.toString(0), Integer.toString(potency));
    }

    public static String satur(int potency) {
        return PotionMap.effectString("saturation", Integer.toString(0), Integer.toString(potency));
    }

    public static String invis(int duration, int potency) {
        return PotionMap.effectString("invisibility", Integer.toString(duration), Integer.toString(potency));
    }

    public static String absorb(int duration, int potency) {
        return PotionMap.effectString("absorption", Integer.toString(duration), Integer.toString(potency));
    }

    public static String hboost(int duration, int potency) {
        return PotionMap.effectString("healthBoost", Integer.toString(duration), Integer.toString(potency));
    }

    public static String dboost(int duration, int potency) {
        return PotionMap.effectString("damageBoost", Integer.toString(duration), Integer.toString(potency));
    }

    public static String speed(int duration, int potency) {
        return PotionMap.effectString("moveSpeed", Integer.toString(duration), Integer.toString(potency));
    }

    public static String haste(int duration, int potency) {
        return PotionMap.effectString("digSpeed", Integer.toString(duration), Integer.toString(potency));
    }

    public static String slow(int duration, int potency) {
        return PotionMap.effectString("moveSlowdown", Integer.toString(duration), Integer.toString(potency));
    }

    public static String fatigue(int duration, int potency) {
        return PotionMap.effectString("digSlowDown", Integer.toString(duration), Integer.toString(potency));
    }

    public static String breath(int duration, int potency) {
        return PotionMap.effectString("waterBreathing", Integer.toString(duration), Integer.toString(potency));
    }

    public static String vision(int duration, int potency) {
        return PotionMap.effectString("nightVision", Integer.toString(duration), Integer.toString(potency));
    }

    public static String resist(int duration, int potency) {
        return PotionMap.effectString("resistance", Integer.toString(duration), Integer.toString(potency));
    }

    public static String fireres(int duration, int potency) {
        return PotionMap.effectString("fireResistance", Integer.toString(duration), Integer.toString(potency));
    }

    public static String weak(int duration, int potency) {
        return PotionMap.effectString("weakness", Integer.toString(duration), Integer.toString(potency));
    }

    public static String jump(int duration, int potency) {
        return PotionMap.effectString("jump", Integer.toString(duration), Integer.toString(potency));
    }

    public static String nausea(int duration, int potency) {
        return PotionMap.effectString("confusion", Integer.toString(duration), Integer.toString(potency));
    }

    public static String hunger(int duration, int potency) {
        return PotionMap.effectString("hunger", Integer.toString(duration), Integer.toString(potency));
    }

    public static String regen(int duration, int potency) {
        return PotionMap.effectString("regeneration", Integer.toString(duration), Integer.toString(potency));
    }

    public static String poison(int duration, int potency) {
        return PotionMap.effectString("poison", Integer.toString(duration), Integer.toString(potency));
    }

    public static String wither(int duration, int potency) {
        return PotionMap.effectString("wither", Integer.toString(duration), Integer.toString(potency));
    }

    public static String blind(int duration, int potency) {
        return PotionMap.effectString("blindness", Integer.toString(duration), Integer.toString(potency));
    }

    public static String effectString(String name, String duration, String potency) {
        return name + "_" + duration + "_" + potency;
    }

    private static void addPotionConfig(Item item, String ... params) {
        PotionMap.addPotionConfig(item, 0, params);
    }

    private static void addPotionConfig(Item item, int meta, String ... params) {
        PotionMap.addPotionConfig(new ItemStack(item, 1, meta), params);
    }

    private static void addPotionConfig(ItemStack ist, String ... params) {
        ArrayList<String> ingredientEffects = new ArrayList<String>();
        for (String effect : params) {
            ingredientEffects.add(effect);
        }
        configList.put(ContentHelper.getIdent((Item)ist.func_77973_b()).replace(':', '_') + (ist.func_77960_j() == 0 ? "" : "_" + ist.func_77960_j()), ingredientEffects);
    }

    public static void initializePotionMappings() {
        Set configIngredients = Reliquary.CONFIG.getGroup("potion_ingredient").entrySet();
        for (Map.Entry configIngredient : configIngredients) {
            String key = (String)configIngredient.getKey();
            int meta = 0;
            String[] splitKey = key.split("_");
            if (NumberUtils.isNumber((String)splitKey[splitKey.length - 1])) {
                meta = Integer.parseInt(splitKey[splitKey.length - 1]);
                key = "";
                for (int i = 0; i < splitKey.length - 1; ++i) {
                    key = key + splitKey[i];
                    if (i >= splitKey.length - 2) continue;
                    key = key + "_";
                }
            }
            splitKey = key.split("_", 2);
            Item item = Reliquary.CONTENT.getItem(splitKey[0] + ":" + splitKey[1]);
            List effectList = (List)configIngredient.getValue();
            PotionIngredient ingredient = new PotionIngredient(item, meta);
            for (String effect : effectList) {
                String potionName = effect.split("_")[0];
                int durationWeight = Integer.parseInt(effect.split("_")[1]);
                int ampWeight = Integer.parseInt(effect.split("_")[2]);
                ingredient.addEffect(XRPotionHelper.getPotionIdByName(potionName), durationWeight, ampWeight);
            }
            ingredientsMap.add(ingredient);
        }
    }

    public static List<PotionIngredient> getIngredients() {
        return ingredientsMap;
    }

    public static PotionIngredient getIngredient(ItemStack ist) {
        if (ist.func_77973_b() instanceof ItemPotionEssence) {
            return new PotionEssence(ist.func_77978_p());
        }
        for (PotionIngredient ingredient : ingredientsMap) {
            if (!ingredient.itemName.equals(ist.func_77973_b().func_77657_g(ist))) continue;
            return ingredient;
        }
        return null;
    }
}

