/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.util.potions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import lib.enderwizards.sandstone.util.misc.Duo;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import xreliquary.util.potions.PotionIngredient;

public class PotionEssence
extends PotionIngredient {
    public static int MAX_DURATION = 30000;

    public PotionEssence(NBTTagCompound tag) {
        if (tag == null) {
            return;
        }
        for (int tagIndex = 0; tagIndex < tag.func_150295_c("effects", 10).func_74745_c(); ++tagIndex) {
            NBTTagCompound effect = tag.func_150295_c("effects", 10).func_150305_b(tagIndex);
            this.effects.add(new PotionEffect(effect.func_74762_e("id"), effect.func_74762_e("duration"), effect.func_74762_e("potency")));
        }
    }

    public PotionEssence(PotionIngredient ... ingredients) {
        ArrayList<Integer> potionEffectCounterList = new ArrayList<Integer>();
        ArrayList<Integer> potionEffectList = new ArrayList<Integer>();
        HashMap<Integer, Duo> mergedPotionEffects = new HashMap<Integer, Duo>();
        for (PotionIngredient ingredient : ingredients) {
            for (PotionEffect effect : ingredient.getEffects()) {
                if (potionEffectCounterList.contains(effect.func_76456_a())) {
                    potionEffectList.add(effect.func_76456_a());
                    continue;
                }
                potionEffectCounterList.add(effect.func_76456_a());
            }
        }
        for (PotionIngredient ingredient : ingredients) {
            for (PotionEffect effect : ingredient.getEffects()) {
                if (!potionEffectList.contains(effect.func_76456_a())) continue;
                if (mergedPotionEffects.containsKey(effect.func_76456_a())) {
                    int duration = Math.min(MAX_DURATION, Potion.field_76425_a[effect.func_76456_a()].func_76403_b() ? 1 : (Integer)((Duo)mergedPotionEffects.get((Object)Integer.valueOf((int)effect.func_76456_a()))).one);
                    if (duration == 0) continue;
                    int amp = (Integer)((Duo)mergedPotionEffects.get((Object)Integer.valueOf((int)effect.func_76456_a()))).two;
                    Duo newWeight = new Duo((Object)((int)(((float)duration + (float)effect.func_76459_b()) / 1.2f)), (Object)Math.min(4, amp + effect.func_76458_c()));
                    mergedPotionEffects.remove(effect.func_76456_a());
                    mergedPotionEffects.put(effect.func_76456_a(), newWeight);
                    continue;
                }
                mergedPotionEffects.put(effect.func_76456_a(), new Duo((Object)effect.func_76459_b(), (Object)effect.func_76458_c()));
            }
        }
        for (Map.Entry pair : mergedPotionEffects.entrySet()) {
            this.effects.add(new PotionEffect(((Integer)pair.getKey()).intValue(), Potion.field_76425_a[(Integer)pair.getKey()].func_76403_b() ? 1 : (Integer)((Duo)pair.getValue()).one, ((Integer)((Duo)pair.getValue()).two).intValue()));
        }
    }

    public NBTTagCompound writeToNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        if (tag.func_150295_c("effects", 10) == null) {
            return null;
        }
        NBTTagList effectList = tag.func_150295_c("effects", 10);
        for (PotionEffect object : this.effects) {
            NBTTagCompound effect = new NBTTagCompound();
            effect.func_74768_a("id", object.func_76456_a());
            effect.func_74768_a("duration", Potion.field_76425_a[object.func_76456_a()].func_76403_b() ? 1 : object.func_76459_b());
            effect.func_74768_a("potency", object.func_76458_c());
            effectList.func_74742_a((NBTBase)effect);
        }
        tag.func_74782_a("effects", (NBTBase)effectList);
        return tag;
    }

    public void apply(EntityPlayer player) {
        for (PotionEffect effect : this.effects) {
            player.func_70690_d(effect);
        }
    }
}

