/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.items;

import com.google.common.collect.ImmutableMap;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import lib.enderwizards.sandstone.init.ContentInit;
import lib.enderwizards.sandstone.items.ItemToggleable;
import lib.enderwizards.sandstone.util.ContentHelper;
import lib.enderwizards.sandstone.util.InventoryHelper;
import lib.enderwizards.sandstone.util.LanguageHelper;
import lib.enderwizards.sandstone.util.NBTHelper;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.lwjgl.input.Keyboard;
import xreliquary.Reliquary;

@ContentInit
public class ItemSojournerStaff
extends ItemToggleable {
    public ItemSojournerStaff() {
        super("sojourner_staff");
        this.func_77637_a(Reliquary.CREATIVE_TAB);
        this.func_77625_d(1);
        this.canRepair = false;
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.epic;
    }

    public void func_77663_a(ItemStack ist, World world, Entity e, int i, boolean b) {
        if (world.field_72995_K) {
            return;
        }
        EntityPlayer player = null;
        if (e instanceof EntityPlayer) {
            player = (EntityPlayer)e;
        }
        if (player == null) {
            return;
        }
        if (this.isEnabled(ist)) {
            this.scanForMatchingTorchesToFillInternalStorage(ist, player);
        }
    }

    public boolean onEntitySwing(EntityLivingBase entityLiving, ItemStack ist) {
        if (entityLiving.field_70170_p.field_72995_K) {
            return false;
        }
        if (entityLiving.func_70093_af()) {
            this.cycleTorchMode(ist);
            return true;
        }
        return false;
    }

    private void scanForMatchingTorchesToFillInternalStorage(ItemStack ist, EntityPlayer player) {
        List torches = (List)Reliquary.CONFIG.get("sojourner_staff", "torches");
        ArrayList<Item> items = new ArrayList<Item>();
        ItemStack vanillaTorch = new ItemStack(Blocks.field_150478_aa, 1, 0);
        items.add(vanillaTorch.func_77973_b());
        for (String torch : torches) {
            if (items.contains(Reliquary.CONTENT.getItem(torch))) continue;
            items.add(Reliquary.CONTENT.getItem(torch));
        }
        for (Item item : items) {
            if (this.isInternalStorageFullOfItem(ist, item) || !InventoryHelper.consumeItem((Object)item, (EntityPlayer)player)) continue;
            this.addItemToInternalStorage(ist, item);
        }
    }

    private void addItemToInternalStorage(ItemStack ist, Item item) {
        NBTTagCompound tagCompound = NBTHelper.getTag((ItemStack)ist);
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
        }
        if (tagCompound.func_74781_a("Items") == null) {
            tagCompound.func_74782_a("Items", (NBTBase)new NBTTagList());
        }
        NBTTagList tagList = tagCompound.func_150295_c("Items", 10);
        boolean added = false;
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tagItemData = tagList.func_150305_b(i);
            String itemName = tagItemData.func_74779_i("Name");
            if (!itemName.equals(ContentHelper.getIdent((Item)item))) continue;
            int quantity = tagItemData.func_74762_e("Quantity");
            tagItemData.func_74768_a("Quantity", quantity + 1);
            added = true;
        }
        if (!added) {
            NBTTagCompound newTagData = new NBTTagCompound();
            newTagData.func_74778_a("Name", ContentHelper.getIdent((Item)item));
            newTagData.func_74768_a("Quantity", 1);
            tagList.func_74742_a((NBTBase)newTagData);
        }
        tagCompound.func_74782_a("Items", (NBTBase)tagList);
        NBTHelper.setTag((ItemStack)ist, (NBTTagCompound)tagCompound);
    }

    private boolean hasItemInInternalStorage(ItemStack ist, Item item, int cost) {
        NBTTagCompound tagCompound = NBTHelper.getTag((ItemStack)ist);
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
        }
        if (tagCompound.func_82582_d()) {
            tagCompound.func_74782_a("Items", (NBTBase)new NBTTagList());
            return false;
        }
        NBTTagList tagList = tagCompound.func_150295_c("Items", 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tagItemData = tagList.func_150305_b(i);
            String itemName = tagItemData.func_74779_i("Name");
            if (!itemName.equals(ContentHelper.getIdent((Item)item))) continue;
            int quantity = tagItemData.func_74762_e("Quantity");
            return quantity >= cost;
        }
        return false;
    }

    private boolean isInternalStorageFullOfItem(ItemStack ist, Item item) {
        if (this.hasItemInInternalStorage(ist, item, 1)) {
            NBTTagCompound tagCompound = NBTHelper.getTag((ItemStack)ist);
            NBTTagList tagList = tagCompound.func_150295_c("Items", 10);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                NBTTagCompound tagItemData = tagList.func_150305_b(i);
                String itemName = tagItemData.func_74779_i("Name");
                if (!itemName.equals(ContentHelper.getIdent((Item)item))) continue;
                int quantity = tagItemData.func_74762_e("Quantity");
                return quantity >= this.getTorchItemMaxCapacity();
            }
        }
        return false;
    }

    public String getTorchPlacementMode(ItemStack ist) {
        int quantity;
        String itemName;
        NBTTagCompound tagItemData;
        int i;
        if (NBTHelper.getTag((ItemStack)ist) == null) {
            return null;
        }
        NBTTagCompound tagCompound = NBTHelper.getTag((ItemStack)ist);
        String torchToPlace = tagCompound.func_74779_i("Torch");
        NBTTagList tagList = tagCompound.func_150295_c("Items", 10);
        if (torchToPlace != null) {
            for (i = 0; i < tagList.func_74745_c(); ++i) {
                tagItemData = tagList.func_150305_b(i);
                itemName = tagItemData.func_74779_i("Name");
                if (!itemName.equals(torchToPlace) || (quantity = tagItemData.func_74762_e("Quantity")) > 0) continue;
                torchToPlace = null;
            }
        }
        if (torchToPlace == null || torchToPlace.isEmpty()) {
            for (i = 0; i < tagList.func_74745_c(); ++i) {
                tagItemData = tagList.func_150305_b(i);
                itemName = tagItemData.func_74779_i("Name");
                quantity = tagItemData.func_74762_e("Quantity");
                if (quantity <= 0) continue;
                tagCompound.func_74778_a("Torch", itemName);
                return itemName;
            }
        }
        return torchToPlace;
    }

    public int getTorchCount(ItemStack ist) {
        int quantity;
        String itemName;
        NBTTagCompound tagItemData;
        int i;
        if (NBTHelper.getTag((ItemStack)ist) == null) {
            return 0;
        }
        NBTTagCompound tagCompound = NBTHelper.getTag((ItemStack)ist);
        String torchToPlace = tagCompound.func_74779_i("Torch");
        NBTTagList tagList = tagCompound.func_150295_c("Items", 10);
        if (torchToPlace != null) {
            for (i = 0; i < tagList.func_74745_c(); ++i) {
                tagItemData = tagList.func_150305_b(i);
                itemName = tagItemData.func_74779_i("Name");
                if (!itemName.equals(torchToPlace)) continue;
                quantity = tagItemData.func_74762_e("Quantity");
                if (quantity <= 0) {
                    torchToPlace = null;
                    continue;
                }
                return quantity;
            }
        }
        if (torchToPlace == null || torchToPlace.isEmpty()) {
            for (i = 0; i < tagList.func_74745_c(); ++i) {
                tagItemData = tagList.func_150305_b(i);
                itemName = tagItemData.func_74779_i("Name");
                quantity = tagItemData.func_74762_e("Quantity");
                if (quantity <= 0) continue;
                tagCompound.func_74778_a("Torch", itemName);
                return quantity;
            }
        }
        return 0;
    }

    private void cycleTorchMode(ItemStack ist) {
        String mode = this.getTorchPlacementMode(ist);
        if (mode == null || mode.isEmpty()) {
            return;
        }
        NBTTagCompound tagCompound = NBTHelper.getTag((ItemStack)ist);
        NBTTagList tagList = tagCompound.func_150295_c("Items", 10);
        boolean itemFound = false;
        String firstItem = null;
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tagItemData = tagList.func_150305_b(i);
            String itemName = tagItemData.func_74779_i("Name");
            int quantity = tagItemData.func_74762_e("Quantity");
            if (quantity <= 0) continue;
            if (firstItem == null) {
                firstItem = itemName;
            }
            if (itemFound) {
                tagCompound.func_74778_a("Torch", itemName);
                return;
            }
            if (itemName.equals(mode)) {
                itemFound = true;
            }
            if (i != tagList.func_74745_c() - 1) continue;
            tagCompound.func_74778_a("Torch", firstItem);
        }
    }

    private int getTorchItemMaxCapacity() {
        return Reliquary.CONFIG.getInt("sojourner_staff", "max_capacity_per_item_type");
    }

    public boolean removeItemFromInternalStorage(ItemStack ist, Item item, int cost) {
        if (this.hasItemInInternalStorage(ist, item, cost)) {
            NBTTagCompound tagCompound = NBTHelper.getTag((ItemStack)ist);
            NBTTagList tagList = tagCompound.func_150295_c("Items", 10);
            NBTTagList replacementTagList = new NBTTagList();
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                NBTTagCompound tagItemData = tagList.func_150305_b(i);
                String itemName = tagItemData.func_74779_i("Name");
                if (itemName.equals(ContentHelper.getIdent((Item)item))) {
                    int quantity = tagItemData.func_74762_e("Quantity");
                    tagItemData.func_74768_a("Quantity", quantity - cost);
                }
                replacementTagList.func_74742_a((NBTBase)tagItemData);
            }
            tagCompound.func_74782_a("Items", (NBTBase)replacementTagList);
            NBTHelper.setTag((ItemStack)ist, (NBTTagCompound)tagCompound);
            return true;
        }
        return false;
    }

    public void func_77624_a(ItemStack ist, EntityPlayer player, List list, boolean par4) {
        if (!Keyboard.isKeyDown((int)42) && !Keyboard.isKeyDown((int)54)) {
            return;
        }
        String phrase = "Nothing.";
        String placing = "Nothing.";
        NBTTagCompound tagCompound = NBTHelper.getTag((ItemStack)ist);
        if (tagCompound != null) {
            NBTTagList tagList = tagCompound.func_150295_c("Items", 10);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                NBTTagCompound tagItemData = tagList.func_150305_b(i);
                String itemName = tagItemData.func_74779_i("Name");
                Item containedItem = Reliquary.CONTENT.getItem(itemName);
                int quantity = tagItemData.func_74762_e("Quantity");
                phrase = String.format("%s%s", phrase.equals("Nothing.") ? "" : String.format("%s;", phrase), new ItemStack(containedItem, 1, 0).func_82833_r() + ": " + quantity);
            }
            Item placingItem = Reliquary.CONTENT.getItem(this.getTorchPlacementMode(ist));
            if (placingItem != null) {
                placing = new ItemStack(placingItem, 1, 0).func_82833_r();
            }
        }
        this.formatTooltip(ImmutableMap.of((Object)"phrase", (Object)phrase, (Object)"placing", (Object)placing), ist, list);
        if (this.isEnabled(ist)) {
            LanguageHelper.formatTooltip((String)"tooltip.absorb_active", (ImmutableMap)ImmutableMap.of((Object)"item", (Object)(EnumChatFormatting.YELLOW + this.func_77653_i(new ItemStack(Blocks.field_150478_aa)))), (ItemStack)ist, (List)list);
        }
        LanguageHelper.formatTooltip((String)"tooltip.absorb", null, (ItemStack)ist, (List)list);
    }

    public boolean func_77648_a(ItemStack ist, EntityPlayer player, World world, int x, int y, int z, int side, float xOff, float yOff, float zOff) {
        if (player.field_82175_bq) {
            return false;
        }
        player.func_71038_i();
        if (world.field_72995_K) {
            return false;
        }
        if (!player.func_82247_a(x, y, z, side, ist)) {
            return false;
        }
        if (player.func_70093_af()) {
            return false;
        }
        if (this.getTorchPlacementMode(ist) == null) {
            return false;
        }
        Block blockAttemptingPlacement = Block.func_149684_b((String)this.getTorchPlacementMode(ist));
        if (blockAttemptingPlacement == null) {
            return false;
        }
        Block blockTargetted = world.func_147439_a(x, y, z);
        if (ContentHelper.areBlocksEqual((Block)blockTargetted, (Block)Blocks.field_150433_aE)) {
            side = 1;
        } else if (!(ContentHelper.areBlocksEqual((Block)blockTargetted, (Block)Blocks.field_150395_bd) || ContentHelper.areBlocksEqual((Block)blockTargetted, (Block)Blocks.field_150329_H) || ContentHelper.areBlocksEqual((Block)blockTargetted, (Block)Blocks.field_150330_I) || blockTargetted != null && blockTargetted.isReplaceable((IBlockAccess)world, x, y, z))) {
            x += side == 4 ? -1 : (side == 5 ? 1 : 0);
            y += side == 0 ? -1 : (side == 1 ? 1 : 0);
            z += side == 2 ? -1 : (side == 3 ? 1 : 0);
        }
        if (blockAttemptingPlacement.func_149742_c(world, x, y, z) && world.func_147472_a(blockAttemptingPlacement, x, y, z, false, side, (Entity)player, ist)) {
            if (!player.field_71075_bZ.field_75098_d) {
                int cost = 1;
                for (int distance = (int)player.func_70011_f((double)x, (double)y, (double)z); distance > Reliquary.CONFIG.getInt("sojourner_staff", "tile_per_cost_multiplier"); distance -= Reliquary.CONFIG.getInt("sojourner_staff", "tile_per_cost_multiplier").intValue()) {
                    ++cost;
                }
                if (!this.removeItemFromInternalStorage(ist, Item.func_150898_a((Block)blockAttemptingPlacement), cost)) {
                    return false;
                }
            }
            if (this.placeBlockAt(ist, player, world, x, y, z, side, xOff, yOff, zOff, this.attemptSide(world, x, y, z, side, blockAttemptingPlacement), blockAttemptingPlacement)) {
                blockAttemptingPlacement.func_149726_b(world, x, y, z);
                double gauss = 0.5 + (double)(world.field_73012_v.nextFloat() / 2.0f);
                world.func_72869_a("mobSpell", (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, gauss, gauss, 0.0);
                world.func_72908_a((double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), blockAttemptingPlacement.field_149762_H.func_150498_e(), (blockAttemptingPlacement.field_149762_H.func_150497_c() + 1.0f) / 2.0f, blockAttemptingPlacement.field_149762_H.func_150494_d() * 0.8f);
            }
        }
        return true;
    }

    private int attemptSide(World world, int x, int y, int z, int side, Block block) {
        return block.func_149660_a(world, x, y, z, side, (float)x, (float)y, (float)z, 0);
    }

    public MovingObjectPosition getBlockTarget(World world, EntityPlayer player) {
        float f = 1.0f;
        float f1 = player.field_70127_C + (player.field_70125_A - player.field_70127_C) * f;
        float f2 = player.field_70126_B + (player.field_70177_z - player.field_70126_B) * f;
        double d0 = player.field_70169_q + (player.field_70165_t - player.field_70169_q) * (double)f;
        double d1 = player.field_70167_r + (player.field_70163_u - player.field_70167_r) * (double)f + (double)(world.field_72995_K ? player.func_70047_e() - player.getDefaultEyeHeight() : player.func_70047_e());
        double d2 = player.field_70166_s + (player.field_70161_v - player.field_70166_s) * (double)f;
        Vec3 vec3 = Vec3.func_72443_a((double)d0, (double)d1, (double)d2);
        float f3 = MathHelper.func_76134_b((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = MathHelper.func_76126_a((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
        float f5 = -MathHelper.func_76134_b((float)(-f1 * ((float)Math.PI / 180)));
        float f6 = MathHelper.func_76126_a((float)(-f1 * ((float)Math.PI / 180)));
        float f7 = f4 * f5;
        float f8 = f3 * f5;
        double d3 = Reliquary.CONFIG.getInt("sojourner_staff", "max_range").intValue();
        Vec3 vec31 = vec3.func_72441_c((double)f7 * d3, (double)f6 * d3, (double)f8 * d3);
        return world.func_147447_a(vec3, vec31, true, false, false);
    }

    public ItemStack func_77659_a(ItemStack ist, World world, EntityPlayer player) {
        MovingObjectPosition mop;
        if (!player.func_70093_af() && (mop = this.getBlockTarget(world, player)) != null && mop.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            float xOff = (float)((double)mop.field_72311_b - player.field_70165_t);
            float yOff = (float)((double)mop.field_72312_c - player.field_70163_u);
            float zOff = (float)((double)mop.field_72309_d - player.field_70161_v);
            this.func_77648_a(ist, player, world, mop.field_72311_b, mop.field_72312_c, mop.field_72309_d, mop.field_72310_e, xOff, yOff, zOff);
        }
        return super.func_77659_a(ist, world, player);
    }

    protected MovingObjectPosition func_77621_a(World world, EntityPlayer player, boolean weirdBucketBoolean) {
        float movementCoefficient = 1.0f;
        float pitchOff = player.field_70127_C + (player.field_70125_A - player.field_70127_C) * movementCoefficient;
        float yawOff = player.field_70126_B + (player.field_70177_z - player.field_70126_B) * movementCoefficient;
        double xOff = player.field_70169_q + (player.field_70165_t - player.field_70169_q) * (double)movementCoefficient;
        double yOff = player.field_70167_r + (player.field_70163_u - player.field_70167_r) * (double)movementCoefficient + 1.62 - (double)player.field_70129_M;
        double zOff = player.field_70166_s + (player.field_70161_v - player.field_70166_s) * (double)movementCoefficient;
        Vec3 playerVector = Vec3.func_72443_a((double)xOff, (double)yOff, (double)zOff);
        float cosTraceYaw = MathHelper.func_76134_b((float)(-yawOff * ((float)Math.PI / 180) - (float)Math.PI));
        float sinTraceYaw = MathHelper.func_76126_a((float)(-yawOff * ((float)Math.PI / 180) - (float)Math.PI));
        float cosTracePitch = -MathHelper.func_76134_b((float)(-pitchOff * ((float)Math.PI / 180)));
        float sinTracePitch = MathHelper.func_76126_a((float)(-pitchOff * ((float)Math.PI / 180)));
        float pythagoraStuff = sinTraceYaw * cosTracePitch;
        float pythagoraStuff2 = cosTraceYaw * cosTracePitch;
        double distCoeff = 32.0;
        Vec3 rayTraceVector = playerVector.func_72441_c((double)pythagoraStuff * distCoeff, (double)sinTracePitch * distCoeff, (double)pythagoraStuff2 * distCoeff);
        return world.func_72901_a(playerVector, rayTraceVector, weirdBucketBoolean);
    }

    public boolean func_77662_d() {
        return true;
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int metadata, Block block) {
        if (!world.func_147465_d(x, y, z, block, metadata, 3)) {
            return false;
        }
        if (ContentHelper.areBlocksEqual((Block)world.func_147439_a(x, y, z), (Block)block)) {
            block.func_149695_a(world, x, y, z, world.func_147439_a(x, y, z));
            block.func_149689_a(world, x, y, z, (EntityLivingBase)player, stack);
        }
        return true;
    }
}

