/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.event;

import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import java.util.Random;
import lib.enderwizards.sandstone.items.ItemToggleable;
import lib.enderwizards.sandstone.util.ContentHelper;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityCaveSpider;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.monster.EntityMagmaCube;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.monster.EntitySnowman;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityBat;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import xreliquary.Reliquary;
import xreliquary.init.XRRecipes;
import xreliquary.util.alkahestry.AlkahestRecipe;
import xreliquary.util.alkahestry.Alkahestry;

public class CommonEventHandler {
    @SubscribeEvent
    public void blameDrullkus(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.player.func_146103_bH().getName() == "Drullkus" && !event.player.getEntityData().func_74764_b("gift") && event.player.field_71071_by.func_70441_a(new ItemStack(Reliquary.CONTENT.getItem("witch_hat")))) {
            event.player.getEntityData().func_74757_a("gift", true);
        }
    }

    @SubscribeEvent
    public void onEntityLiving(LivingEvent event) {
        this.doTwilightCloakCheck(event);
        this.doHeartZhuCheck(event);
    }

    @SubscribeEvent
    public void onEntityTargetedEvent(LivingSetAttackTargetEvent event) {
        this.doTwilightCloakCheck((LivingEvent)event);
        this.doHeartZhuCheck(event);
    }

    public void doHeartZhuCheck(LivingSetAttackTargetEvent event) {
        if (event.target == null) {
            return;
        }
        if (!(event.target instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)event.target;
        this.doZombieZhuCheck(event.entity, player);
        this.doSkeletonZhuCheck(event.entity, player);
        this.doWitherSkeletonZhuCheck(event.entity, player);
        this.doCreeperZhuCheck(event.entity, player);
    }

    public void doHeartZhuCheck(LivingEvent event) {
        if (event.entity instanceof EntityLiving) {
            EntityLiving entityLiving = (EntityLiving)event.entity;
            if (entityLiving.func_70638_az() == null) {
                return;
            }
            if (!(entityLiving.func_70638_az() instanceof EntityPlayer)) {
                return;
            }
            EntityPlayer player = (EntityPlayer)entityLiving.func_70638_az();
            this.doZombieZhuCheck(event.entity, player);
            this.doSkeletonZhuCheck(event.entity, player);
            this.doWitherSkeletonZhuCheck(event.entity, player);
            this.doCreeperZhuCheck(event.entity, player);
        }
    }

    private ItemStack heartZhu(int meta) {
        return XRRecipes.nianZhu(meta);
    }

    public void doZombieZhuCheck(Entity e, EntityPlayer p) {
        if (e instanceof EntityZombie && !(e instanceof EntityPigZombie) && this.playerHasItem(p, this.heartZhu(0), false)) {
            ((EntityZombie)e).func_70624_b(null);
            ((EntityZombie)e).func_70784_b(null);
            ((EntityZombie)e).func_70604_c(null);
        }
    }

    public void doSkeletonZhuCheck(Entity e, EntityPlayer p) {
        if (e instanceof EntitySkeleton && ((EntitySkeleton)e).func_82202_m() != 1 && this.playerHasItem(p, this.heartZhu(1), false)) {
            ((EntitySkeleton)e).func_70624_b(null);
            ((EntitySkeleton)e).func_70784_b(null);
            ((EntitySkeleton)e).func_70604_c(null);
        }
    }

    public void doWitherSkeletonZhuCheck(Entity e, EntityPlayer p) {
        if (e instanceof EntitySkeleton && ((EntitySkeleton)e).func_82202_m() == 1 && this.playerHasItem(p, this.heartZhu(2), false)) {
            ((EntitySkeleton)e).func_70624_b(null);
            ((EntitySkeleton)e).func_70784_b(null);
            ((EntitySkeleton)e).func_70604_c(null);
        }
    }

    public void doCreeperZhuCheck(Entity e, EntityPlayer p) {
        if (e instanceof EntityCreeper && this.playerHasItem(p, this.heartZhu(3), false)) {
            ((EntityCreeper)e).func_70624_b(null);
            ((EntityCreeper)e).func_70784_b(null);
            ((EntityCreeper)e).func_70604_c(null);
        }
    }

    public void doTwilightCloakCheck(LivingEvent event) {
        if (event.entity instanceof EntityLiving) {
            int playerZ;
            int playerY;
            EntityLiving entityLiving = (EntityLiving)event.entity;
            if (entityLiving.func_70638_az() == null) {
                return;
            }
            if (!(entityLiving.func_70638_az() instanceof EntityPlayer)) {
                return;
            }
            EntityPlayer player = (EntityPlayer)entityLiving.func_70638_az();
            if (!this.playerHasItem(player, Reliquary.CONTENT.getItem("twilight_cloak"), true)) {
                return;
            }
            int playerX = MathHelper.func_76128_c((double)player.field_70165_t);
            if (player.field_70170_p.func_72957_l(playerX, playerY = MathHelper.func_76128_c((double)player.field_70121_D.field_72338_b), playerZ = MathHelper.func_76128_c((double)player.field_70161_v)) > Reliquary.CONFIG.getInt("twilight_cloak", "max_light_level")) {
                return;
            }
            if (event.entity instanceof EntityLiving) {
                ((EntityLiving)event.entity).func_70624_b(null);
            }
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.modID.equals("xreliquary")) {
            Reliquary.CONFIG.save();
        }
    }

    @SubscribeEvent
    public void onLivingDrops(LivingDropsEvent event) {
        Entity e = event.entity;
        this.handleSquidDropsCheck(e, event);
        this.handleWitchDropsCheck(e, event);
        this.handleSpiderOrCaveSpiderDropsCheck(e, event);
        this.handleSkeletonDropsCheck(e, event);
        this.handleWitherDropsCheck(e, event);
        this.handleZombieOrZombiePigmanDropsCheck(e, event);
        this.handleSlimeDropsCheck(e, event);
        this.handleBlazeOrMagmaCubeDropsCheck(e, event);
        this.handleGhastOrCreeperDropsCheck(e, event);
        this.handleEndermanDropsCheck(e, event);
        this.handleBatsDropsCheck(e, event);
        this.handleSnowGolemDropsCheck(e, event);
    }

    public void handleEventDropListAddition(Entity e, LivingDropsEvent event, float probabilityBase, float lootingProbabilityIncrement, ItemStack ist) {
        float dropProbability = probabilityBase + lootingProbabilityIncrement * (float)event.lootingLevel;
        if (e.field_70170_p.field_73012_v.nextFloat() <= dropProbability && event.source.func_76346_g() != null && event.source.func_76346_g() instanceof EntityPlayer && event.source.field_76373_n.equals("player")) {
            EntityItem entityitem = new EntityItem(event.entityLiving.field_70170_p, event.entityLiving.field_70165_t, event.entityLiving.field_70163_u, event.entityLiving.field_70161_v, ist);
            entityitem.field_145804_b = 10;
            event.drops.add(entityitem);
        }
    }

    public float getBaseDrop(String s) {
        return (float)Reliquary.CONFIG.getInt("mob_drop_probability", s + "_base").intValue() * 0.01f;
    }

    public float getLootingDrop(String s) {
        return (float)Reliquary.CONFIG.getInt("mob_drop_probability", s + "_looting").intValue() * 0.01f;
    }

    private ItemStack ingredient(int meta) {
        return XRRecipes.ingredient(meta);
    }

    public void handleSquidDropsCheck(Entity e, LivingDropsEvent event) {
        if (e instanceof EntitySquid) {
            this.handleEventDropListAddition(e, event, this.getBaseDrop("squid_beak"), this.getLootingDrop("squid_beak"), this.ingredient(12));
        }
    }

    public void handleWitchDropsCheck(Entity e, LivingDropsEvent event) {
        if (e instanceof EntityWitch) {
            this.handleEventDropListAddition(e, event, this.getBaseDrop("witch_hat"), this.getLootingDrop("witch_hat"), new ItemStack(Reliquary.CONTENT.getItem("witch_hat"), 1, 0));
        }
    }

    public void handleSpiderOrCaveSpiderDropsCheck(Entity e, LivingDropsEvent event) {
        if (e instanceof EntitySpider) {
            float base = this.getBaseDrop(e instanceof EntityCaveSpider ? "cave_spider_chelicerae" : "spider_chelicerae");
            float looting = this.getLootingDrop(e instanceof EntityCaveSpider ? "cave_spider_chelicerae" : "spider_chelicerae");
            this.handleEventDropListAddition(e, event, base, looting, this.ingredient(2));
        }
    }

    public void handleSkeletonDropsCheck(Entity e, LivingDropsEvent event) {
        if (e instanceof EntitySkeleton && ((EntitySkeleton)e).func_82202_m() != 1) {
            this.handleEventDropListAddition(e, event, this.getBaseDrop("rib_bone"), this.getLootingDrop("rib_bone"), this.ingredient(0));
        }
    }

    public void handleWitherDropsCheck(Entity e, LivingDropsEvent event) {
        if (e instanceof EntitySkeleton && ((EntitySkeleton)e).func_82202_m() == 1) {
            this.handleEventDropListAddition(e, event, this.getBaseDrop("wither_rib"), this.getLootingDrop("wither_rib"), this.ingredient(1));
        }
    }

    public void handleZombieOrZombiePigmanDropsCheck(Entity e, LivingDropsEvent event) {
        if (e instanceof EntityZombie) {
            float base = this.getBaseDrop(e instanceof EntityPigZombie ? "necrotic_heart_pigman" : "necrotic_heart_zombie");
            float looting = this.getLootingDrop(e instanceof EntityPigZombie ? "necrotic_heart_pigman" : "necrotic_heart_zombie");
            this.handleEventDropListAddition(e, event, base, looting, this.ingredient(6));
        }
    }

    public void handleSlimeDropsCheck(Entity e, LivingDropsEvent event) {
        if (e instanceof EntitySlime) {
            this.handleEventDropListAddition(e, event, this.getBaseDrop("slime_pearl"), this.getLootingDrop("slime_pearl"), this.ingredient(4));
        }
    }

    public void handleBlazeOrMagmaCubeDropsCheck(Entity e, LivingDropsEvent event) {
        if (e instanceof EntityBlaze || e instanceof EntityMagmaCube) {
            float base = this.getBaseDrop(e instanceof EntityMagmaCube ? "molten_core_magma_cube" : "molten_core_blaze");
            float looting = this.getLootingDrop(e instanceof EntityMagmaCube ? "molten_core_magma_cube" : "molten_core_blaze");
            this.handleEventDropListAddition(e, event, base, looting, this.ingredient(7));
        }
    }

    public void handleGhastOrCreeperDropsCheck(Entity e, LivingDropsEvent event) {
        if (e instanceof EntityCreeper || e instanceof EntityGhast) {
            float base = this.getBaseDrop(e instanceof EntityGhast ? "catalyzing_gland_ghast" : "catalyzing_gland_creeper");
            float looting = this.getLootingDrop(e instanceof EntityGhast ? "catalyzing_gland_ghast" : "catalyzing_gland_creeper");
            this.handleEventDropListAddition(e, event, base, looting, this.ingredient(3));
            if (e instanceof EntityCreeper && ((EntityCreeper)e).func_70830_n()) {
                this.handleEventDropListAddition(e, event, this.getBaseDrop("eye_of_the_storm"), this.getLootingDrop("eye_of_the_storm"), this.ingredient(8));
            }
        }
    }

    public void handleEndermanDropsCheck(Entity e, LivingDropsEvent event) {
        if (e instanceof EntityEnderman) {
            this.handleEventDropListAddition(e, event, this.getBaseDrop("nebulous_heart"), this.getLootingDrop("nebulous_heart"), this.ingredient(11));
        }
    }

    public void handleBatsDropsCheck(Entity e, LivingDropsEvent event) {
        if (e instanceof EntityBat) {
            this.handleEventDropListAddition(e, event, this.getBaseDrop("bat_wing"), this.getLootingDrop("bat_wing"), this.ingredient(5));
        }
    }

    public void handleSnowGolemDropsCheck(Entity e, LivingDropsEvent event) {
        if (e instanceof EntitySnowman) {
            this.handleEventDropListAddition(e, event, this.getBaseDrop("frozen_core"), this.getLootingDrop("frozen_core"), this.ingredient(10));
        }
    }

    @SubscribeEvent
    public void beforePlayerHurt(LivingAttackEvent event) {
        Entity entity = event.entity;
        if (entity == null || !(entity instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)entity;
        this.handleInfernalClawsCheck(player, event);
        this.handleInfernalChaliceCheck(player, event);
        this.handleAngelicFeatherCheck(player, event);
        this.handleKrakenEyeCheck(player, event);
        this.handlePhoenixDownCheck(player, event);
        this.handleAngelheartVialCheck(player, event);
        if (event.isCanceled()) {
            event.setResult(null);
        }
    }

    public void handleInfernalClawsCheck(EntityPlayer player, LivingAttackEvent event) {
        if (!this.playerHasItem(player, Reliquary.CONTENT.getItem("infernal_claws"), false)) {
            return;
        }
        if (event.source != DamageSource.field_76372_a && event.source != DamageSource.field_76370_b) {
            return;
        }
        if (player.func_71024_bL().func_75116_a() <= 0) {
            return;
        }
        player.func_71020_j(event.ammount * ((float)Reliquary.CONFIG.getInt("infernal_claws", "hunger_cost_percent").intValue() / 100.0f));
        event.setCanceled(true);
    }

    public void handleInfernalChaliceCheck(EntityPlayer player, LivingAttackEvent event) {
        if (!this.playerHasItem(player, Reliquary.CONTENT.getItem("infernal_chalice"), false)) {
            return;
        }
        if (event.source != DamageSource.field_76371_c) {
            return;
        }
        if (player.func_71024_bL().func_75116_a() <= 0) {
            return;
        }
        if (event.source != DamageSource.field_76371_c) {
            player.func_71020_j(event.ammount * ((float)Reliquary.CONFIG.getInt("infernal_chalice", "hunger_cost_percent").intValue() / 100.0f));
        }
        event.setCanceled(true);
    }

    public void handleAngelheartVialCheck(EntityPlayer player, LivingAttackEvent event) {
        if (player.func_110143_aJ() > (float)Math.round(event.ammount)) {
            return;
        }
        if (!this.playerHasItem(player, Reliquary.CONTENT.getItem("angelheart_vial"), false)) {
            return;
        }
        this.decreaseItemByOne(player, Reliquary.CONTENT.getItem("angelheart_vial"));
        this.spawnAngelheartVialParticles(player);
        player.field_70170_p.func_72908_a(player.field_70165_t + 0.5, player.field_70163_u + 0.5, player.field_70161_v + 0.5, "dig.glass", 1.0f, player.field_70170_p.field_73012_v.nextFloat() * 0.1f + 0.9f);
        float amountHealed = player.func_110138_aP() * (float)Reliquary.CONFIG.getInt("angelheart_vial", "heal_percentage_of_max_life").intValue() / 100.0f;
        player.func_70606_j(amountHealed);
        if (Reliquary.CONFIG.getBool("angelheart_vial", "remove_negative_status")) {
            this.removeNegativeStatusEffects(player);
        }
        event.setCanceled(true);
    }

    public void spawnAngelheartVialParticles(EntityPlayer player) {
        double var8 = player.field_70165_t;
        double var10 = player.field_70163_u;
        double var12 = player.field_70161_v;
        String var14 = "iconcrack_" + Item.func_150891_b((Item)Items.field_151068_bn);
        Random var7 = player.field_70170_p.field_73012_v;
        for (int var15 = 0; var15 < 8; ++var15) {
            player.field_70170_p.func_72869_a(var14, var8, var10, var12, var7.nextGaussian() * 0.15, var7.nextDouble() * 0.2, var7.nextGaussian() * 0.15);
        }
        float red = 1.0f;
        float green = 0.0f;
        float blue = 1.0f;
        String var19 = "spell";
        for (int var20 = 0; var20 < 100; ++var20) {
            EntityFX var31;
            double var39 = var7.nextDouble() * 4.0;
            double var23 = var7.nextDouble() * Math.PI * 2.0;
            double var25 = Math.cos(var23) * var39;
            double var27 = 0.01 + var7.nextDouble() * 0.5;
            double var29 = Math.sin(var23) * var39;
            if (!player.field_70170_p.field_72995_K || (var31 = Minecraft.func_71410_x().field_71438_f.func_72726_b(var19, var8 + var25 * 0.1, var10 + 0.3, var12 + var29 * 0.1, var25, var27, var29)) == null) continue;
            float var32 = 0.75f + var7.nextFloat() * 0.25f;
            var31.func_70538_b(red * var32, green * var32, blue * var32);
            var31.func_70543_e((float)var39);
        }
        player.field_70170_p.func_72908_a(player.field_70165_t + 0.5, player.field_70163_u + 0.5, player.field_70161_v + 0.5, "random.glass", 1.0f, player.field_70170_p.field_73012_v.nextFloat() * 0.1f + 0.9f);
    }

    public void removeNegativeStatusEffects(EntityPlayer player) {
        player.func_82170_o(Potion.field_82731_v.field_76415_H);
        player.func_82170_o(Potion.field_76438_s.field_76415_H);
        player.func_82170_o(Potion.field_76436_u.field_76415_H);
        player.func_82170_o(Potion.field_76431_k.field_76415_H);
        player.func_82170_o(Potion.field_76419_f.field_76415_H);
        player.func_82170_o(Potion.field_76421_d.field_76415_H);
        player.func_82170_o(Potion.field_76440_q.field_76415_H);
        player.func_82170_o(Potion.field_76437_t.field_76415_H);
    }

    public void handlePhoenixDownCheck(EntityPlayer player, LivingAttackEvent event) {
        if (!this.playerHasItem(player, Reliquary.CONTENT.getItem("phoenix_down"), false)) {
            return;
        }
        if (player.func_110143_aJ() > (float)Math.round(event.ammount)) {
            if (event.source != DamageSource.field_76379_h) {
                return;
            }
            if (player.func_71024_bL().func_75116_a() <= 0) {
                return;
            }
            float hungerDamage = event.ammount * ((float)Reliquary.CONFIG.getInt("phoenix_down", "hunger_cost_percent").intValue() / 100.0f);
            player.func_71020_j(hungerDamage);
            player.func_71024_bL().func_75118_a(player);
            event.setCanceled(true);
            return;
        }
        this.revertPhoenixDownToAngelicFeather(player);
        float amountHealed = player.func_110138_aP() * (float)Reliquary.CONFIG.getInt("phoenix_down", "heal_percentage_of_max_life").intValue() / 100.0f;
        player.func_70606_j(amountHealed);
        if (Reliquary.CONFIG.getBool("phoenix_down", "remove_negative_status")) {
            this.removeNegativeStatusEffects(player);
        }
        if (event.source == DamageSource.field_76371_c && Reliquary.CONFIG.getBool("phoenix_down", "give_temporary_fire_resistance_if_fire_damage_killed_you")) {
            player.func_70690_d(new PotionEffect(Potion.field_76426_n.field_76415_H, 200, 0));
        }
        if (event.source == DamageSource.field_76369_e && Reliquary.CONFIG.getBool("phoenix_down", "give_temporary_water_breathing_if_drowning_killed_you")) {
            player.func_70050_g(10);
            player.func_70690_d(new PotionEffect(Potion.field_76427_o.field_76415_H, 200, 0));
        }
        if (Reliquary.CONFIG.getBool("phoenix_down", "give_temporary_damage_resistance")) {
            player.func_70690_d(new PotionEffect(Potion.field_76429_m.field_76415_H, 200, 1));
        }
        if (Reliquary.CONFIG.getBool("phoenix_down", "give_temporary_regeneration")) {
            player.func_70690_d(new PotionEffect(Potion.field_76428_l.field_76415_H, 200, 1));
        }
        this.spawnPhoenixResurrectionParticles(player);
        event.setCanceled(true);
    }

    public void spawnPhoenixResurrectionParticles(EntityPlayer player) {
        for (int particles = 0; particles <= 400; ++particles) {
            player.field_70170_p.func_72869_a("flame", player.field_70165_t, player.field_70163_u, player.field_70161_v, player.field_70170_p.field_73012_v.nextGaussian() * 8.0, player.field_70170_p.field_73012_v.nextGaussian() * 8.0, player.field_70170_p.field_73012_v.nextGaussian() * 8.0);
        }
    }

    public void handleAngelicFeatherCheck(EntityPlayer player, LivingAttackEvent event) {
        if (!this.playerHasItem(player, Reliquary.CONTENT.getItem("angelic_feather"), false)) {
            return;
        }
        if (event.source != DamageSource.field_76379_h) {
            return;
        }
        if (player.func_71024_bL().func_75116_a() <= 0) {
            return;
        }
        if (player.field_70143_R > 0.0f) {
            float hungerDamage = event.ammount * ((float)Reliquary.CONFIG.getInt("angelic_feather", "hunger_cost_percent").intValue() / 100.0f);
            player.func_71020_j(hungerDamage);
            player.func_71024_bL().func_75118_a(player);
        }
        event.setCanceled(true);
    }

    public void handleKrakenEyeCheck(EntityPlayer player, LivingAttackEvent event) {
        if (!this.playerHasItem(player, Reliquary.CONTENT.getItem("kraken_shell"), false)) {
            return;
        }
        if (player.func_71024_bL().func_75116_a() <= 0) {
            return;
        }
        if (event.source == DamageSource.field_76369_e) {
            float hungerDamage = event.ammount * ((float)Reliquary.CONFIG.getInt("kraken_shell", "hunger_cost_percent").intValue() / 100.0f);
            player.func_71020_j(hungerDamage);
            event.setCanceled(true);
        }
    }

    private void revertPhoenixDownToAngelicFeather(EntityPlayer player) {
        for (int slot = 0; slot < player.field_71071_by.field_70462_a.length; ++slot) {
            if (player.field_71071_by.field_70462_a[slot] == null || player.field_71071_by.field_70462_a[slot].func_77973_b() != Reliquary.CONTENT.getItem("phoenix_down")) continue;
            player.field_71071_by.field_70462_a[slot] = new ItemStack(Reliquary.CONTENT.getItem("angelic_feather"));
            return;
        }
    }

    private boolean playerHasItem(EntityPlayer player, Item item, boolean checkEnabled) {
        for (int slot = 0; slot < player.field_71071_by.field_70462_a.length; ++slot) {
            if (player.field_71071_by.field_70462_a[slot] == null || player.field_71071_by.field_70462_a[slot].func_77973_b() != item) continue;
            if (checkEnabled && player.field_71071_by.field_70462_a[slot].func_77973_b() instanceof ItemToggleable) {
                return ((ItemToggleable)player.field_71071_by.field_70462_a[slot].func_77973_b()).isEnabled(player.field_71071_by.field_70462_a[slot]);
            }
            return true;
        }
        return false;
    }

    private boolean playerHasItem(EntityPlayer player, ItemStack ist, boolean checkEnabled) {
        for (int slot = 0; slot < player.field_71071_by.field_70462_a.length; ++slot) {
            if (player.field_71071_by.field_70462_a[slot] == null || !player.field_71071_by.field_70462_a[slot].func_77969_a(ist)) continue;
            if (checkEnabled && player.field_71071_by.field_70462_a[slot].func_77973_b() instanceof ItemToggleable) {
                return ((ItemToggleable)player.field_71071_by.field_70462_a[slot].func_77973_b()).isEnabled(player.field_71071_by.field_70462_a[slot]);
            }
            return true;
        }
        return false;
    }

    private void decreaseItemByOne(EntityPlayer player, Item item) {
        for (int slot = 0; slot < player.field_71071_by.field_70462_a.length; ++slot) {
            if (player.field_71071_by.field_70462_a[slot] == null || player.field_71071_by.field_70462_a[slot].func_77973_b() != item) continue;
            player.field_71071_by.func_70298_a(slot, 1);
            return;
        }
    }

    @SubscribeEvent
    public void onCraftingAlkahest(PlayerEvent.ItemCraftedEvent event) {
        boolean isCharging = false;
        int tome = 9;
        AlkahestRecipe recipe = null;
        for (int count = 0; count < event.craftMatrix.func_70302_i_(); ++count) {
            ItemStack stack = event.craftMatrix.func_70301_a(count);
            if (stack == null) continue;
            if (ContentHelper.getIdent((Item)stack.func_77973_b()).equals(ContentHelper.getIdent((Item)Reliquary.CONTENT.getItem("alkahest_tome")))) {
                tome = count;
                continue;
            }
            if (ContentHelper.getIdent((Item)stack.func_77973_b()).equals(ContentHelper.getIdent((Item)Items.field_151137_ax)) || ContentHelper.getIdent((Item)stack.func_77973_b()).equals(ContentHelper.getIdent((Block)Blocks.field_150451_bX))) {
                isCharging = true;
                continue;
            }
            recipe = Alkahestry.getDictionaryKey(stack) == null ? Alkahestry.getRegistry().get(ContentHelper.getIdent((Item)stack.func_77973_b())) : Alkahestry.getDictionaryKey(stack);
        }
        if (tome != 9 && isCharging) {
            event.craftMatrix.func_70299_a(tome, null);
        } else if (tome != 9 && !isCharging && recipe != null) {
            ItemStack temp = event.craftMatrix.func_70301_a(tome);
            temp.func_77964_b(temp.func_77960_j() + recipe.cost);
            event.craftMatrix.func_70299_a(tome, temp);
        }
    }
}

