/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.event;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import lib.enderwizards.sandstone.util.NBTHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderPlayerEvent;
import org.lwjgl.opengl.GL11;
import xreliquary.Reliquary;
import xreliquary.client.model.ModelWitchHat;
import xreliquary.items.ItemAlkahestryTome;
import xreliquary.items.ItemDestructionCatalyst;
import xreliquary.items.ItemEnderStaff;
import xreliquary.items.ItemGlacialStaff;
import xreliquary.items.ItemHandgun;
import xreliquary.items.ItemHarvestRod;
import xreliquary.items.ItemHeroMedallion;
import xreliquary.items.ItemIceRod;
import xreliquary.items.ItemInfernalChalice;
import xreliquary.items.ItemMidasTouchstone;
import xreliquary.items.ItemPyromancerStaff;
import xreliquary.items.ItemRendingGale;
import xreliquary.items.ItemSojournerStaff;
import xreliquary.items.ItemVoidTear;
import xreliquary.lib.Colors;

public class ClientEventHandler {
    private static RenderItem itemRenderer = new RenderItem();
    private static int time;

    @SubscribeEvent
    public void onRenderTick(TickEvent.RenderTickEvent event) {
        this.handleTickIncrement(event);
        this.handleHandgunHUDCheck();
        this.handleSojournerHUDCheck();
        this.handleTomeHUDCheck();
        this.handleDestructionCatalystHUDCheck();
        this.handleEnderStaffHUDCheck();
        this.handleIceMagusRodHUDCheck();
        this.handleVoidTearHUDCheck();
        this.handleMidasTouchstoneHUDCheck();
        this.handleHarvestRodHUDCheck();
        this.handleInfernalChaliceHUDCheck();
        this.handleHeroMedallionHUDCheck();
        this.handlePyromancerStaffHUDCheck();
        this.handleRendingGaleHUDCheck();
    }

    public void handleTickIncrement(TickEvent.RenderTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        time = ClientEventHandler.getTime() > 4096 ? 0 : ++time;
    }

    public static int getTime() {
        return time;
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onRenderPlayer(RenderPlayerEvent.SetArmorModel event) {
        if (event.entityPlayer != null && event.stack != null && event.stack.func_77973_b() == Reliquary.CONTENT.getItem("witch_hat")) {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(new ResourceLocation("minecraft:textures/entity/witch.png"));
            ModelBiped model = event.renderer.field_77111_i;
            model.field_78116_c.field_78806_j = false;
            model.field_78114_d.field_78806_j = false;
            model.field_78115_e.field_78806_j = false;
            model.field_78112_f.field_78806_j = false;
            model.field_78113_g.field_78806_j = false;
            model.field_78123_h.field_78806_j = false;
            model.field_78124_i.field_78806_j = false;
            model = ModelWitchHat.self;
            event.renderer.func_77042_a((ModelBase)model);
            model.field_78095_p = event.renderer.field_77109_a.field_78095_p;
            model.field_78093_q = event.entityPlayer.func_70115_ae();
            model.field_78091_s = event.renderer.field_77109_a.field_78091_s;
            event.result = 1;
            return;
        }
        if (event.stack != null && event.stack.func_77973_b() == Reliquary.CONTENT.getItem("witch_hat")) {
            event.result = 0;
            return;
        }
    }

    public void handleTomeHUDCheck() {
        Minecraft mc = Minecraft.func_71410_x();
        if (!Minecraft.func_71382_s() || !mc.field_71415_G) {
            return;
        }
        EntityClientPlayerMP player = mc.field_71439_g;
        if (player == null || player.func_71045_bC() == null || !(player.func_71045_bC().func_77973_b() instanceof ItemAlkahestryTome)) {
            return;
        }
        ItemStack tomeStack = player.func_71045_bC();
        ItemStack redstoneStack = new ItemStack(Items.field_151137_ax, NBTHelper.getInteger((String)"redstone", (ItemStack)tomeStack), 0);
        ClientEventHandler.renderStandardTwoItemHUD(mc, (EntityPlayer)player, tomeStack, redstoneStack, Reliquary.CONFIG.getInt("hud_positions", "alkahest_tome"), 0, 0);
    }

    public void handleDestructionCatalystHUDCheck() {
        Minecraft mc = Minecraft.func_71410_x();
        if (!Minecraft.func_71382_s() || !mc.field_71415_G) {
            return;
        }
        EntityClientPlayerMP player = mc.field_71439_g;
        if (player == null || player.func_71045_bC() == null || !(player.func_71045_bC().func_77973_b() instanceof ItemDestructionCatalyst)) {
            return;
        }
        ItemStack destructionCatalystStack = player.func_71045_bC();
        ItemStack gunpowderStack = new ItemStack(Items.field_151016_H, NBTHelper.getInteger((String)"gunpowder", (ItemStack)destructionCatalystStack), 0);
        ClientEventHandler.renderStandardTwoItemHUD(mc, (EntityPlayer)player, destructionCatalystStack, gunpowderStack, Reliquary.CONFIG.getInt("hud_positions", "destruction_catalyst"), 0, 0);
    }

    public void handleEnderStaffHUDCheck() {
        Minecraft mc = Minecraft.func_71410_x();
        if (!Minecraft.func_71382_s() || !mc.field_71415_G) {
            return;
        }
        EntityClientPlayerMP player = mc.field_71439_g;
        if (player == null || player.func_71045_bC() == null || !(player.func_71045_bC().func_77973_b() instanceof ItemEnderStaff)) {
            return;
        }
        ItemStack enderStaffStack = player.func_71045_bC();
        ItemEnderStaff enderStaffItem = (ItemEnderStaff)enderStaffStack.func_77973_b();
        String staffMode = enderStaffItem.getMode(enderStaffStack);
        ItemStack displayItemStack = new ItemStack(Items.field_151079_bi, NBTHelper.getInteger((String)"ender_pearls", (ItemStack)enderStaffStack), 0);
        if (staffMode.equals("node_warp")) {
            displayItemStack = new ItemStack(Reliquary.CONTENT.getBlock("wraith_node"), NBTHelper.getInteger((String)"ender_pearls", (ItemStack)enderStaffStack), 0);
        } else if (staffMode.equals("long_cast")) {
            displayItemStack = new ItemStack(Items.field_151061_bv, NBTHelper.getInteger((String)"ender_pearls", (ItemStack)enderStaffStack), 0);
        }
        ClientEventHandler.renderStandardTwoItemHUD(mc, (EntityPlayer)player, enderStaffStack, displayItemStack, Reliquary.CONFIG.getInt("hud_positions", "ender_staff"), 0, 0);
    }

    public void handleIceMagusRodHUDCheck() {
        Minecraft mc = Minecraft.func_71410_x();
        if (!Minecraft.func_71382_s() || !mc.field_71415_G) {
            return;
        }
        EntityClientPlayerMP player = mc.field_71439_g;
        if (player == null || player.func_71045_bC() == null || !(player.func_71045_bC().func_77973_b() instanceof ItemIceRod)) {
            return;
        }
        ItemStack iceRodStack = player.func_71045_bC();
        ItemStack snowballStack = new ItemStack(Items.field_151126_ay, NBTHelper.getInteger((String)"snowballs", (ItemStack)iceRodStack), 0);
        String hudSelector = player.func_71045_bC().func_77973_b() instanceof ItemGlacialStaff ? "glacial_staff" : "ice_magus_rod";
        ClientEventHandler.renderStandardTwoItemHUD(mc, (EntityPlayer)player, iceRodStack, snowballStack, Reliquary.CONFIG.getInt("hud_positions", hudSelector), 0, NBTHelper.getInteger((String)"snowballs", (ItemStack)iceRodStack));
    }

    public void handleVoidTearHUDCheck() {
        Minecraft mc = Minecraft.func_71410_x();
        if (!Minecraft.func_71382_s() || !mc.field_71415_G) {
            return;
        }
        EntityClientPlayerMP player = mc.field_71439_g;
        if (player == null || player.func_71045_bC() == null || !(player.func_71045_bC().func_77973_b() instanceof ItemVoidTear)) {
            return;
        }
        ItemStack voidTearStack = player.func_71045_bC();
        ItemVoidTear voidTearItem = (ItemVoidTear)voidTearStack.func_77973_b();
        ItemStack containedItemStack = voidTearItem.getContainedItem(voidTearStack);
        ClientEventHandler.renderStandardTwoItemHUD(mc, (EntityPlayer)player, voidTearStack, containedItemStack, Reliquary.CONFIG.getInt("hud_positions", "void_tear"), 0, 0);
    }

    public void handleMidasTouchstoneHUDCheck() {
        Minecraft mc = Minecraft.func_71410_x();
        if (!Minecraft.func_71382_s() || !mc.field_71415_G) {
            return;
        }
        EntityClientPlayerMP player = mc.field_71439_g;
        if (player == null || player.func_71045_bC() == null || !(player.func_71045_bC().func_77973_b() instanceof ItemMidasTouchstone)) {
            return;
        }
        ItemStack midasTouchstoneStack = player.func_71045_bC();
        ItemStack glowstoneStack = new ItemStack(Items.field_151114_aO, NBTHelper.getInteger((String)"glowstone", (ItemStack)midasTouchstoneStack), 0);
        ClientEventHandler.renderStandardTwoItemHUD(mc, (EntityPlayer)player, midasTouchstoneStack, glowstoneStack, Reliquary.CONFIG.getInt("hud_positions", "midas_touchstone"), 0, 0);
    }

    public void handleHarvestRodHUDCheck() {
        Minecraft mc = Minecraft.func_71410_x();
        if (!Minecraft.func_71382_s() || !mc.field_71415_G) {
            return;
        }
        EntityClientPlayerMP player = mc.field_71439_g;
        if (player == null || player.func_71045_bC() == null || !(player.func_71045_bC().func_77973_b() instanceof ItemHarvestRod)) {
            return;
        }
        ItemStack harvestRodStack = player.func_71045_bC();
        ItemStack bonemealStack = new ItemStack(Items.field_151100_aR, NBTHelper.getInteger((String)"bonemeal", (ItemStack)harvestRodStack), 15);
        ClientEventHandler.renderStandardTwoItemHUD(mc, (EntityPlayer)player, harvestRodStack, bonemealStack, Reliquary.CONFIG.getInt("hud_positions", "harvest_rod"), 0, 0);
    }

    public void handleInfernalChaliceHUDCheck() {
        Minecraft mc = Minecraft.func_71410_x();
        if (!Minecraft.func_71382_s() || !mc.field_71415_G) {
            return;
        }
        EntityClientPlayerMP player = mc.field_71439_g;
        if (player == null || player.func_71045_bC() == null || !(player.func_71045_bC().func_77973_b() instanceof ItemInfernalChalice)) {
            return;
        }
        ItemStack infernalChaliceStack = player.func_71045_bC();
        ItemStack lavaStack = new ItemStack(Items.field_151129_at, NBTHelper.getInteger((String)"fluidStacks", (ItemStack)infernalChaliceStack), 0);
        ClientEventHandler.renderStandardTwoItemHUD(mc, (EntityPlayer)player, infernalChaliceStack, lavaStack, Reliquary.CONFIG.getInt("hud_positions", "infernal_chalice"), Colors.get("AA0000"), lavaStack.field_77994_a / 1000);
    }

    public void handleHeroMedallionHUDCheck() {
        Minecraft mc = Minecraft.func_71410_x();
        if (!Minecraft.func_71382_s() || !mc.field_71415_G) {
            return;
        }
        EntityClientPlayerMP player = mc.field_71439_g;
        if (player == null || player.func_71045_bC() == null || !(player.func_71045_bC().func_77973_b() instanceof ItemHeroMedallion)) {
            return;
        }
        ItemStack heroMedallionStack = player.func_71045_bC();
        int experience = NBTHelper.getInteger((String)"experience", (ItemStack)heroMedallionStack);
        ClientEventHandler.renderStandardTwoItemHUD(mc, (EntityPlayer)player, heroMedallionStack, null, Reliquary.CONFIG.getInt("hud_positions", "rending_gale"), Colors.get("009900"), experience);
    }

    public void handlePyromancerStaffHUDCheck() {
        Minecraft mc = Minecraft.func_71410_x();
        if (!Minecraft.func_71382_s() || !mc.field_71415_G) {
            return;
        }
        EntityClientPlayerMP player = mc.field_71439_g;
        if (player == null || player.func_71045_bC() == null || !(player.func_71045_bC().func_77973_b() instanceof ItemPyromancerStaff)) {
            return;
        }
        ItemStack pyromancerStaffStack = player.func_71045_bC();
        int charge = 0;
        int blaze = 0;
        NBTTagCompound tagCompound = NBTHelper.getTag((ItemStack)pyromancerStaffStack);
        if (tagCompound != null) {
            NBTTagList tagList = tagCompound.func_150295_c("Items", 10);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                NBTTagCompound tagItemData = tagList.func_150305_b(i);
                String itemName = tagItemData.func_74779_i("Name");
                Item containedItem = Reliquary.CONTENT.getItem(itemName);
                int quantity = tagItemData.func_74762_e("Quantity");
                if (containedItem == Items.field_151065_br) {
                    blaze = quantity;
                    continue;
                }
                if (containedItem != Items.field_151059_bz) continue;
                charge = quantity;
            }
        }
        String staffMode = ((ItemPyromancerStaff)pyromancerStaffStack.func_77973_b()).getMode(pyromancerStaffStack);
        ItemStack fireChargeStack = new ItemStack(Items.field_151059_bz, charge, 0);
        ItemStack blazePowderStack = new ItemStack(Items.field_151065_br, blaze, 0);
        ClientEventHandler.renderPyromancerStaffHUD(mc, (EntityPlayer)player, pyromancerStaffStack, fireChargeStack, blazePowderStack, staffMode);
    }

    private static void renderPyromancerStaffHUD(Minecraft minecraft, EntityPlayer player, ItemStack hudStack, ItemStack secondaryStack, ItemStack tertiaryStack, String staffMode) {
        int color = Colors.get("FFFFFF");
        float overlayScale = 2.5f;
        float overlayOpacity = 0.75f;
        GL11.glPushMatrix();
        ScaledResolution sr = new ScaledResolution(minecraft, minecraft.field_71443_c, minecraft.field_71440_d);
        GL11.glClear((int)256);
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)sr.func_78327_c(), (double)sr.func_78324_d(), (double)0.0, (double)1000.0, (double)3000.0);
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-2000.0f);
        GL11.glPushMatrix();
        RenderHelper.func_74520_c();
        GL11.glDisable((int)2896);
        GL11.glEnable((int)32826);
        GL11.glEnable((int)2903);
        GL11.glEnable((int)2896);
        int hudOverlayX = 0;
        int hudOverlayY = 0;
        switch (Reliquary.CONFIG.getInt("hud_positions", "pyromancer_staff")) {
            case 0: {
                hudOverlayX = 0;
                hudOverlayY = 0;
                break;
            }
            case 1: {
                hudOverlayX = (int)((float)sr.func_78326_a() - 16.0f * overlayScale);
                hudOverlayY = 0;
                break;
            }
            case 2: {
                hudOverlayX = 0;
                hudOverlayY = (int)((float)sr.func_78328_b() - 16.0f * overlayScale);
                break;
            }
            case 3: {
                hudOverlayX = (int)((float)sr.func_78326_a() - 16.0f * overlayScale);
                hudOverlayY = (int)((float)sr.func_78328_b() - 16.0f * overlayScale);
                break;
            }
        }
        ClientEventHandler.renderItemIntoGUI(minecraft.field_71466_p, hudStack, hudOverlayX, hudOverlayY, overlayOpacity, overlayScale);
        String friendlyStaffMode = "";
        if (staffMode.equals("eruption")) {
            friendlyStaffMode = "ERUPT";
        }
        if (secondaryStack != null && staffMode.equals("charge")) {
            itemRenderer.func_82406_b(minecraft.field_71466_p, minecraft.func_110434_K(), secondaryStack, hudOverlayX, hudOverlayY + 24);
            minecraft.field_71466_p.func_78261_a(Integer.toString(secondaryStack.field_77994_a), hudOverlayX + 15, hudOverlayY + 30, color);
        } else if (tertiaryStack != null && (staffMode.equals("eruption") || staffMode.equals("blaze"))) {
            itemRenderer.func_82406_b(minecraft.field_71466_p, minecraft.func_110434_K(), tertiaryStack, hudOverlayX, hudOverlayY + 24);
            minecraft.field_71466_p.func_78261_a(Integer.toString(tertiaryStack.field_77994_a), hudOverlayX + 15, hudOverlayY + 30, color);
            if (staffMode.equals("eruption")) {
                minecraft.field_71466_p.func_78261_a(friendlyStaffMode, hudOverlayX, hudOverlayY + 18, color);
            }
        } else if (staffMode.equals("flint_and_steel")) {
            itemRenderer.func_82406_b(minecraft.field_71466_p, minecraft.func_110434_K(), new ItemStack(Items.field_151033_d, 1, 0), hudOverlayX, hudOverlayY + 24);
        }
        GL11.glDisable((int)2896);
        GL11.glPopMatrix();
        GL11.glPopMatrix();
    }

    public void handleRendingGaleHUDCheck() {
        Minecraft mc = Minecraft.func_71410_x();
        if (!Minecraft.func_71382_s() || !mc.field_71415_G) {
            return;
        }
        EntityClientPlayerMP player = mc.field_71439_g;
        if (player == null || player.func_71045_bC() == null || !(player.func_71045_bC().func_77973_b() instanceof ItemRendingGale)) {
            return;
        }
        ItemStack rendingGaleStack = player.func_71045_bC();
        ItemStack featherStack = new ItemStack(Items.field_151008_G, NBTHelper.getInteger((String)"feathers", (ItemStack)rendingGaleStack), 0);
        int charge = featherStack.field_77994_a;
        if (player.func_71039_bw()) {
            int count = rendingGaleStack.func_77973_b().func_77626_a(rendingGaleStack) - (player.func_71052_bv() - 1);
            charge -= count * ItemRendingGale.getChargeCost();
        }
        ClientEventHandler.renderStandardTwoItemHUD(mc, (EntityPlayer)player, rendingGaleStack, featherStack, Reliquary.CONFIG.getInt("hud_positions", "rending_gale"), 0, Math.max(charge /= 100, 0));
    }

    public void handleHandgunHUDCheck() {
        Minecraft mc = Minecraft.func_71410_x();
        if (!Minecraft.func_71382_s() || !mc.field_71415_G) {
            return;
        }
        EntityClientPlayerMP player = mc.field_71439_g;
        if (player == null || player.func_71045_bC() == null || !(player.func_71045_bC().func_77973_b() instanceof ItemHandgun)) {
            return;
        }
        ItemStack handgunStack = player.func_71045_bC();
        ItemHandgun handgunItem = (ItemHandgun)handgunStack.func_77973_b();
        ItemStack bulletStack = new ItemStack(Reliquary.CONTENT.getItem("bullet"), handgunItem.getBulletCount(handgunStack), handgunItem.getBulletType(handgunStack));
        ClientEventHandler.renderHandgunHUD(mc, (EntityPlayer)player, handgunStack, bulletStack);
    }

    private static void renderHandgunHUD(Minecraft minecraft, EntityPlayer player, ItemStack handgunStack, ItemStack bulletStack) {
        float overlayScale = 2.5f;
        float overlayOpacity = 0.75f;
        GL11.glPushMatrix();
        ScaledResolution sr = new ScaledResolution(minecraft, minecraft.field_71443_c, minecraft.field_71440_d);
        GL11.glClear((int)256);
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)sr.func_78327_c(), (double)sr.func_78324_d(), (double)0.0, (double)1000.0, (double)3000.0);
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-2000.0f);
        GL11.glPushMatrix();
        RenderHelper.func_74520_c();
        GL11.glDisable((int)2896);
        GL11.glEnable((int)32826);
        GL11.glEnable((int)2903);
        GL11.glEnable((int)2896);
        int hudOverlayX = 0;
        int hudOverlayY = 0;
        switch (Reliquary.CONFIG.getInt("hud_positions", "handgun")) {
            case 0: {
                hudOverlayX = 0;
                hudOverlayY = 0;
                break;
            }
            case 1: {
                hudOverlayX = (int)((float)sr.func_78326_a() - 16.0f * overlayScale);
                hudOverlayY = 0;
                break;
            }
            case 2: {
                hudOverlayX = 0;
                hudOverlayY = (int)((float)sr.func_78328_b() - 16.0f * overlayScale);
                break;
            }
            case 3: {
                hudOverlayX = (int)((float)sr.func_78326_a() - 16.0f * overlayScale);
                hudOverlayY = (int)((float)sr.func_78328_b() - 16.0f * overlayScale);
                break;
            }
        }
        ClientEventHandler.renderItemIntoGUI(minecraft.field_71466_p, handgunStack, hudOverlayX, hudOverlayY, overlayOpacity, overlayScale);
        if (bulletStack.field_77994_a == 0) {
            if (ClientEventHandler.getTime() % 32 > 16) {
                ClientEventHandler.renderItemIntoGUI(minecraft.field_71466_p, new ItemStack(Reliquary.CONTENT.getItem("magazine"), 1, 0), hudOverlayX - 8, hudOverlayY + 12, overlayOpacity, overlayScale / 2.0f);
            }
        } else {
            for (int xOffset = 0; xOffset < bulletStack.field_77994_a; ++xOffset) {
                ClientEventHandler.renderItemIntoGUI(minecraft.field_71466_p, bulletStack, hudOverlayX - 8 - xOffset * 10, hudOverlayY + 12, 1.0f, overlayScale / 2.0f);
            }
        }
        GL11.glDisable((int)2896);
        GL11.glPopMatrix();
        GL11.glPopMatrix();
    }

    public void handleSojournerHUDCheck() {
        Minecraft mc = Minecraft.func_71410_x();
        if (!Minecraft.func_71382_s() || !mc.field_71415_G) {
            return;
        }
        EntityClientPlayerMP player = mc.field_71439_g;
        if (player == null || player.func_71045_bC() == null || !(player.func_71045_bC().func_77973_b() instanceof ItemSojournerStaff)) {
            return;
        }
        ItemStack sojournerStack = player.func_71045_bC();
        ItemSojournerStaff sojournerItem = (ItemSojournerStaff)sojournerStack.func_77973_b();
        String placementItemName = sojournerItem.getTorchPlacementMode(sojournerStack);
        int amountOfItem = sojournerItem.getTorchCount(sojournerStack);
        Item placementItem = null;
        if (placementItemName != null) {
            placementItem = Reliquary.CONTENT.getItem(placementItemName);
        }
        ItemStack placementStack = null;
        if (placementItem != null) {
            placementStack = new ItemStack(placementItem, amountOfItem, 0);
        }
        ClientEventHandler.renderStandardTwoItemHUD(mc, (EntityPlayer)player, sojournerStack, placementStack, Reliquary.CONFIG.getInt("hud_positions", "sojourner_staff"), 0, 0);
    }

    private static void renderStandardTwoItemHUD(Minecraft minecraft, EntityPlayer player, ItemStack hudStack, ItemStack secondaryStack, int hudPosition, int colorOverride, int stackSizeOverride) {
        int stackSize = 0;
        if (stackSizeOverride > 0) {
            stackSize = stackSizeOverride;
        }
        int color = Colors.get("FFFFFF");
        if (colorOverride > 0) {
            color = colorOverride;
        }
        float overlayScale = 2.5f;
        float overlayOpacity = 0.75f;
        GL11.glPushMatrix();
        ScaledResolution sr = new ScaledResolution(minecraft, minecraft.field_71443_c, minecraft.field_71440_d);
        GL11.glClear((int)256);
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)sr.func_78327_c(), (double)sr.func_78324_d(), (double)0.0, (double)1000.0, (double)3000.0);
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-2000.0f);
        GL11.glPushMatrix();
        RenderHelper.func_74520_c();
        GL11.glDisable((int)2896);
        GL11.glEnable((int)32826);
        GL11.glEnable((int)2903);
        GL11.glEnable((int)2896);
        int hudOverlayX = 0;
        int hudOverlayY = 0;
        switch (hudPosition) {
            case 0: {
                hudOverlayX = 0;
                hudOverlayY = 0;
                break;
            }
            case 1: {
                hudOverlayX = (int)((float)sr.func_78326_a() - 16.0f * overlayScale);
                hudOverlayY = 0;
                break;
            }
            case 2: {
                hudOverlayX = 0;
                hudOverlayY = (int)((float)sr.func_78328_b() - 16.0f * overlayScale);
                break;
            }
            case 3: {
                hudOverlayX = (int)((float)sr.func_78326_a() - 16.0f * overlayScale);
                hudOverlayY = (int)((float)sr.func_78328_b() - 16.0f * overlayScale);
                break;
            }
        }
        ClientEventHandler.renderItemIntoGUI(minecraft.field_71466_p, hudStack, hudOverlayX, hudOverlayY, overlayOpacity, overlayScale);
        boolean skipStackRender = false;
        if (hudStack.func_77973_b() instanceof ItemRendingGale) {
            ItemRendingGale staffItem = (ItemRendingGale)hudStack.func_77973_b();
            String staffMode = staffItem.getMode(hudStack);
            staffMode = staffMode.equals("flight") ? "FLIGHT" : (staffMode.equals("push") ? "PUSH" : (staffMode.equals("pull") ? "PULL" : "BOLT"));
            minecraft.field_71466_p.func_78261_a(staffMode, hudOverlayX, hudOverlayY + 18, color);
        }
        if (secondaryStack != null) {
            if (stackSize == 0) {
                stackSize = secondaryStack.field_77994_a;
            }
            itemRenderer.func_82406_b(minecraft.field_71466_p, minecraft.func_110434_K(), secondaryStack, hudOverlayX, hudOverlayY + 24);
        }
        minecraft.field_71466_p.func_78261_a(Integer.toString(stackSize), hudOverlayX + 15, hudOverlayY + 30, color);
        GL11.glDisable((int)2896);
        GL11.glPopMatrix();
        GL11.glPopMatrix();
    }

    public static void renderItemIntoGUI(FontRenderer fontRenderer, ItemStack itemStack, int x, int y, float opacity, float scale) {
        if (itemStack == null) {
            return;
        }
        GL11.glDisable((int)2896);
        if (!(itemStack.func_77973_b() instanceof ItemBlock)) {
            FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(TextureMap.field_110576_c);
        } else {
            FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(TextureMap.field_110575_b);
        }
        for (int passes = 0; passes < itemStack.func_77973_b().getRenderPasses(itemStack.func_77960_j()); ++passes) {
            int overlayColour = itemStack.func_77973_b().func_82790_a(itemStack, passes);
            IIcon icon = itemStack.func_77973_b().getIcon(itemStack, passes);
            float red = (float)(overlayColour >> 16 & 0xFF) / 255.0f;
            float green = (float)(overlayColour >> 8 & 0xFF) / 255.0f;
            float blue = (float)(overlayColour & 0xFF) / 255.0f;
            GL11.glColor4f((float)red, (float)green, (float)blue, (float)opacity);
            ClientEventHandler.drawTexturedQuad(x, y, icon, 16.0f * scale, 16.0f * scale, -90.0);
            GL11.glEnable((int)2896);
        }
    }

    public static void drawTexturedQuad(int x, int y, IIcon icon, float width, float height, double zLevel) {
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)x, (double)((float)y + height), zLevel, (double)icon.func_94209_e(), (double)icon.func_94210_h());
        tessellator.func_78374_a((double)((float)x + width), (double)((float)y + height), zLevel, (double)icon.func_94212_f(), (double)icon.func_94210_h());
        tessellator.func_78374_a((double)((float)x + width), (double)y, zLevel, (double)icon.func_94212_f(), (double)icon.func_94206_g());
        tessellator.func_78374_a((double)x, (double)y, zLevel, (double)icon.func_94209_e(), (double)icon.func_94206_g());
        tessellator.func_78381_a();
    }
}

