/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.common;

import com.google.common.collect.ImmutableList;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import lib.enderwizards.sandstone.mod.config.ConfigReference;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.IProjectile;
import net.minecraftforge.common.MinecraftForge;
import xreliquary.Reliquary;
import xreliquary.blocks.tile.TileEntityAltar;
import xreliquary.blocks.tile.TileEntityCauldron;
import xreliquary.blocks.tile.TileEntityMortar;
import xreliquary.common.gui.GUIHandler;
import xreliquary.entities.EntityEnderStaffProjectile;
import xreliquary.entities.EntityGlowingWater;
import xreliquary.entities.EntityHolyHandGrenade;
import xreliquary.entities.EntityKrakenSlime;
import xreliquary.entities.EntitySpecialSnowball;
import xreliquary.entities.potion.EntityAttractionPotion;
import xreliquary.entities.potion.EntityFertilePotion;
import xreliquary.entities.potion.EntityThrownXRPotion;
import xreliquary.entities.shot.EntityBlazeShot;
import xreliquary.entities.shot.EntityBusterShot;
import xreliquary.entities.shot.EntityConcussiveShot;
import xreliquary.entities.shot.EntityEnderShot;
import xreliquary.entities.shot.EntityExorcismShot;
import xreliquary.entities.shot.EntityNeutralShot;
import xreliquary.entities.shot.EntitySandShot;
import xreliquary.entities.shot.EntitySeekerShot;
import xreliquary.entities.shot.EntityStormShot;
import xreliquary.event.CommonEventHandler;
import xreliquary.init.XRRecipes;
import xreliquary.items.ItemDestructionCatalyst;
import xreliquary.items.alkahestry.AlkahestryCraftingRecipe;
import xreliquary.items.alkahestry.AlkahestryDrainRecipe;
import xreliquary.items.alkahestry.AlkahestryRedstoneRecipe;
import xreliquary.util.alkahestry.Alkahestry;

public class CommonProxy {
    public void preInit() {
        try {
            XRRecipes.init();
            Alkahestry.init();
        }
        catch (Exception e) {
            e.printStackTrace();
            FMLCommonHandler.instance().raiseException((Throwable)e, "Reliquary failed to initiate recipies.", true);
        }
    }

    public void init() {
        AlkahestryCraftingRecipe.returnedItem = Reliquary.CONTENT.getItem("alkahest_tome");
        AlkahestryRedstoneRecipe.returnedItem = Reliquary.CONTENT.getItem("alkahest_tome");
        AlkahestryCraftingRecipe alkahestryCraftingRecipeHandler = new AlkahestryCraftingRecipe();
        AlkahestryDrainRecipe alkahestryDrainRecipeHandler = new AlkahestryDrainRecipe();
        MinecraftForge.EVENT_BUS.register((Object)alkahestryCraftingRecipeHandler);
        MinecraftForge.EVENT_BUS.register((Object)alkahestryDrainRecipeHandler);
        FMLCommonHandler.instance().bus().register((Object)alkahestryCraftingRecipeHandler);
        FMLCommonHandler.instance().bus().register((Object)alkahestryDrainRecipeHandler);
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)Reliquary.INSTANCE, (IGuiHandler)new GUIHandler());
        FMLCommonHandler.instance().bus().register((Object)new CommonEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)new CommonEventHandler());
        this.registerEntities();
        this.registerTileEntities();
    }

    public void initOptions() {
        int itemCap = 9999;
        int cleanShortMax = 30000;
        int cleanIntMax = 2000000000;
        Reliquary.CONFIG.require("hud_positions", "sojourner_staff", new ConfigReference((Object)3).setMinimumValue(Integer.valueOf(1)).setMaximumValue(Integer.valueOf(4)));
        Reliquary.CONFIG.require("hud_positions", "handgun", new ConfigReference((Object)3).setMinimumValue(Integer.valueOf(1)).setMaximumValue(Integer.valueOf(4)));
        Reliquary.CONFIG.require("hud_positions", "alkahest_tome", new ConfigReference((Object)3).setMinimumValue(Integer.valueOf(1)).setMaximumValue(Integer.valueOf(4)));
        Reliquary.CONFIG.require("hud_positions", "destruction_catalyst", new ConfigReference((Object)3).setMinimumValue(Integer.valueOf(1)).setMaximumValue(Integer.valueOf(4)));
        Reliquary.CONFIG.require("hud_positions", "elsewhere_flask", new ConfigReference((Object)3).setMinimumValue(Integer.valueOf(1)).setMaximumValue(Integer.valueOf(4)));
        Reliquary.CONFIG.require("hud_positions", "ender_staff", new ConfigReference((Object)3).setMinimumValue(Integer.valueOf(1)).setMaximumValue(Integer.valueOf(4)));
        Reliquary.CONFIG.require("hud_positions", "ice_magus_rod", new ConfigReference((Object)3).setMinimumValue(Integer.valueOf(1)).setMaximumValue(Integer.valueOf(4)));
        Reliquary.CONFIG.require("hud_positions", "glacial_staff", new ConfigReference((Object)3).setMinimumValue(Integer.valueOf(1)).setMaximumValue(Integer.valueOf(4)));
        Reliquary.CONFIG.require("hud_positions", "void_tear", new ConfigReference((Object)3).setMinimumValue(Integer.valueOf(1)).setMaximumValue(Integer.valueOf(4)));
        Reliquary.CONFIG.require("hud_positions", "midas_touchstone", new ConfigReference((Object)3).setMinimumValue(Integer.valueOf(1)).setMaximumValue(Integer.valueOf(4)));
        Reliquary.CONFIG.require("hud_positions", "harvest_rod", new ConfigReference((Object)3).setMinimumValue(Integer.valueOf(1)).setMaximumValue(Integer.valueOf(4)));
        Reliquary.CONFIG.require("hud_positions", "infernal_chalice", new ConfigReference((Object)3).setMinimumValue(Integer.valueOf(1)).setMaximumValue(Integer.valueOf(4)));
        Reliquary.CONFIG.require("hud_positions", "hero_medallion", new ConfigReference((Object)3).setMinimumValue(Integer.valueOf(1)).setMaximumValue(Integer.valueOf(4)));
        Reliquary.CONFIG.require("hud_positions", "pyromancer_staff", new ConfigReference((Object)3).setMinimumValue(Integer.valueOf(1)).setMaximumValue(Integer.valueOf(4)));
        Reliquary.CONFIG.require("hud_positions", "rending_gale", new ConfigReference((Object)3).setMinimumValue(Integer.valueOf(1)).setMaximumValue(Integer.valueOf(4)));
        Reliquary.CONFIG.require("easy_mode_recipes", "fortune_coin", new ConfigReference((Object)false));
        Reliquary.CONFIG.require("easy_mode_recipes", "altar", new ConfigReference((Object)false));
        Reliquary.CONFIG.require("easy_mode_recipes", "infernal_chalice", new ConfigReference((Object)false));
        Reliquary.CONFIG.require("easy_mode_recipes", "ender_staff", new ConfigReference((Object)false));
        Reliquary.CONFIG.require("easy_mode_recipes", "salamander_eye", new ConfigReference((Object)false));
        Reliquary.CONFIG.require("easy_mode_recipes", "rod_of_lyssa", new ConfigReference((Object)false));
        Reliquary.CONFIG.require("easy_mode_recipes", "serpent_staff", new ConfigReference((Object)false));
        Reliquary.CONFIG.require("easy_mode_recipes", "rending_gale", new ConfigReference((Object)false));
        Reliquary.CONFIG.require("easy_mode_recipes", "pyromancer_staff", new ConfigReference((Object)false));
        Reliquary.CONFIG.require("easy_mode_recipes", "magicbane", new ConfigReference((Object)false));
        Reliquary.CONFIG.require("easy_mode_recipes", "lantern_of_paranoia", new ConfigReference((Object)false));
        Reliquary.CONFIG.require("easy_mode_recipes", "alkahest_tome", new ConfigReference((Object)false));
        Reliquary.CONFIG.require("easy_mode_recipes", "wraith_node", new ConfigReference((Object)false));
        Reliquary.CONFIG.require("easy_mode_recipes", "glacial_staff", new ConfigReference((Object)false));
        Reliquary.CONFIG.require("easy_mode_recipes", "sojourner_staff", new ConfigReference((Object)false));
        Reliquary.CONFIG.require("easy_mode_recipes", "kraken_shell", new ConfigReference((Object)false));
        Reliquary.CONFIG.require("easy_mode_recipes", "angelic_feather", new ConfigReference((Object)false));
        Reliquary.CONFIG.require("easy_mode_recipes", "emperor_chalice", new ConfigReference((Object)false));
        Reliquary.CONFIG.require("easy_mode_recipes", "hero_medallion", new ConfigReference((Object)false));
        Reliquary.CONFIG.require("easy_mode_recipes", "ice_magus_rod", new ConfigReference((Object)false));
        Reliquary.CONFIG.require("easy_mode_recipes", "infernal_claws", new ConfigReference((Object)false));
        Reliquary.CONFIG.require("easy_mode_recipes", "destruction_catalyst", new ConfigReference((Object)false));
        Reliquary.CONFIG.require("easy_mode_recipes", "interdiction_torch", new ConfigReference((Object)false));
        Reliquary.CONFIG.require("easy_mode_recipes", "void_tear", new ConfigReference((Object)false));
        Reliquary.CONFIG.require("easy_mode_recipes", "infernal_tear", new ConfigReference((Object)false));
        Reliquary.CONFIG.require("easy_mode_recipes", "fertile_essence", new ConfigReference((Object)false));
        Reliquary.CONFIG.require("easy_mode_recipes", "seeker_shot", new ConfigReference((Object)false));
        Reliquary.CONFIG.require("mob_drop_probability", "necrotic_heart_zombie_base", new ConfigReference((Object)10));
        Reliquary.CONFIG.require("mob_drop_probability", "necrotic_heart_zombie_looting", new ConfigReference((Object)5));
        Reliquary.CONFIG.require("mob_drop_probability", "necrotic_heart_pigman_base", new ConfigReference((Object)15));
        Reliquary.CONFIG.require("mob_drop_probability", "necrotic_heart_pigman_looting", new ConfigReference((Object)10));
        Reliquary.CONFIG.require("mob_drop_probability", "rib_bone_base", new ConfigReference((Object)10));
        Reliquary.CONFIG.require("mob_drop_probability", "rib_bone_looting", new ConfigReference((Object)5));
        Reliquary.CONFIG.require("mob_drop_probability", "wither_rib_base", new ConfigReference((Object)10));
        Reliquary.CONFIG.require("mob_drop_probability", "wither_rib_looting", new ConfigReference((Object)5));
        Reliquary.CONFIG.require("mob_drop_probability", "spider_chelicerae_base", new ConfigReference((Object)10));
        Reliquary.CONFIG.require("mob_drop_probability", "spider_chelicerae_looting", new ConfigReference((Object)5));
        Reliquary.CONFIG.require("mob_drop_probability", "cave_spider_chelicerae_base", new ConfigReference((Object)15));
        Reliquary.CONFIG.require("mob_drop_probability", "cave_spider_chelicerae_looting", new ConfigReference((Object)10));
        Reliquary.CONFIG.require("mob_drop_probability", "molten_core_blaze_base", new ConfigReference((Object)15));
        Reliquary.CONFIG.require("mob_drop_probability", "molten_core_blaze_looting", new ConfigReference((Object)10));
        Reliquary.CONFIG.require("mob_drop_probability", "molten_core_magma_cube_base", new ConfigReference((Object)10));
        Reliquary.CONFIG.require("mob_drop_probability", "molten_core_magma_cube_looting", new ConfigReference((Object)5));
        Reliquary.CONFIG.require("mob_drop_probability", "frozen_core_base", new ConfigReference((Object)10));
        Reliquary.CONFIG.require("mob_drop_probability", "frozen_core_looting", new ConfigReference((Object)5));
        Reliquary.CONFIG.require("mob_drop_probability", "eye_of_the_storm_base", new ConfigReference((Object)10));
        Reliquary.CONFIG.require("mob_drop_probability", "eye_of_the_storm_looting", new ConfigReference((Object)5));
        Reliquary.CONFIG.require("mob_drop_probability", "bat_wing_base", new ConfigReference((Object)10));
        Reliquary.CONFIG.require("mob_drop_probability", "bat_wing_looting", new ConfigReference((Object)5));
        Reliquary.CONFIG.require("mob_drop_probability", "catalyzing_gland_creeper_base", new ConfigReference((Object)10));
        Reliquary.CONFIG.require("mob_drop_probability", "catalyzing_gland_creeper_looting", new ConfigReference((Object)5));
        Reliquary.CONFIG.require("mob_drop_probability", "catalyzing_gland_ghast_base", new ConfigReference((Object)15));
        Reliquary.CONFIG.require("mob_drop_probability", "catalyzing_gland_ghast_looting", new ConfigReference((Object)10));
        Reliquary.CONFIG.require("mob_drop_probability", "witch_hat_base", new ConfigReference((Object)10));
        Reliquary.CONFIG.require("mob_drop_probability", "witch_hat_looting", new ConfigReference((Object)5));
        Reliquary.CONFIG.require("mob_drop_probability", "squid_beak_base", new ConfigReference((Object)10));
        Reliquary.CONFIG.require("mob_drop_probability", "squid_beak_looting", new ConfigReference((Object)5));
        Reliquary.CONFIG.require("mob_drop_probability", "slime_pearl_base", new ConfigReference((Object)10));
        Reliquary.CONFIG.require("mob_drop_probability", "slime_pearl_looting", new ConfigReference((Object)5));
        Reliquary.CONFIG.require("mob_drop_probability", "nebulous_heart_base", new ConfigReference((Object)10));
        Reliquary.CONFIG.require("mob_drop_probability", "nebulous_heart_looting", new ConfigReference((Object)5));
        Reliquary.CONFIG.require("alkahest_tome", "redstone_limit", new ConfigReference((Object)250).setMinimumValue(Integer.valueOf(0)).setMaximumValue(Integer.valueOf(itemCap)));
        Reliquary.CONFIG.require("altar", "redstone_cost", new ConfigReference((Object)3).setMinimumValue(Integer.valueOf(0)));
        Reliquary.CONFIG.require("altar", "time_in_minutes", new ConfigReference((Object)20).setMinimumValue(Integer.valueOf(0)));
        Reliquary.CONFIG.require("altar", "maximum_time_variance_in_minutes", new ConfigReference((Object)5).setMinimumValue(Integer.valueOf(0)));
        Reliquary.CONFIG.require("altar", "output_light_level_while_active", new ConfigReference((Object)16).setMaximumValue(Integer.valueOf(16)).setMinimumValue(Integer.valueOf(0)));
        Reliquary.CONFIG.require("angelic_feather", "hunger_cost_percent", new ConfigReference((Object)50).setMinimumValue(Integer.valueOf(0)));
        Reliquary.CONFIG.require("angelic_feather", "leaping_potency", new ConfigReference((Object)1).setMinimumValue(Integer.valueOf(0)).setMaximumValue(Integer.valueOf(5)));
        Reliquary.CONFIG.require("angelheart_vial", "heal_percentage_of_max_life", new ConfigReference((Object)25));
        Reliquary.CONFIG.require("angelheart_vial", "remove_negative_status", new ConfigReference((Object)true));
        ImmutableList heatSources = ImmutableList.of();
        Reliquary.CONFIG.require("apothecary_cauldron", "redstone_limit", new ConfigReference((Object)5).setMinimumValue(Integer.valueOf(0)).setMaximumValue(Integer.valueOf(100)));
        Reliquary.CONFIG.require("apothecary_cauldron", "cook_time", new ConfigReference((Object)160).setMinimumValue(Integer.valueOf(20)).setMaximumValue(Integer.valueOf(32000)));
        Reliquary.CONFIG.require("apothecary_cauldron", "heat_sources", new ConfigReference((Object)heatSources));
        Reliquary.CONFIG.require("destruction_catalyst", "mundane_blocks", new ConfigReference(new ArrayList<String>(ItemDestructionCatalyst.ids)));
        Reliquary.CONFIG.require("destruction_catalyst", "gunpowder_cost", new ConfigReference((Object)3).setMinimumValue(Integer.valueOf(0)));
        Reliquary.CONFIG.require("destruction_catalyst", "gunpowder_worth", new ConfigReference((Object)1).setMinimumValue(Integer.valueOf(0)));
        Reliquary.CONFIG.require("destruction_catalyst", "gunpowder_limit", new ConfigReference((Object)250).setMinimumValue(Integer.valueOf(0)).setMaximumValue(Integer.valueOf(itemCap)));
        Reliquary.CONFIG.require("destruction_catalyst", "explosion_radius", new ConfigReference((Object)1).setMinimumValue(Integer.valueOf(1)).setMaximumValue(Integer.valueOf(5)));
        Reliquary.CONFIG.require("destruction_catalyst", "centered_explosion", new ConfigReference((Object)false));
        Reliquary.CONFIG.require("destruction_catalyst", "perfect_cube", new ConfigReference((Object)true));
        Reliquary.CONFIG.require("emperor_chalice", "hunger_satiation_multiplier", new ConfigReference((Object)4).setMinimumValue(Integer.valueOf(0)));
        Reliquary.CONFIG.require("ender_staff", "ender_pearl_cast_cost", new ConfigReference((Object)1).setMinimumValue(Integer.valueOf(0)));
        Reliquary.CONFIG.require("ender_staff", "ender_pearl_node_warp_cost", new ConfigReference((Object)1).setMinimumValue(Integer.valueOf(0)));
        Reliquary.CONFIG.require("ender_staff", "ender_pearl_worth", new ConfigReference((Object)1).setMinimumValue(Integer.valueOf(0)));
        Reliquary.CONFIG.require("ender_staff", "ender_pearl_limit", new ConfigReference((Object)250).setMinimumValue(Integer.valueOf(0)).setMaximumValue(Integer.valueOf(itemCap)));
        Reliquary.CONFIG.require("ender_staff", "node_warp_cast_time", new ConfigReference((Object)60).setMinimumValue(Integer.valueOf(10)));
        Reliquary.CONFIG.require("fortune_coin", "disable_audio", new ConfigReference((Object)false));
        Reliquary.CONFIG.require("fortune_coin", "standard_pull_distance", new ConfigReference((Object)5));
        Reliquary.CONFIG.require("fortune_coin", "long_range_pull_distance", new ConfigReference((Object)15));
        Reliquary.CONFIG.require("glacial_staff", "snowball_limit", new ConfigReference((Object)250).setMinimumValue(Integer.valueOf(0)).setMaximumValue(Integer.valueOf(itemCap)));
        Reliquary.CONFIG.require("glacial_staff", "snowball_cost", new ConfigReference((Object)1).setMinimumValue(Integer.valueOf(0)));
        Reliquary.CONFIG.require("glacial_staff", "snowball_worth", new ConfigReference((Object)1).setMinimumValue(Integer.valueOf(0)));
        Reliquary.CONFIG.require("glacial_staff", "snowball_damage", new ConfigReference((Object)3).setMinimumValue(Integer.valueOf(0)));
        Reliquary.CONFIG.require("glacial_staff", "snowball_damage_bonus_fire_immune", new ConfigReference((Object)3).setMinimumValue(Integer.valueOf(0)));
        Reliquary.CONFIG.require("glacial_staff", "snowball_damage_bonus_blaze", new ConfigReference((Object)6).setMinimumValue(Integer.valueOf(0)));
        Reliquary.CONFIG.require("harvest_rod", "bonemeal_limit", new ConfigReference((Object)250).setMinimumValue(Integer.valueOf(0)).setMaximumValue(Integer.valueOf(itemCap)));
        Reliquary.CONFIG.require("harvest_rod", "bonemeal_cost", new ConfigReference((Object)1).setMinimumValue(Integer.valueOf(0)));
        Reliquary.CONFIG.require("harvest_rod", "bonemeal_worth", new ConfigReference((Object)1).setMinimumValue(Integer.valueOf(0)));
        Reliquary.CONFIG.require("harvest_rod", "bonemeal_luck_percent_chance", new ConfigReference((Object)33).setMinimumValue(Integer.valueOf(1)).setMaximumValue(Integer.valueOf(100)));
        Reliquary.CONFIG.require("harvest_rod", "bonemeal_luck_rolls", new ConfigReference((Object)2).setMinimumValue(Integer.valueOf(0)).setMaximumValue(Integer.valueOf(7)));
        Reliquary.CONFIG.require("harvest_rod", "harvest_break_radius", new ConfigReference((Object)2).setMinimumValue(Integer.valueOf(0)).setMaximumValue(Integer.valueOf(5)));
        Reliquary.CONFIG.require("hero_medallion", "experience_level_maximum", new ConfigReference((Object)30).setMinimumValue(Integer.valueOf(0)));
        Reliquary.CONFIG.require("hero_medallion", "experience_level_minimum", new ConfigReference((Object)0).setMinimumValue(Integer.valueOf(0)));
        Reliquary.CONFIG.require("hero_medallion", "experience_limit", new ConfigReference((Object)cleanIntMax).setMinimumValue(Integer.valueOf(0)).setMaximumValue(Integer.valueOf(cleanIntMax)));
        Reliquary.CONFIG.require("ice_magus_rod", "snowball_limit", new ConfigReference((Object)250).setMinimumValue(Integer.valueOf(0)).setMaximumValue(Integer.valueOf(itemCap)));
        Reliquary.CONFIG.require("ice_magus_rod", "snowball_cost", new ConfigReference((Object)1).setMinimumValue(Integer.valueOf(0)));
        Reliquary.CONFIG.require("ice_magus_rod", "snowball_worth", new ConfigReference((Object)1).setMinimumValue(Integer.valueOf(0)));
        Reliquary.CONFIG.require("ice_magus_rod", "snowball_damage", new ConfigReference((Object)2).setMinimumValue(Integer.valueOf(0)));
        Reliquary.CONFIG.require("ice_magus_rod", "snowball_damage_bonus_fire_immune", new ConfigReference((Object)2).setMinimumValue(Integer.valueOf(0)));
        Reliquary.CONFIG.require("ice_magus_rod", "snowball_damage_bonus_blaze", new ConfigReference((Object)4).setMinimumValue(Integer.valueOf(0)));
        Reliquary.CONFIG.require("infernal_claws", "hunger_cost_percent", new ConfigReference((Object)10).setMinimumValue(Integer.valueOf(0)));
        Reliquary.CONFIG.require("infernal_chalice", "hunger_cost_percent", new ConfigReference((Object)5).setMinimumValue(Integer.valueOf(0)));
        Reliquary.CONFIG.require("infernal_chalice", "fluid_limit", new ConfigReference((Object)500000).setMinimumValue(Integer.valueOf(0)).setMaximumValue(Integer.valueOf(cleanIntMax)));
        Reliquary.CONFIG.require("interdiction_torch", "push_radius", new ConfigReference((Object)5).setMinimumValue(Integer.valueOf(1)).setMaximumValue(Integer.valueOf(15)));
        Reliquary.CONFIG.require("interdiction_torch", "can_push_projectiles", new ConfigReference((Object)false));
        Reliquary.CONFIG.require("kraken_shell", "hunger_cost_percent", new ConfigReference((Object)25).setMinimumValue(Integer.valueOf(0)));
        Reliquary.CONFIG.require("lantern_of_paranoia", "min_light_level", new ConfigReference((Object)8).setMinimumValue(Integer.valueOf(0)).setMaximumValue(Integer.valueOf(15)));
        Reliquary.CONFIG.require("lantern_of_paranoia", "placement_scan_radius", new ConfigReference((Object)6).setMinimumValue(Integer.valueOf(1)).setMaximumValue(Integer.valueOf(15)));
        Reliquary.CONFIG.require("lilypad", "seconds_between_growth_ticks", new ConfigReference((Object)47).setMinimumValue(Integer.valueOf(1)));
        Reliquary.CONFIG.require("lilypad", "tile_range", new ConfigReference((Object)4).setMinimumValue(Integer.valueOf(1)).setMaximumValue(Integer.valueOf(15)));
        Reliquary.CONFIG.require("lilypad", "full_potency_range", new ConfigReference((Object)1).setMinimumValue(Integer.valueOf(1)).setMaximumValue(Integer.valueOf(15)));
        ImmutableList goldItems = ImmutableList.of();
        Reliquary.CONFIG.require("midas_touchstone", "gold_items", new ConfigReference((Object)goldItems));
        Reliquary.CONFIG.require("midas_touchstone", "ticks_between_repair_ticks", new ConfigReference((Object)4).setMinimumValue(Integer.valueOf(1)).setMaximumValue(Integer.valueOf(cleanShortMax)));
        Reliquary.CONFIG.require("midas_touchstone", "glowstone_cost", new ConfigReference((Object)1).setMinimumValue(Integer.valueOf(0)));
        Reliquary.CONFIG.require("midas_touchstone", "glowstone_worth", new ConfigReference((Object)4).setMinimumValue(Integer.valueOf(0)));
        Reliquary.CONFIG.require("midas_touchstone", "glowstone_limit", new ConfigReference((Object)250).setMinimumValue(Integer.valueOf(0)).setMaximumValue(Integer.valueOf(itemCap)));
        Reliquary.CONFIG.require("phoenix_down", "hunger_cost_percent", new ConfigReference((Object)25).setMinimumValue(Integer.valueOf(0)));
        Reliquary.CONFIG.require("phoenix_down", "leaping_potency", new ConfigReference((Object)1).setMinimumValue(Integer.valueOf(0)).setMaximumValue(Integer.valueOf(5)));
        Reliquary.CONFIG.require("phoenix_down", "heal_percentage_of_max_life", new ConfigReference((Object)100));
        Reliquary.CONFIG.require("phoenix_down", "remove_negative_status", new ConfigReference((Object)true));
        Reliquary.CONFIG.require("phoenix_down", "give_temporary_damage_resistance", new ConfigReference((Object)true));
        Reliquary.CONFIG.require("phoenix_down", "give_temporary_regeneration", new ConfigReference((Object)true));
        Reliquary.CONFIG.require("phoenix_down", "give_temporary_fire_resistance_if_fire_damage_killed_you", new ConfigReference((Object)true));
        Reliquary.CONFIG.require("phoenix_down", "give_temporary_water_breathing_if_drowning_killed_you", new ConfigReference((Object)true));
        Reliquary.CONFIG.require("pyromancer_staff", "hunger_cost_percent", new ConfigReference((Object)5).setMinimumValue(Integer.valueOf(0)));
        Reliquary.CONFIG.require("pyromancer_staff", "fire_charge_limit", new ConfigReference((Object)250).setMinimumValue(Integer.valueOf(0)).setMaximumValue(Integer.valueOf(itemCap)));
        Reliquary.CONFIG.require("pyromancer_staff", "fire_charge_cost", new ConfigReference((Object)1).setMinimumValue(Integer.valueOf(0)));
        Reliquary.CONFIG.require("pyromancer_staff", "fire_charge_worth", new ConfigReference((Object)1).setMinimumValue(Integer.valueOf(0)));
        Reliquary.CONFIG.require("pyromancer_staff", "ghast_absorb_worth", new ConfigReference((Object)1).setMinimumValue(Integer.valueOf(0)));
        Reliquary.CONFIG.require("pyromancer_staff", "blaze_powder_limit", new ConfigReference((Object)250).setMinimumValue(Integer.valueOf(0)).setMaximumValue(Integer.valueOf(itemCap)));
        Reliquary.CONFIG.require("pyromancer_staff", "blaze_powder_cost", new ConfigReference((Object)1).setMinimumValue(Integer.valueOf(0)));
        Reliquary.CONFIG.require("pyromancer_staff", "blaze_powder_worth", new ConfigReference((Object)1).setMinimumValue(Integer.valueOf(0)));
        Reliquary.CONFIG.require("pyromancer_staff", "blaze_absorb_worth", new ConfigReference((Object)1).setMinimumValue(Integer.valueOf(0)));
        Reliquary.CONFIG.require("rending_gale", "charge_limit", new ConfigReference((Object)cleanShortMax).setMinimumValue(Integer.valueOf(0)).setMaximumValue(Integer.valueOf(cleanIntMax)));
        Reliquary.CONFIG.require("rending_gale", "cast_charge_cost", new ConfigReference((Object)1).setMinimumValue(Integer.valueOf(0)));
        Reliquary.CONFIG.require("rending_gale", "bolt_charge_cost", new ConfigReference((Object)100).setMinimumValue(Integer.valueOf(0)));
        Reliquary.CONFIG.require("rending_gale", "charge_feather_worth", new ConfigReference((Object)100).setMinimumValue(Integer.valueOf(1)));
        Reliquary.CONFIG.require("rending_gale", "block_target_range", new ConfigReference((Object)12).setMaximumValue(Integer.valueOf(15)));
        Reliquary.CONFIG.require("rending_gale", "push_pull_radius", new ConfigReference((Object)10).setMinimumValue(Integer.valueOf(1)));
        Reliquary.CONFIG.require("rending_gale", "can_push_projectiles", new ConfigReference((Object)false));
        Reliquary.CONFIG.require("rod_of_lyssa", "use_leveled_failure_rate", new ConfigReference((Object)true));
        Reliquary.CONFIG.require("rod_of_lyssa", "level_cap_for_leveled_formula", new ConfigReference((Object)100).setMinimumValue(Integer.valueOf(1)).setMaximumValue(Integer.valueOf(900)));
        Reliquary.CONFIG.require("rod_of_lyssa", "flat_steal_failure_percent_rate", new ConfigReference((Object)10).setMinimumValue(Integer.valueOf(0)).setMaximumValue(Integer.valueOf(100)));
        Reliquary.CONFIG.require("rod_of_lyssa", "steal_from_vacant_slots", new ConfigReference((Object)true));
        Reliquary.CONFIG.require("rod_of_lyssa", "fail_steal_from_vacant_slots", new ConfigReference((Object)false));
        Reliquary.CONFIG.require("rod_of_lyssa", "anger_on_steal_failure", new ConfigReference((Object)true));
        ImmutableList torches = ImmutableList.of();
        Reliquary.CONFIG.require("sojourner_staff", "torches", new ConfigReference((Object)torches));
        Reliquary.CONFIG.require("sojourner_staff", "max_capacity_per_item_type", new ConfigReference((Object)1500).setMinimumValue(Integer.valueOf(1)).setMaximumValue(Integer.valueOf(itemCap)));
        Reliquary.CONFIG.require("sojourner_staff", "max_range", new ConfigReference((Object)30).setMinimumValue(Integer.valueOf(1)).setMaximumValue(Integer.valueOf(30)));
        Reliquary.CONFIG.require("sojourner_staff", "tile_per_cost_multiplier", new ConfigReference((Object)6).setMinimumValue(Integer.valueOf(6)).setMaximumValue(Integer.valueOf(30)));
        Reliquary.CONFIG.require("twilight_cloak", "max_light_level", new ConfigReference((Object)4).setMinimumValue(Integer.valueOf(0)).setMaximumValue(Integer.valueOf(15)));
        Reliquary.CONFIG.require("void_tear", "item_limit", new ConfigReference((Object)2000000000).setMinimumValue(Integer.valueOf(0)).setMaximumValue(Integer.valueOf(cleanIntMax)));
        Reliquary.CONFIG.require("void_tear", "absorb_when_created", new ConfigReference((Object)true));
    }

    public void postInit() {
        ArrayList<String> entityNames = new ArrayList<String>();
        for (Object o : EntityList.field_75625_b.values()) {
            Class c = (Class)o;
            if (!EntityLiving.class.isAssignableFrom(c)) continue;
            entityNames.add((String)EntityList.field_75626_c.get(o));
        }
        ArrayList<String> projectileNames = new ArrayList<String>();
        for (Object o : EntityList.field_75625_b.values()) {
            Class c = (Class)o;
            if (!IProjectile.class.isAssignableFrom(c)) continue;
            projectileNames.add((String)EntityList.field_75626_c.get(o));
        }
        Reliquary.CONFIG.require("interdiction_torch", "entities_that_can_be_pushed", new ConfigReference(entityNames));
        Reliquary.CONFIG.require("interdiction_torch", "projectiles_that_can_be_pushed", new ConfigReference(projectileNames));
        Reliquary.CONFIG.require("rending_gale", "entities_that_can_be_pushed", new ConfigReference(entityNames));
        Reliquary.CONFIG.require("rending_gale", "projectiles_that_can_be_pushed", new ConfigReference(projectileNames));
        Reliquary.CONFIG.require("seeker_shot", "entities_that_can_be_hunted", new ConfigReference(entityNames));
    }

    public void initRecipeDisablers() {
        for (int i = 0; i < Reliquary.CONTENT.registeredObjectNames.size(); ++i) {
            Reliquary.CONFIG.require("recipe_enabled", ((String)Reliquary.CONTENT.registeredObjectNames.get(i)).replace(':', '_'), new ConfigReference((Object)true));
        }
    }

    public void registerTileEntities() {
        GameRegistry.registerTileEntity(TileEntityAltar.class, (String)"reliquaryAltar");
        GameRegistry.registerTileEntity(TileEntityMortar.class, (String)"apothecaryMortar");
        GameRegistry.registerTileEntity(TileEntityCauldron.class, (String)"reliquaryCauldron");
    }

    public void registerEntities() {
        EntityRegistry.registerModEntity(EntityHolyHandGrenade.class, (String)"entityHGrenade", (int)0, (Object)Reliquary.INSTANCE, (int)128, (int)5, (boolean)true);
        EntityRegistry.registerModEntity(EntityGlowingWater.class, (String)"entityHolyWater", (int)1, (Object)Reliquary.INSTANCE, (int)128, (int)5, (boolean)true);
        EntityRegistry.registerModEntity(EntitySpecialSnowball.class, (String)"entitySpecialSnowball", (int)2, (Object)Reliquary.INSTANCE, (int)128, (int)5, (boolean)true);
        EntityRegistry.registerModEntity(EntityNeutralShot.class, (String)"entityNeutralShot", (int)3, (Object)Reliquary.INSTANCE, (int)128, (int)5, (boolean)true);
        EntityRegistry.registerModEntity(EntityExorcismShot.class, (String)"entityExorcismShot", (int)4, (Object)Reliquary.INSTANCE, (int)128, (int)5, (boolean)true);
        EntityRegistry.registerModEntity(EntityBlazeShot.class, (String)"entityBlazeShot", (int)5, (Object)Reliquary.INSTANCE, (int)128, (int)5, (boolean)true);
        EntityRegistry.registerModEntity(EntityEnderShot.class, (String)"entityEnderShot", (int)6, (Object)Reliquary.INSTANCE, (int)128, (int)5, (boolean)true);
        EntityRegistry.registerModEntity(EntityConcussiveShot.class, (String)"entityConcussiveShot", (int)7, (Object)Reliquary.INSTANCE, (int)128, (int)5, (boolean)true);
        EntityRegistry.registerModEntity(EntityBusterShot.class, (String)"entityBusterShot", (int)8, (Object)Reliquary.INSTANCE, (int)128, (int)5, (boolean)true);
        EntityRegistry.registerModEntity(EntitySeekerShot.class, (String)"entitySeekerShot", (int)9, (Object)Reliquary.INSTANCE, (int)128, (int)5, (boolean)true);
        EntityRegistry.registerModEntity(EntitySandShot.class, (String)"entitySandShot", (int)10, (Object)Reliquary.INSTANCE, (int)128, (int)5, (boolean)true);
        EntityRegistry.registerModEntity(EntityStormShot.class, (String)"entityStormShot", (int)11, (Object)Reliquary.INSTANCE, (int)128, (int)5, (boolean)true);
        EntityRegistry.registerModEntity(EntityAttractionPotion.class, (String)"entitySplashAphrodite", (int)12, (Object)Reliquary.INSTANCE, (int)128, (int)5, (boolean)true);
        EntityRegistry.registerModEntity(EntityThrownXRPotion.class, (String)"entityThrownPotion", (int)13, (Object)Reliquary.INSTANCE, (int)128, (int)5, (boolean)true);
        EntityRegistry.instance().lookupModSpawn(EntityThrownXRPotion.class, false).setCustomSpawning(null, false);
        EntityRegistry.registerModEntity(EntityFertilePotion.class, (String)"entitySplashFertility", (int)21, (Object)Reliquary.INSTANCE, (int)128, (int)5, (boolean)true);
        EntityRegistry.registerModEntity(EntityKrakenSlime.class, (String)"entityKSlime", (int)22, (Object)Reliquary.INSTANCE, (int)128, (int)5, (boolean)true);
        EntityRegistry.registerModEntity(EntityEnderStaffProjectile.class, (String)"entityEnderStaffProjectile", (int)23, (Object)Reliquary.INSTANCE, (int)128, (int)5, (boolean)true);
    }
}

