/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.lookingglass.proxyworld;

import com.xcompwiz.lookingglass.client.proxyworld.ProxyWorldManager;
import com.xcompwiz.lookingglass.log.LoggerUtils;
import com.xcompwiz.lookingglass.proxyworld.ChunkFinderManager;
import com.xcompwiz.lookingglass.render.PerspectiveRenderManager;
import com.xcompwiz.lookingglass.render.WorldViewRenderManager;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;

public class LookingGlassEventHandler {
    private final PrintStream printstream;
    private WorldClient previousWorld;
    private int tickcounter;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LookingGlassEventHandler(File logfile) {
        PrintStream stream = null;
        try {
            stream = new PrintStream(logfile);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        finally {
            this.printstream = stream;
        }
        if (this.printstream == null) {
            throw new RuntimeException("Could not set up debug exception logger file for Proxy World system");
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71441_e == null) {
            return;
        }
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        if (this.tickcounter++ % 200 == 0) {
            ProxyWorldManager.detectFreedWorldViews();
        }
        if (mc.field_71441_e != this.previousWorld) {
            if (this.previousWorld != null) {
                this.previousWorld.func_73022_a();
            }
            this.previousWorld = mc.field_71441_e;
            ProxyWorldManager.handleWorldChange(mc.field_71441_e);
        }
        WorldClient worldBackup = mc.field_71441_e;
        for (WorldClient proxyworld : ProxyWorldManager.getProxyworlds()) {
            if (proxyworld.field_73016_r > 0) {
                --proxyworld.field_73016_r;
            }
            if (worldBackup == proxyworld) continue;
            try {
                mc.field_71441_e = proxyworld;
                proxyworld.func_72835_b();
            }
            catch (Exception e) {
                LoggerUtils.error("Client Proxy Dim had error while ticking: %s", e.getLocalizedMessage());
                e.printStackTrace(this.printstream);
            }
        }
        mc.field_71441_e = worldBackup;
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onRenderTick(TickEvent.RenderTickEvent event) {
        if (Minecraft.func_71410_x().field_71441_e == null) {
            return;
        }
        if (event.phase == TickEvent.Phase.START) {
            PerspectiveRenderManager.onRenderTick(this.printstream);
            return;
        }
        if (event.phase == TickEvent.Phase.END) {
            WorldViewRenderManager.onRenderTick(this.printstream);
            return;
        }
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        ChunkFinderManager.instance.tick();
    }

    @SubscribeEvent
    public void onClientDisconnect(FMLNetworkEvent.ClientDisconnectionFromServerEvent event) {
        ProxyWorldManager.clearProxyworlds();
    }
}

