/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.lookingglass.network.packet;

import com.xcompwiz.lookingglass.client.proxyworld.ProxyWorldManager;
import com.xcompwiz.lookingglass.client.proxyworld.WorldView;
import com.xcompwiz.lookingglass.log.LoggerUtils;
import com.xcompwiz.lookingglass.network.packet.PacketBase;
import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import io.netty.buffer.ByteBuf;
import java.util.Collection;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.WorldServer;

public class PacketWorldInfo
extends PacketBase {
    public static FMLProxyPacket createPacket(int dimension) {
        WorldServer world = MinecraftServer.func_71276_C().func_71218_a(dimension);
        if (world == null) {
            LoggerUtils.warn("Server-side world for dimension %i is null!", dimension);
            return null;
        }
        ChunkCoordinates cc = world.field_73011_w.getSpawnPoint();
        int posX = cc.field_71574_a;
        int posY = cc.field_71572_b;
        int posZ = cc.field_71573_c;
        int skylightSubtracted = world.field_73008_k;
        float thunderingStrength = world.field_73017_q;
        float rainingStrength = world.field_73004_o;
        long worldTime = world.field_73011_w.getWorldTime();
        ByteBuf data = PacketBase.createDataBuffer(new Object(){}.getClass().getEnclosingClass());
        data.writeInt(dimension);
        data.writeInt(posX);
        data.writeInt(posY);
        data.writeInt(posZ);
        data.writeInt(skylightSubtracted);
        data.writeFloat(thunderingStrength);
        data.writeFloat(rainingStrength);
        data.writeLong(worldTime);
        return PacketWorldInfo.buildPacket(data);
    }

    @Override
    public void handle(ByteBuf in, EntityPlayer player) {
        int dimension = in.readInt();
        int posX = in.readInt();
        int posY = in.readInt();
        int posZ = in.readInt();
        int skylightSubtracted = in.readInt();
        float thunderingStrength = in.readFloat();
        float rainingStrength = in.readFloat();
        long worldTime = in.readLong();
        WorldClient proxyworld = ProxyWorldManager.getProxyworld(dimension);
        if (proxyworld == null) {
            return;
        }
        if (proxyworld.field_73011_w.field_76574_g != dimension) {
            return;
        }
        ChunkCoordinates cc = new ChunkCoordinates();
        cc.func_71571_b(posX, posY, posZ);
        Collection<WorldView> views = ProxyWorldManager.getWorldViews(dimension);
        for (WorldView view : views) {
            view.updateWorldSpawn(cc);
        }
        proxyworld.func_72950_A(posX, posY, posZ);
        proxyworld.field_73008_k = skylightSubtracted;
        proxyworld.field_73017_q = thunderingStrength;
        proxyworld.func_72894_k(rainingStrength);
        proxyworld.func_72877_b(worldTime);
    }
}

