/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.lookingglass.imc;

import com.xcompwiz.lookingglass.api.APIInstanceProvider;
import com.xcompwiz.lookingglass.api.impl.InternalAPI;
import com.xcompwiz.lookingglass.imc.IMCHandler;
import com.xcompwiz.lookingglass.log.LoggerUtils;
import cpw.mods.fml.common.event.FMLInterModComms;
import java.lang.reflect.Method;

public class IMCAPIRegister
implements IMCHandler.IMCProcessor {
    @Override
    public void process(FMLInterModComms.IMCMessage message) {
        if (!message.isStringMessage()) {
            return;
        }
        LoggerUtils.info(String.format("Receiving API registration request from [%s] for method %s", message.getSender(), message.getStringValue()), new Object[0]);
        IMCAPIRegister.callbackRegistration(message.getStringValue(), message.getSender());
    }

    public static void callbackRegistration(String method, String modname) {
        String[] splitName = method.split("\\.");
        String methodName = splitName[splitName.length - 1];
        String className = method.substring(0, method.length() - methodName.length() - 1);
        APIInstanceProvider providerinst = InternalAPI.getAPIProviderInstance(modname);
        if (providerinst == null) {
            LoggerUtils.error(String.format("Could not initialize API provider instance for %s", modname), new Object[0]);
            return;
        }
        LoggerUtils.info(String.format("Trying to call (reflection) %s %s", className, methodName), new Object[0]);
        try {
            Class<?> reflectClass = Class.forName(className);
            Method reflectMethod = reflectClass.getDeclaredMethod(methodName, APIInstanceProvider.class);
            reflectMethod.invoke(null, providerinst);
            LoggerUtils.info(String.format("API provided to %s", modname), new Object[0]);
        }
        catch (ClassNotFoundException e) {
            LoggerUtils.error(String.format("Could not find class %s", className), new Object[0]);
        }
        catch (NoSuchMethodException e) {
            LoggerUtils.error(String.format("Could not find method %s", methodName), new Object[0]);
        }
        catch (Exception e) {
            LoggerUtils.error(String.format("Exception while calling the method %s.%s", className, methodName), new Object[0]);
            e.printStackTrace();
        }
    }
}

