/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.lookingglass.api.animator;

import com.xcompwiz.lookingglass.api.animator.ICameraAnimator;
import com.xcompwiz.lookingglass.api.view.IViewCamera;
import net.minecraft.entity.Entity;
import net.minecraft.util.ChunkCoordinates;

public class CameraAnimatorPlayer
implements ICameraAnimator {
    private final IViewCamera camera;
    private Entity reference;
    private Entity player;
    private ChunkCoordinates target;
    private boolean updateY;
    private float accum;

    public CameraAnimatorPlayer(IViewCamera camera, Entity reference, Entity player) {
        this.camera = camera;
        this.reference = reference;
        this.player = player;
    }

    @Override
    public void setTarget(ChunkCoordinates target) {
        this.target = new ChunkCoordinates(target);
    }

    @Override
    public void refresh() {
        this.updateY = true;
    }

    @Override
    public void update(float dt) {
        float f;
        if (this.reference.field_70170_p.field_73011_w.field_76574_g != this.player.field_70170_p.field_73011_w.field_76574_g) {
            return;
        }
        this.accum += dt;
        if (f >= 1000.0f) {
            this.updateY = true;
            this.accum -= 1000.0f;
        }
        if (this.updateY) {
            this.updateTargetPosition();
        }
        double dx = this.player.field_70165_t - this.reference.field_70165_t;
        double dy = this.player.field_70163_u - (this.reference.field_70163_u + (double)this.player.field_70129_M);
        double dz = this.player.field_70161_v - this.reference.field_70161_v;
        double length = Math.sqrt(dx * dx + dz * dz + dy * dy);
        float yaw = -((float)Math.atan2(dx, dz));
        yaw = (float)((double)yaw * 57.29577951308232);
        float pitch = (float)Math.asin(dy / length);
        pitch = (float)((double)pitch * 57.29577951308232);
        this.camera.setLocation(this.target.field_71574_a, this.target.field_71572_b, this.target.field_71573_c);
        this.camera.setYaw(yaw);
        this.camera.setPitch(pitch);
    }

    private void updateTargetPosition() {
        this.updateY = false;
        int x = this.target.field_71574_a;
        int y = this.target.field_71572_b;
        int z = this.target.field_71573_c;
        if (!this.camera.chunkExists(x, z)) {
            if (this.camera.getBlockData().func_147439_a(x, y, z).func_149655_b(this.camera.getBlockData(), x, y, z)) {
                while (y > 0 && this.camera.getBlockData().func_147439_a(x, --y, z).func_149655_b(this.camera.getBlockData(), x, y, z)) {
                }
                y = y == 0 ? this.target.field_71572_b : (y += 2);
            } else {
                while (y < 256 && !this.camera.getBlockData().func_147439_a(x, ++y, z).func_149655_b(this.camera.getBlockData(), x, y, z)) {
                }
                y = y == 256 ? this.target.field_71572_b : ++y;
            }
            this.target.field_71572_b = y;
        }
    }
}

